/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class TbBlob
extends TbLob
implements Blob {
    private static final TbBlob EMPTY_BLOB = new TbBlob(null, new byte[1], false);

    public TbBlob(TbConnection conn, byte[] locator, boolean freeTmpLobOnEOF) {
        super(conn, locator, freeTmpLobOnEOF);
    }

    public static TbBlob createEmptyBlob() {
        return EMPTY_BLOB;
    }

    public static TbBlob createTemporary(Connection conn) throws SQLException {
        Debug.logMethod("TbBlob.createTemporary", new String[]{"conn"}, new Object[]{conn});
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-590713);
        }
        return ((TbConnection)conn).createTbBlob();
    }

    public static void freeTemporary(TbBlob blob) throws SQLException {
        Debug.logMethod("TbBlob.freeTemporary", new String[]{"blob"}, new Object[]{blob});
        if (blob == null) {
            throw TbError.newSQLException(-590713);
        }
        blob.free();
    }

    public void freeTemporary() throws SQLException {
        this.free();
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.setBinaryStream(pos);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Debug.logMethod("TbBlob.getBinaryStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this, 1L, Integer.MAX_VALUE);
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        Debug.logMethod("TbBlob.getBinaryStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        return new TbLobInputStream(this, pos, len);
    }

    private TbBlobAccessor getBlobAccessor() {
        return this.getConnection().getBlobAccessor();
    }

    @Override
    protected TbLobAccessor getLobAccessor() {
        return this.getBlobAccessor();
    }

    public long getBytes(long pos, byte[] buffer) throws SQLException {
        return this.getBytes(pos, buffer, 0L, buffer.length);
    }

    public long getBytes(long pos, byte[] buffer, long len) throws SQLException {
        return this.getBytes(pos, buffer, 0L, len);
    }

    public long getBytes(long pos, byte[] buffer, long bufOffset, long len) throws SQLException {
        Debug.logMethod("TbBlob.getBytes", new Object[]{this, Long.toString(pos), Long.toString(len), Long.toString(bufOffset), buffer});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        if (len > (long)buffer.length) {
            len = buffer.length;
        }
        if (len == 0L) {
            return 0L;
        }
        long readLen = this.getBlobAccessor().read(this, pos - 1L, buffer, bufOffset, len);
        long lenInternal = this.getLengthInternal();
        if (lenInternal > -1L && pos == 1L && lenInternal <= readLen && this.getIsTempLob() && this.freeTmpLobOnEOF()) {
            Debug.log("Implicit blob free. " + this.toString());
            this.getLobAccessor().freeTemporary(this);
        }
        return readLen;
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        Debug.logMethod("TbBlob.getBytes", new Object[]{this, Long.toString(pos), Integer.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0) {
            throw TbError.newSQLException(-590765, len);
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] ret = null;
        byte[] buf = new byte[len];
        long numRead = this.getBytes(pos, buf);
        if (numRead < (long)len) {
            ret = new byte[(int)numRead];
            System.arraycopy(buf, 0, ret, 0, (int)numRead);
            buf = null;
        } else if (numRead == (long)len) {
            ret = buf;
        }
        return ret;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return super.position((TbLob)((Object)pattern), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        Debug.logMethod("TbBlob.position", new Object[]{this, pattern, Long.toString(start)});
        this.checkInvalidActionOnEmpty();
        if (start < 1L) {
            throw TbError.newSQLException(-590766, start);
        }
        return this.getBlobAccessor().position(this, pattern, start - 1L);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        Debug.logMethod("TbBlob.setBinaryStream", new Object[]{this, Long.toString(pos)});
        this.checkInvalidActionOnEmpty();
        return new TbLobOutputStream(this, pos == 0L ? 1L : pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] buf, int bufOffset, int len) throws SQLException {
        Debug.logMethod("TbBlob.setBytes", new Object[]{this, Long.toString(pos), buf, Integer.toString(bufOffset), Integer.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0) {
            throw TbError.newSQLException(-590765, len);
        }
        if (bufOffset + len > buf.length) {
            len = buf.length - bufOffset;
        }
        if (len <= 0) {
            return 0;
        }
        return (int)this.getBlobAccessor().write(this, pos - 1L, buf, bufOffset, len);
    }
}

