/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TbArrayDescriptor
extends TbTypeDescriptor {
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";
    private TbConnection conn;
    private int elementType;
    private String elementTypeName;
    private int elementsLimit;

    protected TbArrayDescriptor(String sqlTypeName, Connection conn) throws SQLException {
        this.init(29, null, sqlTypeName.toUpperCase());
        this.conn = (TbConnection)conn;
    }

    protected TbArrayDescriptor(int kind, String hexEncodedOID, String sqlTypeName, int elementType, String elementTypeName, int elementLimit, TbConnection conn) throws SQLException {
        this.init(kind, hexEncodedOID, sqlTypeName);
        this.elementType = elementType;
        this.elementTypeName = elementTypeName;
        this.elementsLimit = elementLimit;
        this.conn = conn;
    }

    public static TbArrayDescriptor createDescriptor(String sqlTypeName, Connection conn) throws SQLException {
        Debug.logMethod("TbArrayDescriptor.createDescriptor", new Object[]{sqlTypeName, conn});
        if (sqlTypeName == null || sqlTypeName.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + sqlTypeName + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        if (!tbconn.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String fullTypeName = sqlTypeName.toUpperCase();
        Object obj = tbconn.getDescriptor(fullTypeName);
        if (obj instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        String[] tokens = TbTypeDescriptor.splitSQLTypeName(fullTypeName);
        if (tokens.length != 2) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + sqlTypeName + "]");
        }
        return TbArrayDescriptor.lookupUdtMeta(tokens[0], tokens[1], tbconn);
    }

    public static TbArrayDescriptor createDescriptor(int kind, String hexEncodedOID, Connection conn) throws SQLException {
        Debug.logMethod("TbArrayDescriptor.createDescriptor", new Object[]{String.valueOf(kind), hexEncodedOID, conn});
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID[" + hexEncodedOID + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        Object obj = tbconn.getDescriptor(_DESC_OID_PREFIX + hexEncodedOID);
        if (obj instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbArrayDescriptor.lookupUdtMeta(hexEncodedOID, tbconn);
    }

    public static TbArrayDescriptor createDescriptor(int kind, String hexEncodedOID, int tobjID, int versionNo, Connection conn) throws SQLException {
        Debug.logMethod("TbArrayDescriptor.createDescriptor", new Object[]{String.valueOf(kind), hexEncodedOID, conn});
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID[" + hexEncodedOID + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        Object obj = tbconn.getDescriptor(_DESC_OID_PREFIX + hexEncodedOID + _DESC_TOBJ_ID_PREFIX + tobjID + _DESC_VERSION_NO_PREFIX + versionNo);
        if (obj instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbArrayDescriptor.lookupUdtMeta(hexEncodedOID, tbconn);
    }

    public int getBaseType() throws SQLException {
        return DataType.getSqlType(this.elementType);
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public int getElementsLimit() {
        return this.elementsLimit;
    }

    public static TbArrayDescriptor lookupUdtMeta(String schemaName, String typeName, TbConnection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.lookupUdtMeta", new Object[]{schemaName, typeName, conn});
        if ("SYS.UDT_META_T".equalsIgnoreCase(schemaName + "." + typeName)) {
            return null;
        }
        if (typeName == null || typeName.length() == 0) {
            throw TbError.newSQLException(-90608, "typeName[" + typeName + "]");
        }
        PreparedStatement pstmt = conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_TYPENAME);
        pstmt.setString(1, schemaName);
        pstmt.setString(2, typeName);
        ResultSet rs = pstmt.executeQuery();
        return TbArrayDescriptor.lookupUdtMetaInternal((TbResultSetBase)rs, conn);
    }

    public static TbArrayDescriptor lookupUdtMeta(String hexEncodedOID, TbConnection conn) throws SQLException {
        Debug.logMethod("TbArrayDescriptor.lookupUdtMeta", new Object[]{hexEncodedOID, conn});
        if ("00000000000000000000000000000009".equalsIgnoreCase(hexEncodedOID)) {
            return null;
        }
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + hexEncodedOID + "]");
        }
        PreparedStatement pstmt = conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_OID);
        pstmt.setString(1, hexEncodedOID);
        ResultSet rs = pstmt.executeQuery();
        return TbArrayDescriptor.lookupUdtMetaInternal((TbResultSetBase)rs, conn);
    }

    private static TbArrayDescriptor lookupUdtMetaInternal(TbResultSetBase rs, TbConnection conn) throws SQLException {
        if (!rs.next()) {
            throw TbError.newSQLException(-90665);
        }
        try {
            Object o = rs.getObject(1, TbTypeDescriptor.getUdtMeta2ClsMap());
            if (!(o instanceof UdtMeta)) {
                throw TbError.newSQLException(-90664);
            }
            UdtMeta udt = (UdtMeta)o;
            UdtInfo udtId = udt.getUdtId();
            int udtInfoVersionNo = udtId.getVersionNo();
            int udtInfoTobjID = udtId.getTobjID();
            Object[] attrMetaArr = (Object[])udt.getAttrMetaArr().getArray();
            UdtAttrMeta attrMeta = (UdtAttrMeta)attrMetaArr[0];
            String sqlTypeName = udtId.getSchemaName() + "." + udtId.getUdtName();
            String elemOID = attrMeta.getOid();
            TbArrayDescriptor newDesc = new TbArrayDescriptor(udtId.getTypeNo(), udtId.getOid(), sqlTypeName, attrMeta.getTypeNo(), elemOID, udt.getElemOrAttrCnt(), conn);
            newDesc.setVersionNo(udtInfoVersionNo);
            newDesc.setTobjID(udtInfoTobjID);
            conn.putDescriptor(sqlTypeName, newDesc);
            conn.putDescriptor(_DESC_OID_PREFIX + udtId.getOid(), newDesc);
            return newDesc;
        }
        catch (SQLException e) {
            int ec = e.getErrorCode();
            if (ec <= -90400 && ec > -90500 || ec == -90664) {
                throw e;
            }
            throw TbError.newSQLException(-90664, e);
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90664, e);
        }
    }
}

