/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbArray
implements Array {
    private TbConnection conn;
    private TbArrayDescriptor descriptor;
    private int baseType;
    private Object[] elements;
    private Params subParams;

    public TbArray(TbArrayDescriptor desc, Connection conn, Object[] elements) throws SQLException {
        if (desc == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (conn == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = desc;
        this.baseType = desc.getBaseType();
        this.conn = (TbConnection)conn;
        this.elements = elements;
        this.subParams = new Params();
        this.initSubParams(desc.getElementType(), elements);
    }

    private void initSubParams(int elementsType, Object[] elements) throws SQLException {
        int size = elements == null ? 0 : elements.length;
        Params.access$002(this.subParams, new Binder[size]);
        this.subParams.bindData = new BindData(size);
        switch (elementsType) {
            case 1: {
                Params.access$202(this.subParams, new BigDecimal[size]);
                for (int i = 0; i < size; ++i) {
                    if (elements[i] == null) {
                        ((Params)this.subParams).paramBigDecimal[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else if (elements[i] instanceof Short) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Short)elements[i]).intValue());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof Integer) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Integer)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof Long) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Long)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof BigInteger) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((BigInteger)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof BigDecimal) {
                        ((Params)this.subParams).paramBigDecimal[i] = (BigDecimal)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof Float) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Float)elements[i]).floatValue());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof Double) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Double)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof String) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((String)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (elements[i] instanceof Boolean) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Boolean)elements[i] != false ? 1.0 : 0.0);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                Params.access$302(this.subParams, new String[size]);
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)elements[i] != false ? "1" : "0";
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStringBinder();
                    } else if (elements[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        ((Params)this.subParams).paramString[i] = elements[i].toString();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStringBinder();
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 18: 
            case 19: {
                Params.access$302(this.subParams, new String[size]);
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)elements[i] != false ? "1" : "0";
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNStringBinder();
                    } else if (elements[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        ((Params)this.subParams).paramString[i] = elements[i].toString();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNStringBinder();
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 4: {
                Params.access$402(this.subParams, new byte[size][]);
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof byte[]) {
                        ((Params)this.subParams).paramBytes[i] = (byte[])elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBytesBinder();
                    } else if (elements[i] == null) {
                        ((Params)this.subParams).paramBytes[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < size; ++i) {
                    Calendar cal;
                    if (elements[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance(((TbTimestampTZ)elements[i]).getTimeZone());
                        cal.setTime((TbTimestampTZ)elements[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (elements[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[size]);
                        }
                        TbTimestamp tts = (TbTimestamp)elements[i];
                        ((Params)this.subParams).paramTbDate[i] = new TbDate(tts.getYear(), tts.getMonth(), tts.getDayOfMonth(), tts.getHourOfDay(), tts.getMinutes(), tts.getSeconds());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (elements[i] instanceof TbDate) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[size]);
                        }
                        ((Params)this.subParams).paramTbDate[i] = (TbDate)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (elements[i] instanceof Timestamp || elements[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime((Date)elements[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (elements[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime(Date.valueOf((String)elements[i]));
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (elements[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[size]);
                        }
                        ((Params)this.subParams).paramTbTimestamp[i] = (TbTimestamp)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (elements[i] instanceof TbDate) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[size]);
                        }
                        TbDate td = (TbDate)elements[i];
                        ((Params)this.subParams).paramTbTimestamp[i] = new TbTimestamp(td.getYear(), td.getMonth(), td.getDayOfMonth(), td.getHourOfDay(), td.getMinutes(), td.getSeconds(), 0);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (elements[i] instanceof Timestamp) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (elements[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((Date)elements[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (elements[i] instanceof String) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = Timestamp.valueOf((String)elements[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                Params.access$402(this.subParams, new byte[size][]);
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof TbLob) {
                        ((Params)this.subParams).paramBytes[i] = ((TbLob)elements[i]).getLocator();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBytesBinder();
                    } else if (elements[i] == null) {
                        ((Params)this.subParams).paramBytes[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements;
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                if (this.subParams.paramArray == null) {
                    Params.access$902(this.subParams, new Array[size]);
                }
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof Array) {
                        ((Params)this.subParams).paramArray[i] = (Array)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getArrayInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbArray)elements[i]).getDescriptor());
                    } else if (elements[i] == null) {
                        ((Params)this.subParams).paramArray[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements;
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, elementsType, 0);
                }
                break;
            }
            case 28: 
            case 32: {
                if (this.subParams.paramStruct == null) {
                    Params.access$1002(this.subParams, new Struct[size]);
                }
                for (int i = 0; i < size; ++i) {
                    if (elements[i] instanceof Struct) {
                        ((Params)this.subParams).paramStruct[i] = (Struct)elements[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)elements[i]).getDescriptor());
                        continue;
                    }
                    if (elements[i] instanceof SQLData) {
                        Struct struct;
                        ((Params)this.subParams).paramStruct[i] = struct = (Struct)TbStruct.toStruct(elements[i], this.conn);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)struct).getDescriptor());
                        continue;
                    }
                    if (elements[i] == null) {
                        ((Params)this.subParams).paramStruct[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                        continue;
                    }
                    String subErrMsg = "elementType=" + DataType.getDBTypeName(elementsType) + ",element=" + elements;
                    throw TbError.newSQLException(-90651, subErrMsg);
                }
                break;
            }
            default: {
                throw TbError.newSQLException(-590703, DataType.getDBTypeName(elementsType));
            }
        }
    }

    public TbArrayDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void free() throws SQLException {
        this.conn = null;
        this.descriptor = null;
    }

    @Override
    public Object getArray() throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        int elementType = this.descriptor.getElementType();
        int arrSize = this.elements == null ? 0 : this.elements.length;
        switch (elementType) {
            case 1: {
                return this.subParams.paramBigDecimal;
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.subParams.paramString;
            }
            case 5: {
                if (!this.conn.info.getMapDateToTimestamp()) {
                    Date[] arrDate = new Date[arrSize];
                    for (int i = 0; i < arrSize; ++i) {
                        arrDate[i] = (Date)this.elements[i];
                    }
                    return arrDate;
                }
            }
            case 7: 
            case 21: 
            case 22: {
                Timestamp[] arrTs = new Timestamp[arrSize];
                for (int i = 0; i < arrSize; ++i) {
                    arrTs[i] = (Timestamp)this.elements[i];
                }
                return arrTs;
            }
            case 4: {
                return this.subParams.paramBytes;
            }
            case 12: {
                Blob[] arrBlob = new Blob[arrSize];
                for (int i = 0; i < arrSize; ++i) {
                    arrBlob[i] = (Blob)this.elements[i];
                }
                return arrBlob;
            }
            case 20: {
                NClob[] arrNClob = new NClob[arrSize];
                for (int i = 0; i < arrSize; ++i) {
                    arrNClob[i] = (NClob)this.elements[i];
                }
                return arrNClob;
            }
            case 13: {
                Clob[] arrClob = new Clob[arrSize];
                for (int i = 0; i < arrSize; ++i) {
                    arrClob[i] = (Clob)this.elements[i];
                }
                return arrClob;
            }
            case 29: 
            case 30: 
            case 31: {
                TbArray[] arrOfArr = new TbArray[arrSize];
                for (int i = 0; i < arrSize; ++i) {
                    arrOfArr[i] = (TbArray)this.elements[i];
                }
                return arrOfArr;
            }
        }
        return this.elements;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return DataType.getDBTypeName(this.descriptor.getElementType());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public Params getSubParams() {
        return this.subParams;
    }

    public String getSQLTypeName() {
        return this.descriptor.getSQLTypeName();
    }

    public int length() {
        return this.elements == null ? 0 : this.elements.length;
    }

    class Params
    implements ParamContainer {
        private Binder[] elementBinders;
        private BindData bindData;
        private BigDecimal[] paramBigDecimal;
        private String[] paramString;
        private Timestamp[] paramTimestamp;
        private TbTimestampTZ[] paramTbTimestampTZ;
        private TbTimestamp[] paramTbTimestamp;
        private TbDate[] paramTbDate;
        private Calendar[] paramCalendar;
        private byte[][] paramBytes;
        private InputStream[] paramStream;
        private Reader[] paramReader;
        private Struct[] paramStruct;
        private Array[] paramArray;

        Params() {
        }

        @Override
        public BindData getBindData() {
            return this.bindData;
        }

        @Override
        public Binder[][] getBinder() {
            return null;
        }

        @Override
        public Binder getBinder(int rowIndex, int colIndex) {
            return this.elementBinders[colIndex];
        }

        @Override
        public int getParameterCnt() {
            return 1;
        }

        @Override
        public byte getParamType(int rowIndex, int colIndex) {
            return 0;
        }

        @Override
        public byte[][] getParamTypes() {
            return null;
        }

        @Override
        public byte[] getParamTypesOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Array getParamArray(int rowIndex, int colIndex) {
            return this.paramArray[colIndex];
        }

        @Override
        public Array[] getParamArrayOfRow(int rowIndex) {
            return null;
        }

        @Override
        public BigDecimal getParamBigDecimal(int rowIndex, int colIndex) {
            return this.paramBigDecimal[colIndex];
        }

        @Override
        public BigDecimal[] getParamBigDecimalOfRow(int rowIndex) {
            return null;
        }

        @Override
        public byte[] getParamBytes(int rowIndex, int colIndex) {
            return this.paramBytes[colIndex];
        }

        @Override
        public byte[][] getParamBytesOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Calendar getParamCalendar(int rowIndex, int colIndex) {
            return this.paramCalendar[colIndex];
        }

        @Override
        public Calendar[] getParamCalendarOfRow(int rowIndex) {
            return null;
        }

        @Override
        public double getParamDouble(int rowIndex, int colIndex) {
            return 0.0;
        }

        @Override
        public double[] getParamDoubleOfRow(int rowIndex) {
            return null;
        }

        @Override
        public float getParamFloat(int rowIndex, int colIndex) {
            return 0.0f;
        }

        @Override
        public float[] getParamFloatOfRow(int rowIndex) {
            return null;
        }

        @Override
        public int getParamInt(int rowIndex, int colIndex) {
            return 0;
        }

        @Override
        public int[] getParamIntOfRow(int rowIndex) {
            return null;
        }

        @Override
        public long getParamLong(int rowIndex, int colIndex) {
            return 0L;
        }

        @Override
        public long[] getParamLongOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Reader getParamReader(int rowIndex, int colIndex) {
            return this.paramReader[colIndex];
        }

        @Override
        public Reader[] getParamReaderOfRow(int rowIndex) {
            return null;
        }

        @Override
        public InputStream getParamStream(int rowIndex, int colIndex) {
            return this.paramStream[colIndex];
        }

        @Override
        public InputStream[] getParamStreamOfRow(int rowIndex) {
            return null;
        }

        @Override
        public String getParamString(int rowIndex, int colIndex) {
            return this.paramString[colIndex];
        }

        @Override
        public String[] getParamStringOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Struct getParamStruct(int rowIndex, int colIndex) {
            return this.paramStruct[colIndex];
        }

        @Override
        public Struct[] getParamStructOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbDate getParamTbDate(int rowIndex, int colIndex) {
            return this.paramTbDate[colIndex];
        }

        @Override
        public TbDate[] getParamTbDateOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbTimestamp getParamTbTimestamp(int rowIndex, int colIndex) {
            return this.paramTbTimestamp[colIndex];
        }

        @Override
        public TbTimestamp[] getParamTbTimestampOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbTimestampTZ getParamTbTimestampTZ(int rowIndex, int colIndex) {
            return this.paramTbTimestampTZ[colIndex];
        }

        @Override
        public TbTimestampTZ[] getParamTbTimestampTZOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Timestamp getParamTimestamp(int rowIndex, int colIndex) {
            return this.paramTimestamp[colIndex];
        }

        @Override
        public Timestamp[] getParamTimestampOfRow(int rowIndex) {
            return null;
        }

        static /* synthetic */ Binder[] access$002(Params x0, Binder[] x1) {
            x0.elementBinders = x1;
            return x1;
        }

        static /* synthetic */ BigDecimal[] access$202(Params x0, BigDecimal[] x1) {
            x0.paramBigDecimal = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(Params x0, String[] x1) {
            x0.paramString = x1;
            return x1;
        }

        static /* synthetic */ byte[][] access$402(Params x0, byte[][] x1) {
            x0.paramBytes = x1;
            return x1;
        }

        static /* synthetic */ Calendar[] access$502(Params x0, Calendar[] x1) {
            x0.paramCalendar = x1;
            return x1;
        }

        static /* synthetic */ TbDate[] access$602(Params x0, TbDate[] x1) {
            x0.paramTbDate = x1;
            return x1;
        }

        static /* synthetic */ Timestamp[] access$702(Params x0, Timestamp[] x1) {
            x0.paramTimestamp = x1;
            return x1;
        }

        static /* synthetic */ TbTimestamp[] access$802(Params x0, TbTimestamp[] x1) {
            x0.paramTbTimestamp = x1;
            return x1;
        }

        static /* synthetic */ Array[] access$902(Params x0, Array[] x1) {
            x0.paramArray = x1;
            return x1;
        }

        static /* synthetic */ Struct[] access$1002(Params x0, Struct[] x1) {
            x0.paramStruct = x1;
            return x1;
        }
    }
}

