/*
 * Decompiled with CFR 0.152.
 */
package core.log.util;

import core.log.util.ApacheCommonLangStringUtils;
import java.util.ArrayList;
import java.util.TimeZone;

public class ApacheCommonLangTimeStopWatch {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private static final int STATE_UNSPLIT = 10;
    private static final int STATE_SPLIT = 11;
    private int runningState = 0;
    private int splitState = 10;
    private long startTime = -1L;
    private long stopTime = -1L;
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public void start() {
        if (this.runningState == 2) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != 0) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.stopTime = -1L;
        this.startTime = System.currentTimeMillis();
        this.runningState = 1;
    }

    public void stop() {
        if (this.runningState != 1 && this.runningState != 3) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        if (this.runningState == 1) {
            this.stopTime = System.currentTimeMillis();
        }
        this.runningState = 2;
    }

    public void reset() {
        this.runningState = 0;
        this.splitState = 10;
        this.startTime = -1L;
        this.stopTime = -1L;
    }

    public void split() {
        if (this.runningState != 1) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        this.stopTime = System.currentTimeMillis();
        this.splitState = 11;
    }

    public void unsplit() {
        if (this.splitState != 11) {
            throw new IllegalStateException("Stopwatch has not been split. ");
        }
        this.stopTime = -1L;
        this.splitState = 10;
    }

    public void suspend() {
        if (this.runningState != 1) {
            throw new IllegalStateException("Stopwatch must be running to suspend. ");
        }
        this.stopTime = System.currentTimeMillis();
        this.runningState = 3;
    }

    public void resume() {
        if (this.runningState != 3) {
            throw new IllegalStateException("Stopwatch must be suspended to resume. ");
        }
        this.startTime += System.currentTimeMillis() - this.stopTime;
        this.stopTime = -1L;
        this.runningState = 1;
    }

    public long getTime() {
        if (this.runningState == 2 || this.runningState == 3) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == 0) {
            return 0L;
        }
        if (this.runningState == 1) {
            return System.currentTimeMillis() - this.startTime;
        }
        throw new RuntimeException("Illegal running state has occured. ");
    }

    public long getSplitTime() {
        if (this.splitState != 11) {
            throw new IllegalStateException("Stopwatch must be split to get the split time. ");
        }
        return this.stopTime - this.startTime;
    }

    public String toString() {
        return ApacheCommonLangTimeStopWatch.formatDurationHMS(this.getTime());
    }

    public static String formatDurationHMS(long durationMillis) {
        return ApacheCommonLangTimeStopWatch.formatDuration(durationMillis, "H:mm:ss.SSS");
    }

    public static String formatDuration(long durationMillis, String format) {
        return ApacheCommonLangTimeStopWatch.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Token[] tokens = ApacheCommonLangTimeStopWatch.lexx(format);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = (int)(durationMillis / 86400000L);
            durationMillis -= (long)days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = (int)(durationMillis / 3600000L);
            durationMillis -= (long)hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = (int)(durationMillis / 60000L);
            durationMillis -= (long)minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = (int)(durationMillis / 1000L);
            durationMillis -= (long)seconds * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, S)) {
            milliseconds = (int)durationMillis;
        }
        return ApacheCommonLangTimeStopWatch.format(tokens, 0, 0, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    static Token[] lexx(String format) {
        char[] array = format.toCharArray();
        ArrayList<Token> list = new ArrayList<Token>(array.length);
        boolean inLiteral = false;
        StringBuffer buffer = null;
        Token previous = null;
        int sz = array.length;
        for (int i = 0; i < sz; ++i) {
            char ch = array[i];
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuffer();
                    list.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        list.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue() == value) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add(token);
                previous = token;
            }
            buffer = null;
        }
        return list.toArray(new Token[list.size()]);
    }

    static String format(Token[] tokens, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds, boolean padWithZeros) {
        StringBuffer buffer = new StringBuffer();
        boolean lastOutputSeconds = false;
        int sz = tokens.length;
        for (int i = 0; i < sz; ++i) {
            Token token = tokens[i];
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuffer) {
                buffer.append(value.toString());
                continue;
            }
            if (value == y) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(years), count, '0') : Integer.toString(years));
                lastOutputSeconds = false;
                continue;
            }
            if (value == M) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(months), count, '0') : Integer.toString(months));
                lastOutputSeconds = false;
                continue;
            }
            if (value == d) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(days), count, '0') : Integer.toString(days));
                lastOutputSeconds = false;
                continue;
            }
            if (value == H) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(hours), count, '0') : Integer.toString(hours));
                lastOutputSeconds = false;
                continue;
            }
            if (value == m) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(minutes), count, '0') : Integer.toString(minutes));
                lastOutputSeconds = false;
                continue;
            }
            if (value == s) {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(seconds), count, '0') : Integer.toString(seconds));
                lastOutputSeconds = true;
                continue;
            }
            if (value != S) continue;
            if (lastOutputSeconds) {
                String str = padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(milliseconds), count, '0') : Integer.toString(milliseconds += 1000);
                buffer.append(str.substring(1));
            } else {
                buffer.append(padWithZeros ? ApacheCommonLangStringUtils.leftPad(Integer.toString(milliseconds), count, '0') : Integer.toString(milliseconds));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    static class Token {
        private Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            int sz = tokens.length;
            for (int i = 0; i < sz; ++i) {
                if (tokens[i].getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        Token(Object value, int count) {
            this.value = value;
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuffer) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

