/*
 * Decompiled with CFR 0.152.
 */
package core.log.logger;

import core.log.conf.reloadable.ReloadableConfiguration;
import core.log.exception.InternalException;
import core.log.logger.resource.LogResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class SL {
    private static SL sl;
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int FATAL = 3;
    public static final int ERROR = 4;
    public static final int LOG_OFF = 5;
    public final int[] LEVEL = new int[]{0, 1, 2, 3, 4, 5};
    private final int[] LOG_INDEX = new int[]{1, 3, 2};
    private final int PARAMMAP_LOG_INDEX = 3;
    private final int ERROR_LOG_INDEX = 0;
    private final int TRACE_LOG_INDEX = 2;
    private String dateFormat = null;
    private final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final String UNIQUE_STRING = "################################################";

    private SL() {
        try {
            ReloadableConfiguration.getInstance().put("debug", new Integer(0));
            ReloadableConfiguration.getInstance().put("info", new Integer(1));
            ReloadableConfiguration.getInstance().put("warning", new Integer(2));
            ReloadableConfiguration.getInstance().put("fatal", new Integer(3));
            ReloadableConfiguration.getInstance().put("error", new Integer(4));
            ReloadableConfiguration.getInstance().put("log_level", this.LEVEL);
            ReloadableConfiguration.getInstance().put("log_off", new Integer(5));
            ReloadableConfiguration.getInstance().put(new Integer(0), "DEBUG");
            ReloadableConfiguration.getInstance().put(new Integer(1), "INFO");
            ReloadableConfiguration.getInstance().put(new Integer(2), "WARNING");
            ReloadableConfiguration.getInstance().put(new Integer(3), "FATAL");
            ReloadableConfiguration.getInstance().put(new Integer(4), "ERROR");
            ReloadableConfiguration.getInstance().put(new Integer(5), "LOG_OFF");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static SL getInstance() {
        if (sl == null) {
            sl = new SL();
            return sl;
        }
        return sl;
    }

    private String now() {
        return new SimpleDateFormat(this.dateFormat == null ? "yyyy-MM-dd HH:mm:ss" : this.dateFormat).format(new Date());
    }

    public int get(String logLevel) {
        return ReloadableConfiguration.getInstance().getLogLevel();
    }

    public Object put(Object obj, Object value) {
        return null;
    }

    public void putAll(Map map) {
    }

    public Map getLogLevelMap() {
        return ReloadableConfiguration.getInstance();
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public int getDebug() {
        return 0;
    }

    public int getInfo() {
        return 1;
    }

    public int getWarning() {
        return 2;
    }

    public int getFatal() {
        return 3;
    }

    public int getError() {
        return 4;
    }

    public String getDebugName() {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(0));
    }

    public String getInfoName() {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(1));
    }

    public String getWarningName() {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(2));
    }

    public String getFatalName() {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(3));
    }

    public String getErrorName() {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(4));
    }

    public String getLogLevelName(int logLevel) {
        return (String)ReloadableConfiguration.getInstance().get(new Integer(logLevel));
    }

    public void setLogLevel(int logLevel) {
        if (logLevel > 5 || logLevel < 0) {
            logLevel = 0;
        }
        ReloadableConfiguration.getInstance().setLogLevel(logLevel);
        ReloadableConfiguration.getInstance().put("now", new Integer(logLevel));
        System.out.println("#######################################################");
        System.out.println("#           LOG LEVEL CHANGED [" + ReloadableConfiguration.getInstance().getLogLevel() + "]");
        System.out.println("#######################################################");
    }

    public void setLogOff() {
        ReloadableConfiguration.getInstance().setLogLevel(5);
    }

    private boolean checkLogLevel(int logLevel) {
        return ReloadableConfiguration.getInstance().getLogLevel() <= logLevel;
    }

    public PositionInfo postionInfo(Throwable t, int index) {
        PositionInfo positionInfo = null;
        try {
            positionInfo = new PositionInfo(t.getStackTrace().length <= index ? t.getStackTrace()[t.getStackTrace().length - 1] : t.getStackTrace()[index], t.getMessage());
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
        return positionInfo;
    }

    public PositionInfo postionInfo(Throwable t) {
        return new PositionInfo(t.getStackTrace(), 2);
    }

    public PositionInfo postionInfoForPositionCheck(Throwable t) {
        return new PositionInfo(t.getStackTrace(), 0);
    }

    private void getMessageThrowable(Object obj) throws Throwable {
        if (obj instanceof String) {
            throw new Throwable((String)obj);
        }
        if (obj instanceof Integer) {
            throw new Throwable(((Integer)obj).toString());
        }
        if (obj instanceof Boolean) {
            throw new Throwable(((Boolean)obj).toString());
        }
        if (obj instanceof Throwable) {
            throw new Throwable((Throwable)obj);
        }
        if (obj instanceof Properties) {
            throw new Throwable(((Properties)obj).values().toString());
        }
        if (obj == null) {
            throw new Throwable("null");
        }
        throw new Throwable(obj.toString());
    }

    public Throwable getMessageThrowableForThread(Object obj) {
        if (obj instanceof String) {
            return new Throwable((String)obj);
        }
        if (obj instanceof Integer) {
            return new Throwable(((Integer)obj).toString());
        }
        if (obj instanceof Boolean) {
            return new Throwable(((Boolean)obj).toString());
        }
        if (obj instanceof Throwable) {
            return new Throwable((Throwable)obj);
        }
        if (obj instanceof Properties) {
            return new Throwable(((Properties)obj).values().toString());
        }
        if (obj == null) {
            return new Throwable("null");
        }
        return new Throwable(obj.toString());
    }

    public boolean getMessageThrowableForThread(String packages, Throwable throwable) {
        StackTraceElement[] stackTraceElement = throwable.getStackTrace();
        for (int i = 0; stackTraceElement != null && i < stackTraceElement.length; ++i) {
            if (!stackTraceElement[i].getClassName().startsWith(packages)) continue;
            return true;
        }
        return false;
    }

    public void log() {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                throw new Throwable("################################################");
            }
            catch (Throwable t) {
                this.rowLogging(t, this.getDebug(), this.LOG_INDEX[0]);
            }
        }
    }

    public void log(int message) {
        this.log((Object)new Integer(message), true);
    }

    public void log(int message, int logLevel) {
        this.log(new Integer(message), logLevel, true);
    }

    public void log(boolean bool) {
        this.log((Object)new Boolean(bool), true);
    }

    public void log(boolean bool, int logLevel) {
        this.log(new Boolean(bool), logLevel, true);
    }

    public void log(Object obj) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLogging(t, this.getDebug(), this.LOG_INDEX[2]);
            }
        }
    }

    public void log(Object obj, boolean isPrimitive) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLogging(t, this.getDebug(), this.LOG_INDEX[1]);
            }
        }
    }

    public void log(Object obj, String message) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLogging(t, this.getDebug(), this.LOG_INDEX[2], message);
            }
        }
    }

    public void log(Object obj, int logLevel) {
        if (this.checkLogLevel(logLevel)) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLogging(t, logLevel, this.LOG_INDEX[2]);
            }
        }
    }

    public void log(Object obj, int logLevel, boolean isPrimitive) {
        if (this.checkLogLevel(logLevel)) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLogging(t, logLevel, this.LOG_INDEX[1]);
            }
        }
    }

    public void logTrace() {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(null);
            }
            catch (Throwable t) {
                this.rowLoggingTrace(t, this.getDebug());
            }
        }
    }

    public void logTrace(Object obj) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingTrace(t, this.getDebug(), t.getMessage());
            }
        }
    }

    public void logTrace(Object obj, int logLevel) {
        if (this.checkLogLevel(logLevel)) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingTrace(t, logLevel);
            }
        }
    }

    public void logTrace(Object obj, String message) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingTrace(t, this.getDebug(), message);
            }
        }
    }

    public void logTrace(Object obj, String message, int logLevel) {
        if (this.checkLogLevel(logLevel)) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingTrace(t, logLevel, message);
            }
        }
    }

    public void logSql(LogResource logResource) {
        if (this.checkLogLevel(this.getDebug())) {
            this.rowLoggingSql(logResource, this.getDebug(), ReloadableConfiguration.getInstance().getSelectPosition(), logResource.getElapsedTime(), logResource.getResult());
        }
    }

    public void logSql(Object obj, String elapsedTime, String queryResult, int logLevel) {
        if (this.checkLogLevel(logLevel)) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingSql(t, logLevel, ReloadableConfiguration.getInstance().getSelectPosition(), elapsedTime, queryResult);
            }
        }
    }

    public void logOnlyLog(Object obj) {
        if (this.checkLogLevel(this.getDebug())) {
            System.out.println(obj.toString());
        }
    }

    public void logOnlyLog(Object obj, int logLevel) {
        if (this.checkLogLevel(logLevel) && this.checkLogLevel(this.getDebug())) {
            System.out.println(obj.toString());
        }
    }

    public void logError(Throwable e) {
        try {
            if (this.checkLogLevel(this.getError())) {
                this.systemLogging(new PositionInfo(e.getCause() != null && e.getCause().getStackTrace().length >= 0 ? e.getCause().getStackTrace()[0] : (e.getStackTrace().length > 0 ? e.getStackTrace()[e.getStackTrace().length - 1] : e.getStackTrace()[0]), e.getCause() != null && e.getCause().getStackTrace().length >= 0 ? e.getCause().getStackTrace() : e.getStackTrace(), e.getCause() != null && e.getCause().getStackTrace().length >= 0 ? e.getCause().getMessage() : e.getMessage()), e.getCause() != null ? e.getCause().getClass().getName() : e.getClass().getName());
            }
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    public void logError(Throwable e, String message) {
        try {
            if (this.checkLogLevel(this.getError())) {
                this.systemLogging(new PositionInfo(e.getCause() != null && e.getCause().getStackTrace().length >= 0 ? e.getCause().getStackTrace()[0] : (e.getStackTrace().length > 0 ? e.getStackTrace()[e.getStackTrace().length - 1] : e.getStackTrace()[0]), e.getCause() != null && e.getCause().getStackTrace().length > 0 ? e.getCause().getStackTrace() : e.getStackTrace(), e.getCause() != null && e.getCause().getStackTrace().length > 0 ? e.getCause().getMessage() : e.getMessage()), e.getCause() != null ? e.getCause().getClass().getName() : e.getClass().getName(), message);
            }
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    public void logParamMap(Object obj) {
        if (this.checkLogLevel(this.getDebug())) {
            try {
                this.getMessageThrowable(obj);
            }
            catch (Throwable t) {
                this.rowLoggingSql(t, this.getDebug(), 3);
            }
        }
    }

    public void logTraceForPositionCheck(Throwable t, String message) {
        this.rowLoggingTraceForPositionCheck(t, message);
    }

    private void rowLogging(Throwable t, int logLevel, int logIndex) {
        try {
            this.systemLogging(logLevel, this.postionInfo(t, logIndex));
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    private void rowLogging(Throwable t, int logLevel, int logIndex, String message) {
        try {
            this.systemLogging(logLevel, this.postionInfo(t, logIndex), message);
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    private void rowLoggingSql(Throwable t, int logLevel, int logIndex) {
        try {
            this.systemLogging(logLevel, this.postionInfo(t, logIndex));
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    private void rowLoggingSql(Throwable t, int logLevel, int logIndex, String elapsedTime, String result) {
        try {
            this.systemLogging(logLevel, this.postionInfo(t, logIndex), elapsedTime, result);
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    private void rowLoggingSql(LogResource logResource, int logLevel, int logIndex, String elapsedTime, String result) {
        try {
            this.systemLogging(logLevel, logResource, this.postionInfo(logResource.getThrowable(), logIndex), elapsedTime, result);
        }
        catch (Throwable _t) {
            new InternalException(_t);
        }
    }

    private void rowLoggingTrace(Throwable t, int logLevel) {
        this.systemLogging(logLevel, this.postionInfo(t));
    }

    private void rowLoggingTrace(Throwable t, int logLevel, String message) {
        this.systemLogging(logLevel, this.postionInfo(t), message);
    }

    private void rowLoggingTraceForPositionCheck(Throwable t, String message) {
        this.systemLoggingForPositionCheck(this.postionInfoForPositionCheck(t), message);
    }

    private void systemLogging(PositionInfo positionInfo, String exceptionClassName) {
        this.outter("[" + this.now() + "]" + " [" + this.getErrorName() + "]" + "\u300e" + positionInfo.getClassName() + ":" + positionInfo.getMethodName() + "(" + positionInfo.getLineNumber() + ")\u300f\n" + exceptionClassName + "\n" + (positionInfo.getMsg() != null ? positionInfo.getMsg() : "") + "\n");
    }

    private void systemLogging(PositionInfo positionInfo, String exceptionClassName, String message) {
        this.outter("[" + this.now() + "]" + " [" + this.getErrorName() + "]" + "\u300e" + positionInfo.getClassName() + ":" + positionInfo.getMethodName() + "(" + positionInfo.getLineNumber() + ")\u300f\n" + exceptionClassName + "\n" + message + "\n" + (positionInfo.getMsg() != null ? positionInfo.getMsg() : "") + "\n");
    }

    private void systemLogging(int logLevel, PositionInfo positionInfo) {
        this.outter("[" + this.now() + "]" + " [" + this.getLogLevelName(logLevel) + "]" + "\u300e" + positionInfo.getClassName() + ":" + positionInfo.getMethodName() + "(" + positionInfo.getLineNumber() + ")\u300f\n" + (positionInfo.getMsg() != null ? positionInfo.getMsg() : "") + "\n");
    }

    private void systemLogging(int logLevel, PositionInfo positionInfo, String message, String result) {
        this.outter("[" + this.now() + "]" + " [" + this.getLogLevelName(logLevel) + "]" + "\u300e" + positionInfo.getClassName() + ":" + positionInfo.getMethodName() + "(" + positionInfo.getLineNumber() + ")\u300f" + " Elapsed Time [" + message + "]\n" + (positionInfo.getMsg() != null ? positionInfo.getMsg() : "") + "\n" + (result != null ? "Query Result" + result + "row\n" : "\n"));
    }

    private void systemLogging(int logLevel, LogResource logResource, PositionInfo positionInfo, String message, String result) {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.now()).append("]");
        sb.append(" [").append(this.getLogLevelName(logLevel)).append("]");
        sb.append("\u300e").append(positionInfo.getClassName()).append(":");
        sb.append(positionInfo.getMethodName()).append("(").append(positionInfo.getLineNumber()).append(")\u300f");
        sb.append(" Elapsed Time [").append(message).append("]\n");
        sb.append(positionInfo.getMsg() != null ? positionInfo.getMsg() : "").append("\n");
        if (logResource.isSelect() && !ReloadableConfiguration.getInstance().getFixedSelectPosition()) {
            sb.append(this.postionInfoForPositionCheck(logResource.getThrowable()).getMsg());
        }
        if (!logResource.isSelect() && !ReloadableConfiguration.getInstance().getFixedNoneSelectPosition()) {
            sb.append(this.postionInfoForPositionCheck(logResource.getThrowable()).getMsg());
        }
        sb.append(result != null ? "Query Result" + result + "row\n" : "\n");
        this.outter(sb.toString());
    }

    private void systemLogging(int logLevel, PositionInfo positionInfo, String message) {
        this.outter("[" + this.now() + "]" + " [" + this.getLogLevelName(logLevel) + "]" + "\u300e" + positionInfo.getClassName() + ":" + positionInfo.getMethodName() + "(" + positionInfo.getLineNumber() + ")\u300f\n" + message + "\n" + positionInfo.getMsg() + "\n");
    }

    private void systemLoggingForPositionCheck(PositionInfo positionInfo, String message) {
        this.outter("[Position Check Start" + (message != null ? " :\n" + message : "") + "]\n" + positionInfo.getMsg() + "\n" + "[Position Check End]\n");
    }

    private void outter(String message) {
        System.out.println(message);
    }

    private class PositionInfo {
        private final String TRACE_MESSAGE = "############## BELOW MESSAGE IS TRACE. NO ERROR! ##############\n";
        private final String msg;
        private final String className;
        private final String methodName;
        private final int lineNumber;

        public PositionInfo(StackTraceElement stackTraceElement, String message) {
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName();
            this.lineNumber = stackTraceElement.getLineNumber();
            this.msg = message;
        }

        public PositionInfo(StackTraceElement[] stackTraceElements, int traceLoggingIndex) {
            StringBuffer msg = new StringBuffer();
            for (int i = traceLoggingIndex; i < stackTraceElements.length; ++i) {
                msg.append("\t").append("[").append(i).append("] at ").append(stackTraceElements[i]).append("\n");
            }
            this.className = stackTraceElements[traceLoggingIndex].getClassName();
            this.methodName = stackTraceElements[traceLoggingIndex].getMethodName();
            this.lineNumber = stackTraceElements[traceLoggingIndex].getLineNumber();
            this.msg = "############## BELOW MESSAGE IS TRACE. NO ERROR! ##############\n" + msg;
        }

        public PositionInfo(StackTraceElement[] stackTraceElements, String message, int traceLoggingIndex) {
            StringBuffer msg = new StringBuffer();
            msg.append(message).append("\n");
            for (int i = traceLoggingIndex; i < stackTraceElements.length; ++i) {
                msg.append("\t").append("at ").append(stackTraceElements[i]).append("\n");
            }
            this.className = stackTraceElements[traceLoggingIndex].getClassName();
            this.methodName = stackTraceElements[traceLoggingIndex].getMethodName();
            this.lineNumber = stackTraceElements[traceLoggingIndex].getLineNumber();
            this.msg = "############## BELOW MESSAGE IS TRACE. NO ERROR! ##############\n" + msg;
        }

        public PositionInfo(StackTraceElement stackTraceElement, StackTraceElement[] stackTraceElements, String message) {
            StringBuffer msg = new StringBuffer();
            msg.append(message).append("\n");
            for (int i = 0; stackTraceElements != null && i < stackTraceElements.length; ++i) {
                msg.append("\t").append("at ").append(stackTraceElements[i]).append("\n");
            }
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName();
            this.lineNumber = stackTraceElement.getLineNumber();
            this.msg = msg.toString();
        }

        public String getMsg() {
            return this.msg;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

