/*
 * Decompiled with CFR 0.152.
 */
package core.log.logger;

import core.log.conf.reloadable.ReloadableConfiguration;
import core.log.exception.InternalException;
import core.log.logger.SL;
import core.log.logger.resource.LogResource;
import core.log.util.PatternCheck;
import java.util.LinkedList;

public class ConcurrentThreadPool
extends ThreadGroup {
    private boolean isAlive;
    private LinkedList taskQueue;
    private LinkedList threadQueue;
    private int threadID;
    private static int threadPoolID;
    private int defaultNumberThread = 10;
    private static ConcurrentThreadPool concurrentThreadPool;
    public static int maxTask;
    public static int mt_thread;

    private ConcurrentThreadPool() {
        super("ThreadPool-" + threadPoolID++);
        this.setDaemon(true);
        this.isAlive = true;
        this.taskQueue = new LinkedList();
        this.threadQueue = new LinkedList();
        for (int i = 0; i < this.defaultNumberThread; ++i) {
            PooledThread pooledThread = new PooledThread();
            this.threadQueue.add(pooledThread);
            pooledThread.start();
        }
    }

    private ConcurrentThreadPool(int initializedThreadCount) {
        super("ThreadPool-" + threadPoolID++);
        this.setDaemon(true);
        this.isAlive = true;
        this.taskQueue = new LinkedList();
        this.threadQueue = new LinkedList();
        this.defaultNumberThread = initializedThreadCount;
        for (int i = 0; i < this.defaultNumberThread; ++i) {
            PooledThread pooledThread = new PooledThread();
            this.threadQueue.add(pooledThread);
            pooledThread.start();
        }
    }

    public static ConcurrentThreadPool getInstance() {
        if (concurrentThreadPool == null) {
            concurrentThreadPool = new ConcurrentThreadPool();
            return concurrentThreadPool;
        }
        return concurrentThreadPool;
    }

    public int getCurrentTaskCount() {
        return this.taskQueue.size();
    }

    public int getCurrentThreadCount() {
        return this.threadQueue.size();
    }

    public static ConcurrentThreadPool getInstance(int initializedThreadCount) {
        if (concurrentThreadPool == null) {
            concurrentThreadPool = new ConcurrentThreadPool(initializedThreadCount);
            return concurrentThreadPool;
        }
        return concurrentThreadPool;
    }

    private int resizeThreadCount(int resizedThreadCount) {
        if (this.defaultNumberThread > resizedThreadCount) {
            for (int i = 0; i < this.threadQueue.size(); ++i) {
                this.threadQueue.remove(i);
                if (this.threadQueue.size() != resizedThreadCount) {
                    continue;
                }
                break;
            }
        } else if (resizedThreadCount > this.defaultNumberThread) {
            for (int i = 0; i < resizedThreadCount; ++i) {
                PooledThread pooledThread = new PooledThread();
                this.threadQueue.add(pooledThread);
                pooledThread.start();
            }
        }
        this.defaultNumberThread = resizedThreadCount;
        return this.defaultNumberThread;
    }

    public synchronized void addTask(Object obj) {
        this.taskQueue.add(obj);
        this.notify();
    }

    private synchronized Object getTask() {
        try {
            while (this.taskQueue.size() == 0) {
                if (!this.isAlive) {
                    return null;
                }
                this.wait();
            }
            if (this.taskQueue.size() > 100) {
                this.resizeThreadCount(this.taskQueue.size() / 3);
            } else {
                this.resizeThreadCount(10);
            }
        }
        catch (Throwable t) {
            new InternalException(t);
        }
        return this.taskQueue.removeFirst();
    }

    public synchronized void close() {
        if (this.isAlive) {
            this.isAlive = false;
            this.taskQueue.clear();
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ConcurrentThreadPool concurrentThreadPool = this;
        synchronized (concurrentThreadPool) {
            this.isAlive = false;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    static {
        maxTask = 0;
        mt_thread = 0;
    }

    private class PooledThread
    extends Thread {
        public PooledThread() {
            super((ThreadGroup)ConcurrentThreadPool.this, "PooledThread-" + ConcurrentThreadPool.this.threadID++);
        }

        public void run() {
            while (!this.isInterrupted()) {
                Object task = null;
                task = ConcurrentThreadPool.this.getTask();
                if (task == null) {
                    return;
                }
                try {
                    if (!new PatternCheck().doLog(ReloadableConfiguration.getInstance().getViewAppoint(), ((LogResource)task).getThrowable())) continue;
                    SL.getInstance().logSql((LogResource)task);
                }
                catch (Throwable t) {
                    if (((LogResource)task).isSelect()) {
                        new InternalException("LoggingDaoR Error!", t);
                        continue;
                    }
                    new InternalException("LoggingDaoCUD Error!", t);
                }
            }
        }
    }
}

