/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSPERMSRowFactory
extends PermissionsCatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSPERMS";
    private static final int SYSPERMS_COLUMN_COUNT = 7;
    private static final int SYSPERMS_PERMISSIONID = 1;
    private static final int SYSPERMS_OBJECTTYPE = 2;
    private static final int SYSPERMS_OBJECTID = 3;
    private static final int SYSPERMS_PERMISSION = 4;
    private static final int SYSPERMS_GRANTOR = 5;
    private static final int SYSPERMS_GRANTEE = 6;
    private static final int SYSPERMS_IS_GRANTABLE = 7;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}, {6, 3, 5}};
    public static final int PERMS_UUID_IDX_NUM = 0;
    public static final int PERMS_OBJECTID_IDX_NUM = 1;
    public static final int GRANTEE_OBJECTID_GRANTOR_INDEX_NUM = 2;
    private static final boolean[] uniqueness = new boolean[]{true, false, true};
    private static final String[] uuids = new String[]{"9810800c-0121-c5e1-a2f5-00000043e718", "6ea6ffac-0121-c5e3-f286-00000043e718", "5cc556fc-0121-c5e6-4e43-00000043e718", "7a92cf84-0122-51e6-2c5e-00000047b548", "9810800c-0125-8de5-3aa0-0000001999e8"};

    SYSPERMSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecIndexRow buildIndexKeyRow(int n, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        switch (n) {
            case 2: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(2);
                execIndexRow.setColumn(1, this.getAuthorizationID(permissionsDescriptor.getGrantee()));
                String string = ((PermDescriptor)permissionsDescriptor).getPermObjectId().toString();
                execIndexRow.setColumn(2, new SQLChar(string));
                break;
            }
            case 0: {
                execIndexRow = this.getExecutionFactory().getIndexableRow(1);
                String string = ((PermDescriptor)permissionsDescriptor).getUUID().toString();
                execIndexRow.setColumn(1, new SQLChar(string));
            }
        }
        return execIndexRow;
    }

    public int getPrimaryKeyIndexNumber() {
        return 2;
    }

    public int orPermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        return 0;
    }

    public int removePermissions(ExecRow execRow, PermissionsDescriptor permissionsDescriptor, boolean[] blArray) throws StandardException {
        return -1;
    }

    void setUUIDOfThePassedDescriptor(ExecRow execRow, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        permissionsDescriptor.setUUID(this.getUUIDFactory().recreateUUID(dataValueDescriptor.getString()));
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = "SEQUENCE";
        String string3 = null;
        String string4 = "USAGE";
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (tupleDescriptor != null) {
            PermDescriptor permDescriptor = (PermDescriptor)tupleDescriptor;
            UUID uUID = permDescriptor.getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                permDescriptor.setUUID(uUID);
            }
            string = uUID.toString();
            string2 = permDescriptor.getObjectType();
            UUID uUID2 = permDescriptor.getPermObjectId();
            string3 = uUID2.toString();
            string4 = permDescriptor.getPermission();
            string5 = permDescriptor.getGrantor();
            string6 = permDescriptor.getGrantee();
            bl = permDescriptor.isGrantable();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(7);
        execRow.setColumn(1, new SQLChar(string));
        execRow.setColumn(2, new SQLVarchar(string2));
        execRow.setColumn(3, new SQLChar(string3));
        execRow.setColumn(4, new SQLChar(string4));
        execRow.setColumn(5, new SQLVarchar(string5));
        execRow.setColumn(6, new SQLVarchar(string6));
        execRow.setColumn(7, new SQLChar(bl ? "Y" : "N"));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(4);
        String string4 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(5);
        String string5 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(6);
        String string6 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(7);
        String string7 = dataValueDescriptor.getString();
        PermDescriptor permDescriptor = dataDescriptorGenerator.newPermDescriptor(this.getUUIDFactory().recreateUUID(string), string2, this.getUUIDFactory().recreateUUID(string3), string4, string5, string6, string7.equals("Y"));
        return permDescriptor;
    }

    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("UUID", false), SystemColumnImpl.getColumn("OBJECTTYPE", 12, false, 36), SystemColumnImpl.getUUIDColumn("OBJECTID", false), SystemColumnImpl.getColumn("PERMISSION", 1, false, 36), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIndicatorColumn("ISGRANTABLE")};
    }
}

