/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.annotations;

import com.carrotsearch.randomizedtesting.SysGlobals;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.ANNOTATION_TYPE})
@Inherited
public @interface TestGroup {
    public String name() default "";

    public String sysProperty() default "";

    public boolean enabled() default true;

    public static class Utilities {
        public static String getGroupName(Class<? extends Annotation> annotationClass) {
            TestGroup testGroup = annotationClass.getAnnotation(TestGroup.class);
            if (testGroup == null) {
                throw new IllegalArgumentException("Annotation must have a @TestGroup annotation: " + annotationClass);
            }
            String tmp = Utilities.emptyToNull(testGroup.name());
            return tmp == null ? annotationClass.getSimpleName().toLowerCase(Locale.ENGLISH) : tmp;
        }

        public static String getSysProperty(Class<? extends Annotation> annotationClass) {
            TestGroup testGroup = annotationClass.getAnnotation(TestGroup.class);
            if (testGroup == null) {
                throw new IllegalArgumentException("Annotation must have a @TestGroup annotation: " + annotationClass);
            }
            String tmp = Utilities.emptyToNull(testGroup.sysProperty());
            return tmp != null ? tmp : SysGlobals.prefixProperty(Utilities.getGroupName(annotationClass));
        }

        private static String emptyToNull(String value) {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            return value.trim();
        }
    }
}

