/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import org.apache.solr.util.hll.IWordSerializer;

class BigEndianAscendingWordSerializer
implements IWordSerializer {
    private static final int BITS_PER_BYTE = 8;
    private final int wordLength;
    private final int wordCount;
    private final byte[] bytes;
    private int bitsLeftInByte;
    private int byteIndex;
    private int wordsWritten;

    public BigEndianAscendingWordSerializer(int wordLength, int wordCount, int bytePadding) {
        if (wordLength < 1 || wordLength > 64) {
            throw new IllegalArgumentException("Word length must be >= 1 and <= 64. (was: " + wordLength + ")");
        }
        if (wordCount < 0) {
            throw new IllegalArgumentException("Word count must be >= 0. (was: " + wordCount + ")");
        }
        if (bytePadding < 0) {
            throw new IllegalArgumentException("Byte padding must be must be >= 0. (was: " + bytePadding + ")");
        }
        this.wordLength = wordLength;
        this.wordCount = wordCount;
        long bitsRequired = wordLength * wordCount;
        boolean leftoverBits = bitsRequired % 8L != 0L;
        int bytesRequired = (int)(bitsRequired / 8L) + (leftoverBits ? 1 : 0) + bytePadding;
        this.bytes = new byte[bytesRequired];
        this.bitsLeftInByte = 8;
        this.byteIndex = bytePadding;
        this.wordsWritten = 0;
    }

    @Override
    public void writeWord(long word) {
        int numberOfBitsToWrite;
        if (this.wordsWritten == this.wordCount) {
            throw new RuntimeException("Cannot write more words, backing array full!");
        }
        for (int bitsLeftInWord = this.wordLength; bitsLeftInWord > 0; bitsLeftInWord -= numberOfBitsToWrite) {
            if (this.bitsLeftInByte == 0) {
                ++this.byteIndex;
                this.bitsLeftInByte = 8;
            }
            long consumedMask = bitsLeftInWord == 64 ? -1L : (1L << bitsLeftInWord) - 1L;
            numberOfBitsToWrite = Math.min(this.bitsLeftInByte, bitsLeftInWord);
            int bitsInByteRemainingAfterWrite = this.bitsLeftInByte - numberOfBitsToWrite;
            long remainingBitsOfWordToWrite = word & consumedMask;
            long bitsThatTheByteCanAccept = bitsLeftInWord > numberOfBitsToWrite ? remainingBitsOfWordToWrite >>> bitsLeftInWord - this.bitsLeftInByte : remainingBitsOfWordToWrite;
            long alignedBits = bitsThatTheByteCanAccept << bitsInByteRemainingAfterWrite;
            int n = this.byteIndex;
            this.bytes[n] = (byte)(this.bytes[n] | (byte)alignedBits);
            this.bitsLeftInByte = bitsInByteRemainingAfterWrite;
        }
        ++this.wordsWritten;
    }

    @Override
    public byte[] getBytes() {
        if (this.wordsWritten < this.wordCount) {
            throw new RuntimeException("Not all words have been written! (" + this.wordsWritten + "/" + this.wordCount + ")");
        }
        return this.bytes;
    }
}

