/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeZoneUtils {
    public static final Set<String> KNOWN_TIMEZONE_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TimeZone.getAvailableIDs())));
    private static Pattern CUSTOM_ID_REGEX = Pattern.compile("GMT(?:\\+|\\-)(\\d{1,2})(?::?(\\d{2}))?");

    private TimeZoneUtils() {
    }

    public static final TimeZone getTimeZone(String ID) {
        if (null == ID) {
            return null;
        }
        if (KNOWN_TIMEZONE_IDS.contains(ID)) {
            return TimeZone.getTimeZone(ID);
        }
        Matcher matcher = CUSTOM_ID_REGEX.matcher(ID);
        if (matcher.matches()) {
            int min;
            int hour = Integer.parseInt(matcher.group(1));
            if (hour < 0 || 23 < hour) {
                return null;
            }
            String minStr = matcher.group(2);
            if (null != minStr && ((min = Integer.parseInt(minStr)) < 0 || 59 < min)) {
                return null;
            }
            return TimeZone.getTimeZone(ID);
        }
        return null;
    }
}

