/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Reader;
import org.noggit.CharArr;
import org.noggit.JSONParser;

public class RecordingJSONParser
extends JSONParser {
    private StringBuilder sb = new StringBuilder();
    private long position;
    private boolean objectStarted = false;

    public RecordingJSONParser(Reader in) {
        super(in);
    }

    protected int getChar() throws IOException {
        int aChar = super.getChar();
        if (aChar == 123) {
            this.objectStarted = true;
        }
        if (this.getPosition() > this.position) {
            this.recordChar((char)aChar);
        }
        this.position = this.getPosition();
        return aChar;
    }

    private void recordChar(int aChar) {
        if (this.objectStarted) {
            this.sb.append((char)aChar);
        }
    }

    private void recordStr(String s) {
        if (this.objectStarted) {
            this.sb.append(s);
        }
    }

    public CharArr getStringChars() throws IOException {
        char next;
        CharArr chars = super.getStringChars();
        this.recordStr(chars.toString());
        this.position = this.getPosition();
        if (chars.getArray().length >= chars.getStart() + chars.size() && ((next = chars.getArray()[chars.getStart() + chars.size()]) == '\"' || next == '\'')) {
            this.recordChar(next);
        }
        return chars;
    }

    public void resetBuf() {
        this.sb = new StringBuilder();
        this.objectStarted = false;
    }

    public String getBuf() {
        if (this.sb != null) {
            return this.sb.toString();
        }
        return null;
    }
}

