/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.servlet.BaseSolrFilter;
import org.apache.solr.servlet.HttpSolrCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
extends BaseSolrFilter {
    static final Logger log = LoggerFactory.getLogger(SolrDispatchFilter.class);
    protected volatile CoreContainer cores;
    protected String abortErrorMessage = null;
    protected HttpClient httpClient;
    private ArrayList<Pattern> excludePatterns;
    public static final String PROPERTIES_ATTRIBUTE = "solr.properties";
    public static final String SOLRHOME_ATTRIBUTE = "solr.solr.home";

    public void init(FilterConfig config) throws ServletException {
        block6: {
            log.info("SolrDispatchFilter.init(): {}", (Object)this.getClass().getClassLoader());
            String exclude = config.getInitParameter("excludePatterns");
            if (exclude != null) {
                String[] excludeArray = exclude.split(",");
                this.excludePatterns = new ArrayList();
                for (String element : excludeArray) {
                    this.excludePatterns.add(Pattern.compile(element));
                }
            }
            try {
                String solrHome;
                Properties extraProperties = (Properties)config.getServletContext().getAttribute(PROPERTIES_ATTRIBUTE);
                if (extraProperties == null) {
                    extraProperties = new Properties();
                }
                if ((solrHome = (String)config.getServletContext().getAttribute(SOLRHOME_ATTRIBUTE)) == null) {
                    solrHome = SolrResourceLoader.locateSolrHome();
                }
                ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
                this.cores = this.createCoreContainer(solrHome, extraProperties);
                this.httpClient = this.cores.getUpdateShardHandler().getHttpClient();
                log.info("user.dir=" + System.getProperty("user.dir"));
            }
            catch (Throwable t) {
                log.error("Could not start Solr. Check solr/home property and the logs");
                SolrCore.log(t);
                if (!(t instanceof Error)) break block6;
                throw (Error)t;
            }
        }
        log.info("SolrDispatchFilter.init() done");
    }

    protected CoreContainer createCoreContainer(String solrHome, Properties extraProperties) {
        NodeConfig nodeConfig = SolrDispatchFilter.loadNodeConfig(solrHome, extraProperties);
        this.cores = new CoreContainer(nodeConfig, extraProperties, true);
        this.cores.load();
        return this.cores;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig loadNodeConfig(String solrHome, Properties nodeProperties) {
        String zkHost;
        SolrResourceLoader loader = new SolrResourceLoader(solrHome, null, nodeProperties);
        if (!StringUtils.isEmpty((String)System.getProperty("solr.solrxml.location"))) {
            log.warn("Solr property solr.solrxml.location is no longer supported. Will automatically load solr.xml from ZooKeeper if it exists");
        }
        if (StringUtils.isEmpty((String)(zkHost = System.getProperty("zkHost")))) return SolrXmlConfig.fromSolrHome(loader, loader.getInstanceDir());
        try (SolrZkClient zkClient = new SolrZkClient(zkHost, 30000);){
            if (zkClient.exists("/solr.xml", true).booleanValue()) {
                log.info("solr.xml found in ZooKeeper. Loading...");
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                NodeConfig nodeConfig = SolrXmlConfig.fromInputStream(loader, new ByteArrayInputStream(data));
                return nodeConfig;
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error occurred while loading solr.xml from zookeeper", (Throwable)e);
        }
        log.info("Loading solr.xml from SolrHome (not found in ZooKeeper)");
        return SolrXmlConfig.fromSolrHome(loader, loader.getInstanceDir());
    }

    public CoreContainer getCores() {
        return this.cores;
    }

    public void destroy() {
        if (this.cores != null) {
            this.cores.shutdown();
            this.cores = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, boolean retry) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            return;
        }
        AtomicReference<ServletRequest> wrappedRequest = new AtomicReference<ServletRequest>();
        if (!this.authenticateRequest(request, response, wrappedRequest)) {
            return;
        }
        if (wrappedRequest.get() != null) {
            request = wrappedRequest.get();
        }
        if (this.cores.getAuthenticationPlugin() != null) {
            log.debug("User principal: {}", (Object)((HttpServletRequest)request).getUserPrincipal());
        }
        if (this.excludePatterns != null) {
            String requestPath = ((HttpServletRequest)request).getServletPath();
            String extraPath = ((HttpServletRequest)request).getPathInfo();
            if (extraPath != null) {
                requestPath = requestPath + extraPath;
            }
            for (Pattern p : this.excludePatterns) {
                Matcher matcher = p.matcher(requestPath);
                if (!matcher.lookingAt()) continue;
                chain.doFilter(request, response);
                return;
            }
        }
        HttpSolrCall call = this.getHttpSolrCall((HttpServletRequest)request, (HttpServletResponse)response, retry);
        try {
            Action result = call.call();
            switch (result) {
                case PASSTHROUGH: {
                    chain.doFilter(request, response);
                    return;
                }
                case RETRY: {
                    this.doFilter(request, response, chain, true);
                    return;
                }
                case FORWARD: {
                    request.getRequestDispatcher(call.getPath()).forward(request, response);
                    return;
                }
            }
            return;
        }
        finally {
            call.destroy();
        }
    }

    protected HttpSolrCall getHttpSolrCall(HttpServletRequest request, HttpServletResponse response, boolean retry) {
        return new HttpSolrCall(this, this.cores, request, response, retry);
    }

    private boolean authenticateRequest(ServletRequest request, ServletResponse response, final AtomicReference<ServletRequest> wrappedRequest) throws IOException {
        final AtomicBoolean isAuthenticated = new AtomicBoolean(false);
        AuthenticationPlugin authenticationPlugin = this.cores.getAuthenticationPlugin();
        if (authenticationPlugin == null) {
            return true;
        }
        String header = ((HttpServletRequest)request).getHeader("SolrAuth");
        if (header != null && this.cores.getPkiAuthenticationPlugin() != null) {
            authenticationPlugin = this.cores.getPkiAuthenticationPlugin();
        }
        try {
            log.debug("Request to authenticate: {}, domain: {}, port: {}", new Object[]{request, request.getLocalName(), request.getLocalPort()});
            authenticationPlugin.doAuthenticate(request, response, new FilterChain(){

                public void doFilter(ServletRequest req, ServletResponse rsp) throws IOException, ServletException {
                    isAuthenticated.set(true);
                    wrappedRequest.set(req);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during request authentication, ", (Throwable)e);
        }
        if (!isAuthenticated.get()) {
            response.flushBuffer();
            return false;
        }
        return true;
    }

    static enum Action {
        PASSTHROUGH,
        FORWARD,
        RETURN,
        RETRY,
        ADMIN,
        REMOTEQUERY,
        PROCESS;

    }
}

