/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.util.hll.HLL;

abstract class UniqueSlotAcc
extends SlotAcc {
    HLLAgg.HLLFactory factory;
    SchemaField field;
    FixedBitSet[] arr;
    int currentDocBase;
    int[] counts;
    int nTerms;

    public UniqueSlotAcc(FacetContext fcontext, String field, int numSlots, HLLAgg.HLLFactory factory) throws IOException {
        super(fcontext);
        this.factory = factory;
        this.arr = new FixedBitSet[numSlots];
        this.field = fcontext.searcher.getSchema().getField(field);
    }

    @Override
    public void reset() {
        this.counts = null;
        for (FixedBitSet bits : this.arr) {
            if (bits == null) continue;
            bits.clear(0, bits.length());
        }
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        this.currentDocBase = readerContext.docBase;
    }

    @Override
    public Object getValue(int slot) throws IOException {
        if (this.fcontext.isShard()) {
            return this.getShardValue(slot);
        }
        if (this.counts != null) {
            return this.counts[slot];
        }
        FixedBitSet bs = this.arr[slot];
        return bs == null ? 0 : bs.cardinality();
    }

    private Object getShardHLL(int slot) throws IOException {
        FixedBitSet ords = this.arr[slot];
        if (ords == null) {
            return null;
        }
        HLL hll = this.factory.getHLL();
        long maxOrd = ords.length();
        Hash.LongPair hashResult = new Hash.LongPair();
        int ord = -1;
        while ((long)(++ord) < maxOrd && (ord = ords.nextSetBit(ord)) != Integer.MAX_VALUE) {
            BytesRef val = this.lookupOrd(ord);
            Hash.murmurhash3_x64_128((byte[])val.bytes, (int)val.offset, (int)val.length, (int)0, (Hash.LongPair)hashResult);
            hll.addRaw(hashResult.val1);
        }
        SimpleOrderedMap map = new SimpleOrderedMap();
        map.add("hll", (Object)hll.toBytes());
        return map;
    }

    private Object getShardValue(int slot) throws IOException {
        if (this.factory != null) {
            return this.getShardHLL(slot);
        }
        FixedBitSet ords = this.arr[slot];
        int unique = this.counts != null ? this.counts[slot] : (ords == null ? 0 : ords.cardinality());
        SimpleOrderedMap map = new SimpleOrderedMap();
        map.add("unique", (Object)unique);
        map.add("nTerms", (Object)this.nTerms);
        int maxExplicit = 100;
        if (unique > 0) {
            ArrayList<Object> lst = new ArrayList<Object>(Math.min(unique, maxExplicit));
            long maxOrd = ords.length();
            if (ords != null && ords.length() > 0) {
                int ord = 0;
                while (lst.size() < maxExplicit && (ord = ords.nextSetBit(ord)) != Integer.MAX_VALUE) {
                    BytesRef val = this.lookupOrd(ord);
                    Object o = this.field.getType().toObject(this.field, val);
                    lst.add(o);
                    if ((long)(++ord) < maxOrd) continue;
                    break;
                }
            }
            map.add("vals", lst);
        }
        return map;
    }

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    public void calcCounts() {
        this.counts = new int[this.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            FixedBitSet bs = this.arr[i];
            this.counts[i] = bs == null ? 0 : bs.cardinality();
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        if (this.counts == null) {
            this.calcCounts();
        }
        return this.counts[slotA] - this.counts[slotB];
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        this.arr = resizer.resize(this.arr, null);
    }
}

