/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.facet.CountSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.FacetRangeProcessor;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SpecialSlotAcc;

class FacetFieldProcessorNumeric
extends FacetFieldProcessor {
    static int MAXIMUM_STARTING_TABLE_SIZE = 1024;
    int allBucketsSlot = -1;

    FacetFieldProcessorNumeric(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    public void process() throws IOException {
        super.process();
        this.response = this.calcFacets();
    }

    private void doRehash(LongCounts table) {
        int newTableSize;
        if (this.collectAcc == null && this.allBucketsAcc == null) {
            return;
        }
        int numSlots = newTableSize = table.numSlots();
        final int oldAllBucketsSlot = this.allBucketsSlot;
        if (oldAllBucketsSlot >= 0) {
            this.allBucketsSlot = numSlots++;
        }
        final int finalNumSlots = numSlots;
        final int[] mapping = table.oldToNewMapping;
        SlotAcc.Resizer resizer = new SlotAcc.Resizer(){

            @Override
            public int getNewSize() {
                return finalNumSlots;
            }

            @Override
            public int getNewSlot(int oldSlot) {
                if (oldSlot < mapping.length) {
                    return mapping[oldSlot];
                }
                if (oldSlot == oldAllBucketsSlot) {
                    return FacetFieldProcessorNumeric.this.allBucketsSlot;
                }
                return -1;
            }
        };
        if (this.collectAcc != null) {
            this.collectAcc.resize(resizer);
        }
        if (this.allBucketsAcc != null) {
            this.allBucketsAcc.resize(resizer);
        }
    }

    public SimpleOrderedMap<Object> calcFacets() throws IOException {
        int off;
        final FacetRangeProcessor.Calc calc = FacetRangeProcessor.getNumericCalc(this.sf);
        int possibleValues = this.fcontext.base.size();
        int currHashSize = BitUtil.nextHighestPowerOfTwo((int)((int)((float)possibleValues * 1.4285715f + 1.0f)));
        currHashSize = Math.min(currHashSize, MAXIMUM_STARTING_TABLE_SIZE);
        final LongCounts table = new LongCounts(currHashSize){

            @Override
            protected void rehash() {
                super.rehash();
                FacetFieldProcessorNumeric.this.doRehash(this);
                this.oldToNewMapping = null;
            }
        };
        int numSlots = currHashSize;
        boolean numMissing = false;
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsSlot = numSlots++;
        }
        this.indexOrderAcc = new SlotAcc(this.fcontext){

            @Override
            public void collect(int doc, int slot) throws IOException {
            }

            @Override
            public int compare(int slotA, int slotB) {
                long s1 = calc.bitsToSortableBits(table.vals[slotA]);
                long s2 = calc.bitsToSortableBits(table.vals[slotB]);
                return Long.compare(s1, s2);
            }

            @Override
            public Object getValue(int slotNum) throws IOException {
                return null;
            }

            @Override
            public void reset() {
            }

            @Override
            public void resize(SlotAcc.Resizer resizer) {
            }
        };
        this.countAcc = new CountSlotAcc(this.fcontext){

            @Override
            public void incrementCount(int slot, int count) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getCount(int slot) {
                return table.counts[slot];
            }

            @Override
            public Object getValue(int slotNum) {
                return this.getCount(slotNum);
            }

            @Override
            public void reset() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void collect(int doc, int slot) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compare(int slotA, int slotB) {
                return Integer.compare(table.counts[slotA], table.counts[slotB]);
            }

            @Override
            public void resize(SlotAcc.Resizer resizer) {
                throw new UnsupportedOperationException();
            }
        };
        this.createCollectAcc(this.fcontext.base.size(), numSlots);
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsAcc = new SpecialSlotAcc(this.fcontext, this.collectAcc, this.allBucketsSlot, this.otherAccs, 0);
        }
        NumericDocValues values = null;
        Bits docsWithField = null;
        List leaves = this.fcontext.searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = this.fcontext.base.iterator();
        while (docsIt.hasNext()) {
            int segDoc;
            long val;
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = (ctx = (LeafReaderContext)ctxIt.next()).reader().maxDoc()))) {
                }
                assert (doc >= ctx.docBase);
                this.setNextReaderFirstPhase(ctx);
                values = DocValues.getNumeric((LeafReader)ctx.reader(), (String)this.sf.getName());
                docsWithField = DocValues.getDocsWithField((LeafReader)ctx.reader(), (String)this.sf.getName());
            }
            if ((val = values.get(segDoc = doc - segBase)) == 0L && !docsWithField.get(segDoc)) continue;
            int slot = table.add(val);
            this.collectFirstPhase(segDoc, slot);
        }
        int numBuckets = 0;
        ArrayList<Comparable> bucketVals = null;
        if (((FacetField)this.freq).numBuckets && this.fcontext.isShard()) {
            bucketVals = new ArrayList<Comparable>(100);
        }
        int n = off = this.fcontext.isShard() ? 0 : (int)((FacetField)this.freq).offset;
        int lim = ((FacetField)this.freq).limit >= 0L ? (this.fcontext.isShard() ? (int)((double)((FacetField)this.freq).limit * 1.1 + 4.0) : (int)((FacetField)this.freq).limit) : Integer.MAX_VALUE;
        int maxsize = (int)(((FacetField)this.freq).limit > 0L ? ((FacetField)this.freq).offset + (long)lim : 0x7FFFFFFEL);
        maxsize = Math.min(maxsize, table.cardinality);
        final int sortMul = ((FacetField)this.freq).sortDirection.getMultiplier();
        PriorityQueue<FacetFieldProcessor.Slot> queue = new PriorityQueue<FacetFieldProcessor.Slot>(maxsize){

            protected boolean lessThan(FacetFieldProcessor.Slot a, FacetFieldProcessor.Slot b) {
                int cmp = FacetFieldProcessorNumeric.this.sortAcc.compare(a.slot, b.slot) * sortMul;
                return cmp == 0 ? FacetFieldProcessorNumeric.this.indexOrderAcc.compare(a.slot, b.slot) > 0 : cmp < 0;
            }
        };
        FacetFieldProcessor.Slot bottom = null;
        for (int i = 0; i < table.counts.length; ++i) {
            int count = table.counts[i];
            if (count < this.effectiveMincount) continue;
            ++numBuckets;
            long val = table.vals[i];
            if (bucketVals != null && bucketVals.size() < 100) {
                bucketVals.add(calc.bitsToValue(val));
            }
            if (bottom == null) {
                bottom = new FacetFieldProcessor.Slot();
            }
            bottom.slot = i;
            bottom = (FacetFieldProcessor.Slot)queue.insertWithOverflow((Object)bottom);
        }
        SimpleOrderedMap res = new SimpleOrderedMap();
        if (((FacetField)this.freq).numBuckets) {
            if (!this.fcontext.isShard()) {
                res.add("numBuckets", (Object)numBuckets);
            } else {
                SimpleOrderedMap map = new SimpleOrderedMap(2);
                map.add("numBuckets", (Object)numBuckets);
                map.add("vals", bucketVals);
                res.add("numBuckets", (Object)map);
            }
        }
        if (((FacetField)this.freq).allBuckets) {
            SimpleOrderedMap allBuckets = new SimpleOrderedMap();
            allBuckets.add("count", (Object)table.numAdds);
            this.allBucketsAcc.setValues((SimpleOrderedMap<Object>)allBuckets, -1);
            res.add("allBuckets", (Object)allBuckets);
        }
        if (((FacetField)this.freq).missing) {
            SimpleOrderedMap missingBucket = new SimpleOrderedMap();
            this.fillBucket((SimpleOrderedMap<Object>)missingBucket, FacetFieldProcessorNumeric.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null);
            res.add("missing", (Object)missingBucket);
        }
        int collectCount = Math.max(0, queue.size() - off);
        assert (collectCount <= lim);
        int[] sortedSlots = new int[collectCount];
        for (int i = collectCount - 1; i >= 0; --i) {
            sortedSlots[i] = ((FacetFieldProcessor.Slot)queue.pop()).slot;
        }
        ArrayList<SimpleOrderedMap> bucketList = new ArrayList<SimpleOrderedMap>(collectCount);
        res.add("buckets", bucketList);
        boolean needFilter = this.deferredAggs != null || ((FacetField)this.freq).getSubFacets().size() > 0;
        for (int slotNum : sortedSlots) {
            SimpleOrderedMap bucket = new SimpleOrderedMap();
            Comparable val = calc.bitsToValue(table.vals[slotNum]);
            bucket.add("val", (Object)val);
            Query filter = needFilter ? this.sf.getType().getFieldQuery(null, this.sf, calc.formatValue(val)) : null;
            this.fillBucket((SimpleOrderedMap<Object>)bucket, table.counts[slotNum], slotNum, null, filter);
            bucketList.add(bucket);
        }
        return res;
    }

    static class LongCounts {
        static final float LOAD_FACTOR = 0.7f;
        long numAdds;
        long[] vals;
        int[] counts;
        int[] oldToNewMapping;
        int cardinality;
        int threshold;

        LongCounts(int sz) {
            this.vals = new long[sz];
            this.counts = new int[sz];
            this.threshold = (int)((float)sz * 0.7f);
        }

        public int numSlots() {
            return this.vals.length;
        }

        private int hash(long val) {
            int h = (int)(val + (val >>> 44) + (val >>> 15));
            return h;
        }

        int add(long val) {
            if (this.cardinality >= this.threshold) {
                this.rehash();
            }
            ++this.numAdds;
            int h = this.hash(val);
            int slot = h & this.vals.length - 1;
            while (true) {
                int count;
                if ((count = this.counts[slot]) == 0) {
                    this.counts[slot] = 1;
                    this.vals[slot] = val;
                    ++this.cardinality;
                    return slot;
                }
                if (this.vals[slot] == val) {
                    this.counts[slot] = count + 1;
                    return slot;
                }
                slot = slot + (h >> 7 | 1) & this.vals.length - 1;
            }
        }

        protected void rehash() {
            long[] oldVals = this.vals;
            int[] oldCounts = this.counts;
            int newCapacity = this.vals.length << 1;
            this.vals = new long[newCapacity];
            this.counts = new int[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.7f);
            for (int i = 0; i < oldVals.length; ++i) {
                int count = oldCounts[i];
                if (count == 0) {
                    oldCounts[i] = -1;
                    continue;
                }
                long val = oldVals[i];
                int h = this.hash(val);
                int slot = h & this.vals.length - 1;
                while (this.counts[slot] != 0) {
                    slot = slot + (h >> 7 | 1) & this.vals.length - 1;
                }
                this.counts[slot] = count;
                this.vals[slot] = val;
                oldCounts[i] = slot;
            }
            this.oldToNewMapping = oldCounts;
        }

        int cardinality() {
            return this.cardinality;
        }
    }
}

