/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.IdentityHashMap;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;

public class QueryContext
extends IdentityHashMap
implements Closeable {
    private final SolrIndexSearcher searcher;
    private final IndexSearcher indexSearcher;
    private IdentityHashMap<Closeable, String> closeHooks;

    public static QueryContext newContext(IndexSearcher searcher) {
        QueryContext context = new QueryContext(searcher);
        return context;
    }

    public QueryContext(IndexSearcher searcher) {
        this.searcher = searcher instanceof SolrIndexSearcher ? (SolrIndexSearcher)searcher : null;
        this.indexSearcher = searcher;
        this.put("searcher", searcher);
    }

    public SolrIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexSearcher indexSearcher() {
        return this.indexSearcher;
    }

    public void addCloseHook(Closeable closeable) {
        if (this.closeHooks == null) {
            this.closeHooks = new IdentityHashMap();
            SolrRequestInfo.getRequestInfo().addCloseHook(this);
        }
        this.closeHooks.put(closeable, "");
    }

    public boolean removeCloseHook(Closeable closeable) {
        return this.closeHooks.remove(closeable) != null;
    }

    @Override
    public void close() throws IOException {
        if (this.closeHooks != null) {
            for (Closeable hook : this.closeHooks.keySet()) {
                try {
                    hook.close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)SolrCore.log, (String)"Exception during close hook", (Throwable)e);
                }
            }
        }
        this.closeHooks = null;
    }
}

