/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Map;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.solr.schema.AbstractSpatialPrefixTreeFieldType;
import org.apache.solr.schema.IndexSchema;

public class SpatialRecursivePrefixTreeFieldType
extends AbstractSpatialPrefixTreeFieldType<RecursivePrefixTreeStrategy> {
    public static final String PREFIX_GRID_SCAN_LEVEL = "prefixGridScanLevel";
    private Integer prefixGridScanLevel;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String v = args.remove(PREFIX_GRID_SCAN_LEVEL);
        if (v != null) {
            this.prefixGridScanLevel = Integer.valueOf(v);
        }
    }

    @Override
    protected RecursivePrefixTreeStrategy newPrefixTreeStrategy(String fieldName) {
        RecursivePrefixTreeStrategy strategy = new RecursivePrefixTreeStrategy(this.grid, fieldName);
        if (this.prefixGridScanLevel != null) {
            strategy.setPrefixGridScanLevel(this.prefixGridScanLevel.intValue());
        }
        if (this.grid instanceof PackedQuadPrefixTree) {
            ((PackedQuadPrefixTree)this.grid).setPruneLeafyBranches(true);
            strategy.setPruneLeafyBranches(false);
        }
        return strategy;
    }
}

