/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetProperties {
    private static final Logger log = LoggerFactory.getLogger(ConfigSetProperties.class);

    public static NamedList readFromResourceLoader(SolrResourceLoader loader, String name) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(loader.openResource(name), StandardCharsets.UTF_8);
        }
        catch (SolrResourceNotFoundException ex) {
            log.info("Did not find ConfigSet properties, assuming default properties: " + ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to load reader for ConfigSet properties: " + name, (Throwable)ex);
        }
        try {
            JSONParser jsonParser = new JSONParser((Reader)reader);
            Object object = ObjectBuilder.getVal((JSONParser)jsonParser);
            if (!(object instanceof Map)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid JSON type " + object.getClass().getName() + ", expected Map");
            }
            NamedList namedList = new NamedList((Map)object);
            return namedList;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to load ConfigSet properties", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

