/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.mapper.processor;

import org.apache.uima.UIMAFramework;
import org.apache.uima.alchemy.digester.domain.EntitiesResults;
import org.apache.uima.alchemy.digester.domain.Entity;
import org.apache.uima.alchemy.digester.domain.Results;
import org.apache.uima.alchemy.mapper.processor.AlchemyOutputProcessor;
import org.apache.uima.alchemy.ts.entity.AlchemyAnnotation;
import org.apache.uima.alchemy.ts.entity.BaseEntity;
import org.apache.uima.alchemy.ts.sentiment.SentimentFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankedEntitiesProcessor
implements AlchemyOutputProcessor {
    private static final String ENTITY_PACKAGE_NAME = "org.apache.uima.alchemy.ts.entity.";

    @Override
    public void process(JCas cas, Results results) throws Exception {
        for (Entity entity : ((EntitiesResults)results).getEntities().getEntities()) {
            BaseEntity fs = this.getFeatureStructure(entity.getType(), cas);
            if (fs == null) continue;
            Type type = fs.getType();
            fs.setFeatureValueFromString(type.getFeatureByBaseName("count"), entity.getCount());
            fs.setFeatureValueFromString(type.getFeatureByBaseName("text"), entity.getText());
            fs.setFeatureValueFromString(type.getFeatureByBaseName("relevance"), entity.getRelevance());
            if (entity.getDisambiguated() != null) {
                fs.setFeatureValueFromString(type.getFeatureByBaseName("disambiguation"), entity.getDisambiguated().getName());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("dbpedia"), entity.getDisambiguated().getDbpedia());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("website"), entity.getDisambiguated().getWebsite());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("subType"), entity.getDisambiguated().getSubType());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("geo"), entity.getDisambiguated().getGeo());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("opencyc"), entity.getDisambiguated().getOpencyc());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("yago"), entity.getDisambiguated().getYago());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("umbel"), entity.getDisambiguated().getUmbel());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("freebase"), entity.getDisambiguated().getFreebase());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("ciaFactbook"), entity.getDisambiguated().getCiaFactbook());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("census"), entity.getDisambiguated().getCensus());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("geonames"), entity.getDisambiguated().getGeonames());
                fs.setFeatureValueFromString(type.getFeatureByBaseName("musicBrainz"), entity.getDisambiguated().getMusicBrainz());
            }
            if (entity.getQuotations() != null && entity.getQuotations().getQuotations() != null && entity.getQuotations().getQuotations().size() > 0) {
                StringArray quotationsFeatureStructure = new StringArray(cas, entity.getQuotations().getQuotations().size());
                int i = 0;
                for (String quotation : entity.getQuotations().getQuotations()) {
                    quotationsFeatureStructure.set(i, quotation);
                    ++i;
                }
                fs.setFeatureValue(type.getFeatureByBaseName("quotations"), (FeatureStructure)quotationsFeatureStructure);
            }
            if (entity.getSentiment() != null) {
                SentimentFS sentimentFS = new SentimentFS(cas);
                sentimentFS.setScore(entity.getSentiment().getScore());
                sentimentFS.setSentimentType(entity.getSentiment().getType());
                sentimentFS.addToIndexes();
                fs.setFeatureValue(type.getFeatureByBaseName("sentiment"), (FeatureStructure)sentimentFS);
            }
            cas.addFsToIndexes((FeatureStructure)fs);
            this.buildAnnotations(cas, fs);
        }
    }

    private void buildAnnotations(JCas cas, BaseEntity fs) {
        Type type = fs.getType();
        String entityText = fs.getStringValue(type.getFeatureByBaseName("text"));
        int annotationStart = cas.getDocumentText().indexOf(entityText);
        if (annotationStart > 0) {
            AlchemyAnnotation alchemyAnnotation = new AlchemyAnnotation(cas, annotationStart, annotationStart + entityText.length());
            alchemyAnnotation.setAlchemyType(type.toString());
            alchemyAnnotation.addToIndexes();
            UIMAFramework.getLogger().log(Level.INFO, "added AlchemyAnnotation for " + alchemyAnnotation.getCoveredText() + " of type " + type.toString());
            NonEmptyFSList list = (NonEmptyFSList)fs.getOccurrences();
            if (list != null) {
                NonEmptyFSList newTail = new NonEmptyFSList(cas);
                newTail.setHead(list.getHead());
                newTail.setTail(list.getTail());
            } else {
                list = new NonEmptyFSList(cas);
            }
            list.setHead((TOP)alchemyAnnotation);
            fs.setOccurrences((FSList)list);
        }
    }

    private BaseEntity getFeatureStructure(String type, JCas aJCas) {
        BaseEntity fsObject = null;
        String typeName = ENTITY_PACKAGE_NAME + type;
        Class<?> typeClass = this.getClassFromName(typeName);
        if (typeClass != null) {
            try {
                fsObject = (BaseEntity)((Object)typeClass.getConstructor(JCas.class).newInstance(aJCas));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return fsObject;
    }

    private Class<?> getClassFromName(String typeName) {
        Class<?> toReturn = null;
        try {
            toReturn = Class.forName(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return toReturn;
    }
}

