/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.digester.json;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.uima.alchemy.digester.json.JsonParserConstants;
import org.apache.uima.alchemy.digester.json.JsonParserTokenManager;
import org.apache.uima.alchemy.digester.json.ParseException;
import org.apache.uima.alchemy.digester.json.SimpleCharStream;
import org.apache.uima.alchemy.digester.json.Token;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class JsonParser
implements JsonParserConstants {
    private static final String ROOT = "$";
    private static final String EMPTY_URI = "";
    private static final AttributesImpl ATTRIBUTES = new AttributesImpl();
    private final Stack<String> objectStack = new Stack();
    private String rootElementName = "$";
    private ContentHandler contentHandler;
    public JsonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[21];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setRootElementName(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    private void startElement(String name) throws SAXException {
        this.contentHandler.startElement(EMPTY_URI, name, name, ATTRIBUTES);
    }

    private void endElement(String name) throws SAXException {
        this.contentHandler.endElement(EMPTY_URI, name, name);
    }

    private void text(String text) throws SAXException {
        this.contentHandler.characters(text.toCharArray(), 0, text.length());
    }

    public final void json() throws ParseException, SAXException {
        this.contentHandler.startDocument();
        this.objectStack.push(this.rootElementName);
        if (this.jj_2_1(2)) {
            this.object();
        } else if (this.jj_2_2(2)) {
            this.array();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.contentHandler.endDocument();
    }

    private final void object() throws ParseException, SAXException {
        this.jj_consume_token(18);
        this.startElement(this.objectStack.peek());
        if (this.jj_2_3(2)) {
            this.members();
        }
        this.jj_consume_token(19);
        this.endElement(this.objectStack.peek());
    }

    private final void members() throws ParseException, SAXException {
        this.pair();
        if (this.jj_2_4(2)) {
            this.jj_consume_token(20);
            this.members();
        }
    }

    private final void pair() throws ParseException, SAXException {
        String property = this.jsonString();
        this.objectStack.push(property);
        this.jj_consume_token(21);
        this.value();
    }

    private final void value() throws ParseException, SAXException {
        if (this.jj_2_9(2)) {
            String text;
            this.startElement(this.objectStack.peek());
            if (this.jj_2_5(2)) {
                text = this.jsonString();
            } else if (this.jj_2_6(2)) {
                text = this.jsonNumber();
            } else if (this.jj_2_7(2)) {
                text = this.jj_consume_token((int)22).image;
            } else if (this.jj_2_8(2)) {
                text = this.jj_consume_token((int)23).image;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.text(text);
            this.endElement(this.objectStack.pop());
        } else if (this.jj_2_10(2)) {
            this.array();
        } else if (this.jj_2_11(2)) {
            this.object();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private final void array() throws ParseException, SAXException {
        this.jj_consume_token(24);
        if (this.jj_2_12(2)) {
            this.elements();
        }
        this.jj_consume_token(25);
        this.objectStack.pop();
    }

    private final void elements() throws ParseException, SAXException {
        this.value();
        if (this.jj_2_13(2)) {
            this.jj_consume_token(20);
            this.elements();
        }
    }

    private final String jsonString() throws ParseException {
        StringBuilder buffer = new StringBuilder();
        this.jj_consume_token(4);
        if (this.jj_2_14(2)) {
            this.chars(buffer);
        }
        this.jj_consume_token(6);
        return buffer.toString();
    }

    private final void chars(StringBuilder buffer) throws ParseException {
        char c = this.character();
        if (this.jj_2_15(2)) {
            this.chars(buffer);
        }
        buffer.insert(0, c);
    }

    private final char character() throws ParseException {
        Token t;
        if (this.jj_2_16(2)) {
            t = this.jj_consume_token(7);
        } else if (this.jj_2_17(2)) {
            t = this.jj_consume_token(8);
        } else if (this.jj_2_18(2)) {
            t = this.jj_consume_token(11);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (t.image.length() < 2) {
            return t.image.charAt(0);
        }
        if (t.image.length() < 6) {
            char c = t.image.charAt(1);
            switch (t.image.charAt(1)) {
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 't': {
                    return '\t';
                }
            }
            return c;
        }
        int i = Integer.valueOf(t.image.substring(2, 6), 16);
        return (char)i;
    }

    private final String jsonNumber() throws ParseException {
        String intpart = EMPTY_URI;
        String fracpart = EMPTY_URI;
        String exppart = EMPTY_URI;
        intpart = this.jsonInt();
        if (this.jj_2_19(2)) {
            fracpart = this.jsonFrac();
        }
        if (this.jj_2_20(2)) {
            exppart = this.jsonExp();
        }
        return intpart + fracpart + exppart;
    }

    private final String jsonInt() throws ParseException {
        boolean negative = false;
        if (this.jj_2_21(2)) {
            this.jj_consume_token(26);
            negative = true;
        }
        String digits = this.digits();
        if (negative) {
            return "-" + digits;
        }
        return digits;
    }

    private final String jsonFrac() throws ParseException {
        this.jj_consume_token(27);
        String digits = this.digits();
        return "." + digits;
    }

    private final String jsonExp() throws ParseException {
        Token t = this.jj_consume_token(2);
        String digits = this.digits();
        return t.image + digits;
    }

    private final String digits() throws ParseException {
        Token t = this.jj_consume_token(3);
        return t.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    private boolean jj_3_12() {
        return this.jj_3R_6();
    }

    private boolean jj_3_1() {
        return this.jj_3R_1();
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_2() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_11() {
        return this.jj_3R_1();
    }

    private boolean jj_3_10() {
        return this.jj_3R_2();
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_8() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_19() {
        return this.jj_3R_8();
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_15() {
        return this.jj_3R_7();
    }

    private boolean jj_3_6() {
        return this.jj_3R_5();
    }

    private boolean jj_3_5() {
        return this.jj_3R_4();
    }

    private boolean jj_3_18() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_17() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_7()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_8()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_18()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_11()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_21() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_14() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_7() {
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_3();
    }

    private boolean jj_3R_10() {
        return this.jj_3R_4();
    }

    private boolean jj_3_20() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_5() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private boolean jj_3R_4() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_3() {
        return this.jj_3R_10();
    }

    private boolean jj_3_2() {
        return this.jj_3R_2();
    }

    private boolean jj_3_3() {
        return this.jj_3R_3();
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_6() {
        if (this.jj_3R_12()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_1() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(19);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    public JsonParser(InputStream stream) {
        this(stream, null);
    }

    public JsonParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JsonParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JsonParser(JsonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JsonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 28; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 21; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        JsonParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

