/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTMessage;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import com.pff.PSTTableBC;
import com.pff.PSTTableBCItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSTAttachment
extends PSTObject {
    public static final int ATTACHMENT_METHOD_NONE = 0;
    public static final int ATTACHMENT_METHOD_BY_VALUE = 1;
    public static final int ATTACHMENT_METHOD_BY_REFERENCE = 2;
    public static final int ATTACHMENT_METHOD_BY_REFERENCE_RESOLVE = 3;
    public static final int ATTACHMENT_METHOD_BY_REFERENCE_ONLY = 4;
    public static final int ATTACHMENT_METHOD_EMBEDDED = 5;
    public static final int ATTACHMENT_METHOD_OLE = 6;

    PSTAttachment(PSTFile theFile, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        super(theFile, null, table, localDescriptorItems);
    }

    public int getSize() {
        return this.getIntItem(3616);
    }

    @Override
    public Date getCreationTime() {
        return this.getDateItem(12295);
    }

    public Date getModificationTime() {
        return this.getDateItem(12296);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PSTMessage getEmbeddedPSTMessage() throws IOException, PSTException {
        PSTNodeInputStream in = null;
        if (this.getIntItem(14085) != 5) return null;
        PSTTableBCItem item = (PSTTableBCItem)this.items.get(14081);
        if (item.entryValueType == 258) {
            if (item.isExternalValueReference) throw new PSTException("External reference in getEmbeddedPSTMessage()!\n");
            in = new PSTNodeInputStream(this.pstFile, item.data);
        } else if (item.entryValueType == 13) {
            int descriptorItem = (int)PSTObject.convertLittleEndianBytesToLong(item.data, 0, 4);
            PSTDescriptorItem descriptorItemNested = (PSTDescriptorItem)this.localDescriptorItems.get(descriptorItem);
            in = new PSTNodeInputStream(this.pstFile, descriptorItemNested);
            this.localDescriptorItems.putAll(this.pstFile.getPSTDescriptorItems(descriptorItemNested.subNodeOffsetIndexIdentifier));
        }
        if (in == null) {
            return null;
        }
        try {
            PSTTableBC attachmentTable = new PSTTableBC(in);
            return PSTObject.createAppropriatePSTMessageObject(this.pstFile, this.descriptorIndexNode, attachmentTable, this.localDescriptorItems);
        }
        catch (PSTException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getFileInputStream() throws IOException, PSTException {
        PSTTableBCItem attachmentDataObject = (PSTTableBCItem)this.items.get(14081);
        if (attachmentDataObject.isExternalValueReference) {
            PSTDescriptorItem descriptorItemNested = (PSTDescriptorItem)this.localDescriptorItems.get(attachmentDataObject.entryValueReference);
            return new PSTNodeInputStream(this.pstFile, descriptorItemNested);
        }
        return new PSTNodeInputStream(this.pstFile, attachmentDataObject.data, false);
    }

    public int getFilesize() throws PSTException, IOException {
        PSTTableBCItem attachmentDataObject = (PSTTableBCItem)this.items.get(14081);
        if (attachmentDataObject.isExternalValueReference) {
            PSTDescriptorItem descriptorItemNested = (PSTDescriptorItem)this.localDescriptorItems.get(attachmentDataObject.entryValueReference);
            if (descriptorItemNested == null) {
                throw new PSTException("missing attachment descriptor item for: " + attachmentDataObject.entryValueReference);
            }
            return descriptorItemNested.getDataSize();
        }
        return attachmentDataObject.data.length;
    }

    public String getFilename() {
        return this.getStringItem(14084);
    }

    public int getAttachMethod() {
        return this.getIntItem(14085);
    }

    public int getAttachSize() {
        return this.getIntItem(3616);
    }

    public int getAttachNum() {
        return this.getIntItem(3617);
    }

    public String getLongFilename() {
        return this.getStringItem(14087);
    }

    public String getPathname() {
        return this.getStringItem(14088);
    }

    public int getRenderingPosition() {
        return this.getIntItem(14091);
    }

    public String getLongPathname() {
        return this.getStringItem(14093);
    }

    public String getMimeTag() {
        return this.getStringItem(14094);
    }

    public int getMimeSequence() {
        return this.getIntItem(14096);
    }

    public String getContentId() {
        return this.getStringItem(14098);
    }

    public boolean isAttachmentInvisibleInHtml() {
        int actionFlag = this.getIntItem(14100);
        return (actionFlag & 1) > 0;
    }

    public boolean isAttachmentInvisibleInRTF() {
        int actionFlag = this.getIntItem(14100);
        return (actionFlag & 2) > 0;
    }

    public boolean isAttachmentMhtmlRef() {
        int actionFlag = this.getIntItem(14100);
        return (actionFlag & 4) > 0;
    }

    public String getAttachmentContentDisposition() {
        return this.getStringItem(14102);
    }
}

