/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;

public final class AlternatingLeastSquaresSolver {
    public Vector solve(Iterable<Vector> featureVectors, Vector ratingVector, double lambda, int numFeatures) {
        Preconditions.checkNotNull(featureVectors, (Object)"Feature vectors cannot be null");
        Preconditions.checkArgument((!Iterables.isEmpty(featureVectors) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)ratingVector, (Object)"rating vector cannot be null");
        Preconditions.checkArgument((ratingVector.getNumNondefaultElements() > 0 ? 1 : 0) != 0, (Object)"Rating vector cannot be empty");
        Preconditions.checkArgument((Iterables.size(featureVectors) == ratingVector.getNumNondefaultElements() ? 1 : 0) != 0);
        int nui = ratingVector.getNumNondefaultElements();
        Matrix MiIi = this.createMiIi(featureVectors, numFeatures);
        Matrix RiIiMaybeTransposed = this.createRiIiMaybeTransposed(ratingVector);
        Matrix Ai = this.addLambdaTimesNuiTimesE(MiIi.times(MiIi.transpose()), lambda, nui);
        Matrix Vi = MiIi.times(RiIiMaybeTransposed);
        return this.solve(Ai, Vi);
    }

    Vector solve(Matrix Ai, Matrix Vi) {
        return new QRDecomposition(Ai).solve(Vi).viewColumn(0);
    }

    Matrix addLambdaTimesNuiTimesE(Matrix matrix, double lambda, int nui) {
        Preconditions.checkArgument((matrix.numCols() == matrix.numRows() ? 1 : 0) != 0);
        for (int n = 0; n < matrix.numCols(); ++n) {
            matrix.setQuick(n, n, matrix.getQuick(n, n) + lambda * (double)nui);
        }
        return matrix;
    }

    Matrix createMiIi(Iterable<Vector> featureVectors, int numFeatures) {
        DenseMatrix MiIi = new DenseMatrix(numFeatures, Iterables.size(featureVectors));
        int n = 0;
        for (Vector featureVector : featureVectors) {
            for (int m = 0; m < numFeatures; ++m) {
                MiIi.setQuick(m, n, featureVector.getQuick(m));
            }
            ++n;
        }
        return MiIi;
    }

    Matrix createRiIiMaybeTransposed(Vector ratingVector) {
        Preconditions.checkArgument((boolean)ratingVector.isSequentialAccess());
        DenseMatrix RiIiMaybeTransposed = new DenseMatrix(ratingVector.getNumNondefaultElements(), 1);
        Iterator<Vector.Element> ratingsIterator = ratingVector.iterateNonZero();
        int index = 0;
        while (ratingsIterator.hasNext()) {
            Vector.Element elem = ratingsIterator.next();
            RiIiMaybeTransposed.setQuick(index++, 0, elem.get());
        }
        return RiIiMaybeTransposed;
    }
}

