/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseColumnMatrix
extends AbstractMatrix {
    private Vector[] columnVectors;

    public SparseColumnMatrix(int rows, int columns, RandomAccessSparseVector[] columnVectors) {
        super(rows, columns);
        this.columnVectors = (Vector[])this.columnVectors.clone();
        for (int col = 0; col < this.columnSize(); ++col) {
            this.columnVectors[col] = this.columnVectors[col].clone();
        }
    }

    public SparseColumnMatrix(int rows, int columns) {
        super(rows, columns);
        this.columnVectors = new RandomAccessSparseVector[this.columnSize()];
        for (int col = 0; col < this.columnSize(); ++col) {
            this.columnVectors[col] = new RandomAccessSparseVector(this.rowSize());
        }
    }

    @Override
    public Matrix clone() {
        SparseColumnMatrix clone = (SparseColumnMatrix)super.clone();
        clone.columnVectors = new Vector[this.columnVectors.length];
        for (int i = 0; i < this.columnVectors.length; ++i) {
            clone.columnVectors[i] = this.columnVectors[i].clone();
        }
        return clone;
    }

    @Override
    public int numSlices() {
        return this.numCols();
    }

    @Override
    public double getQuick(int row, int column) {
        return this.columnVectors[column] == null ? 0.0 : this.columnVectors[column].getQuick(row);
    }

    @Override
    public Matrix like() {
        return new SparseColumnMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseColumnMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        if (this.columnVectors[column] == null) {
            this.columnVectors[column] = new RandomAccessSparseVector(this.rowSize());
        }
        this.columnVectors[column].setQuick(row, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[1] = this.columnVectors.length;
        for (int col = 0; col < this.columnSize(); ++col) {
            result[0] = Math.max(result[0], this.columnVectors[col].getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.columnVectors[1].size());
        }
        if (offset[0] + size[0] > this.columnVectors[1].size()) {
            throw new IndexException(offset[0] + size[0], this.columnVectors[1].size());
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.columnVectors.length);
        }
        if (offset[1] + size[1] > this.columnVectors.length) {
            throw new IndexException(offset[1] + size[1], this.columnVectors.length);
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        this.columnVectors[column].assign(other);
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        for (int col = 0; col < this.columnSize(); ++col) {
            this.columnVectors[col].setQuick(row, other.getQuick(col));
        }
        return this;
    }

    @Override
    public Vector viewColumn(int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        return this.columnVectors[column];
    }
}

