/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="url-resource")
public class URLResource
implements IResource {
    private URL url;
    @Attribute(name="url")
    private String info;

    URLResource() {
    }

    public URLResource(URL url) {
        this.url = url;
        this.info = url.toExternalForm();
    }

    @Override
    public InputStream open() throws IOException {
        return StreamUtils.prefetch(this.url.openStream());
    }

    public String toString() {
        return this.info;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URLResource) {
            return ((URLResource)obj).info.equals(this.info);
        }
        return false;
    }

    public final int hashCode() {
        return this.info.hashCode();
    }

    public URL getUrl() {
        return this.url;
    }

    @Commit
    void afterDeserialization() throws MalformedURLException {
        this.url = new URL(this.info);
    }
}

