/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbSQLTypeScanner {
    private static final char NULL = '\u0000';
    private static final int STATE_START = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_DONE = 10;
    public static final int STMT_UNKNOWN = 0;
    public static final int STMT_QUERY = 16;
    public static final int STMT_DML = 32;
    public static final int STMT_DML_DELETE = 33;
    public static final int STMT_DML_UPDATE = 34;
    public static final int STMT_DML_INSERT = 36;
    public static final int STMT_DML_MERGE = 40;
    public static final int STMT_PSM = 64;
    public static final int STMT_PSM_BEGIN = 65;
    public static final int STMT_PSM_CALL = 66;
    public static final int STMT_PSM_DECLARE = 68;
    public static final int STMT_DDL = 128;
    public static final int STMT_DDL_CTAS = 132;
    public static final int STMT_DDL_JAVA_SRC = 136;
    private int state;
    private int index;
    private int textLen;
    private String text;

    public int getCurrentIndex() {
        return this.index;
    }

    private char getNextChar() {
        if (this.index < this.textLen) {
            return this.text.charAt(this.index++);
        }
        return '\u0000';
    }

    public synchronized String callDeclareSyntax(String string) {
        String[] stringArray;
        this.index = 0;
        this.textLen = string.length();
        this.text = string;
        String string2 = this.getToken();
        if (string2.startsWith((stringArray = new String[]{"{", "CALL", "DECLARE", "<<", ">>"})[0])) {
            String string3 = string2 = string2.length() == stringArray[0].length() ? this.getToken() : string2.substring(stringArray[0].length());
            if (string2.equals(stringArray[1])) {
                string2 = this.getToken();
                if (string2.equals(stringArray[2])) {
                    this.text = this.text.replaceFirst("CALL", "").replaceFirst("call", "").replaceFirst("\\{", "");
                    this.text = TbSQLTypeScanner.replaceLast(this.text, "}", ";");
                } else if (string2.startsWith(stringArray[3])) {
                    while (!string2.equals(stringArray[4])) {
                        string2 = string2.length() == stringArray[3].length() ? this.getToken() : string2.substring(stringArray[3].length());
                    }
                    string2 = this.getToken();
                    if (string2.equals(stringArray[2])) {
                        this.text = this.text.replaceFirst("CALL", "").replaceFirst("call", "").replaceFirst("\\{", "");
                        this.text = TbSQLTypeScanner.replaceLast(this.text, "}", ";");
                    }
                }
            }
        }
        return this.text;
    }

    private static String replaceLast(String string, String string2, String string3) {
        return string.replaceFirst("(?s)(.*)" + string2, "$1" + string3);
    }

    public synchronized int getSQLType(String string) {
        this.index = 0;
        this.textLen = string.length();
        this.text = string;
        String string2 = this.getToken();
        if (string2.equals("(")) {
            string2 = this.getToken();
        }
        if (string2.equals("SELECT") || string2.equals("WITH")) {
            return 16;
        }
        if (string2.equals("DELETE")) {
            return 33;
        }
        if (string2.equals("INSERT")) {
            return 36;
        }
        if (string2.equals("UPDATE")) {
            return 34;
        }
        if (string2.equals("MERGE")) {
            return 40;
        }
        if (string2.equals("BEGIN")) {
            return 65;
        }
        if (string2.equals("DECLARE")) {
            return 68;
        }
        if (string2.equals("CALL")) {
            return 66;
        }
        if (string2.equals("CREATE")) {
            int n = this.index;
            String[] stringArray = new String[]{"CREATE", "OR", "REPLACE", "AND", "RESOLVE", "JAVA", "SOURCE"};
            int n2 = 1;
            int n3 = 1;
            String string3 = null;
            while (n3 > 0) {
                int n4;
                string3 = this.getToken();
                for (n4 = n2; n4 < stringArray.length; ++n4) {
                    if (!stringArray[n4].equals(string3)) continue;
                    n2 = n4 + 1;
                    n3 |= 1 << n4;
                    break;
                }
                if ((n3 & 1) > 0 && (n3 & 0x20) > 0 && (n3 & 0x40) > 0) {
                    return 136;
                }
                if (n4 != stringArray.length) continue;
                n3 = 0;
            }
            this.index = n;
            String[] stringArray2 = new String[]{"CREATE", "TABLE", "AS", "SELECT"};
            int n5 = 1;
            string3 = this.getToken();
            while (n5 > 0) {
                if (n5 == stringArray2.length) {
                    return 132;
                }
                if (string3 == null || string3.equals("")) {
                    n5 = 0;
                    continue;
                }
                if (stringArray2[n5].equals(string3)) {
                    ++n5;
                }
                string3 = this.getToken();
            }
            return 128;
        }
        String[] stringArray = new String[]{"{", "?", "=", "CALL"};
        if (string2.startsWith(stringArray[0])) {
            int n = 1;
            int n6 = 1;
            String string4 = string2;
            int n7 = stringArray[0].length();
            while (n6 > 0) {
                int n8;
                string4 = string4.length() == n7 ? this.getToken() : string4.substring(n7);
                for (n8 = n; n8 < stringArray.length; ++n8) {
                    if (string4.startsWith(stringArray[n8])) {
                        n = n8 + 1;
                        n7 = stringArray[n8].length();
                        n6 |= 1 << n8;
                        break;
                    }
                    if (n8 != 1 || string4.length() <= 1 || string4.charAt(0) != ':') continue;
                    n = n8 + 1;
                    int n9 = string4.indexOf(61);
                    n7 = n9 > 0 ? n9 : string4.length();
                    n6 |= 1 << n8;
                    break;
                }
                if ((n6 & 1) > 0 && (n6 & 8) > 0) {
                    return 66;
                }
                if (n8 != stringArray.length) continue;
                n6 = 0;
            }
        }
        return 0;
    }

    private String getToken() {
        this.state = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (this.state != 10) {
            char c = this.getNextChar();
            boolean bl = true;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                                bl = false;
                                this.ungetNextChar();
                                break block0;
                            }
                            this.state = 10;
                            bl = true;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                            }
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '*': {
                            this.state = 2;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '*': {
                            this.state = 3;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    switch (c) {
                        case '*': {
                            bl = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 0;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 2;
                    bl = false;
                    break;
                }
                case 4: {
                    switch (c) {
                        case '-': {
                            this.state = 5;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            this.state = 0;
                            this.ungetNextChar();
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\'': {
                            this.state = 0;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                }
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.substring(0, stringBuffer.length()).toUpperCase();
    }

    private void ungetNextChar() {
        --this.index;
    }

    public static boolean isDMLStmt(int n) {
        return (n & 0x20) > 0;
    }

    public static boolean isPSMStmt(int n) {
        return (n & 0x40) > 0;
    }

    public static boolean isQueryStmt(int n) {
        return (n & 0x10) > 0;
    }

    public static boolean isDDLStmt(int n) {
        return (n & 0x80) > 0;
    }

    public static boolean isCTASStmt(int n) {
        return n == 132;
    }

    public static boolean isAnonBlockStmt(int n) {
        return n == 65 || n == 68;
    }
}

