/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Column {
    private int colIdx = 0;
    private int dataType = 0;
    private int maxSize = 0;
    private String name = null;
    private int precision = 0;
    private int scale = 0;
    private int sqlType = 0;
    private boolean isNullable = false;
    private boolean mapDateToTimestamp;
    private TbTypeDescriptor descriptor;

    public Column() {
        this.mapDateToTimestamp = true;
    }

    public Column(boolean bl) {
        this.mapDateToTimestamp = bl;
    }

    public Column(Column column) {
        this.colIdx = column.colIdx;
        this.dataType = column.dataType;
        this.maxSize = column.maxSize;
        this.name = column.name;
        this.precision = column.precision;
        this.scale = column.scale;
        this.sqlType = column.sqlType;
        this.isNullable = column.isNullable;
        this.mapDateToTimestamp = column.mapDateToTimestamp;
        this.descriptor = column.descriptor;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final TbTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final int getMaxLength() {
        return this.maxSize;
    }

    public final String getName() {
        if (this.name == null || this.name.length() == 0) {
            return "column" + this.colIdx;
        }
        return this.name;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public void set(int n, TbColumnDesc tbColumnDesc) throws SQLException {
        this.colIdx = n;
        this.dataType = tbColumnDesc.dataType;
        this.maxSize = tbColumnDesc.maxSize;
        this.name = tbColumnDesc.name;
        this.precision = tbColumnDesc.precision;
        this.scale = tbColumnDesc.scale;
        this.sqlType = tbColumnDesc.dataType == 16 ? -1 : DataType.getSqlType(tbColumnDesc.dataType, tbColumnDesc.precision, this.mapDateToTimestamp);
        this.isNullable = TbCommon.getBitmapAt(0, tbColumnDesc.etcMeta);
    }

    public void set(int n, TbColumnDesc tbColumnDesc, TbTypeDescriptor tbTypeDescriptor) throws SQLException {
        this.set(n, tbColumnDesc);
        this.descriptor = tbTypeDescriptor;
    }

    public boolean getMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }
}

