/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public abstract class TbLob {
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    public static final int LOBLOC_LEN = 96;
    public static final int LOBLOC_DATA_APPENDED = 4;
    public static final int LOBLOC_IS_TEMPORARY = 4;
    private static int maxChunkSize = 32000;
    private TbConnection conn = null;
    private byte[] locator = null;
    private byte[] data = null;
    private boolean endOfStream = false;
    private boolean isEmpty = false;
    private boolean isDataAppendMode = false;
    private boolean isTempLob = false;
    private boolean freeTmpLobOnEOF = false;
    private long length = -1L;

    public TbLob(TbConnection tbConnection, byte[] byArray, boolean bl) {
        this.conn = tbConnection;
        if (byArray.length == 1) {
            this.locator = byArray;
            this.isEmpty = true;
        } else if ((byArray[5] & 4) == 4) {
            this.locator = new byte[96];
            System.arraycopy(byArray, 0, this.locator, 0, 96);
            int n = byArray.length - 96;
            this.data = new byte[n];
            System.arraycopy(byArray, 96, this.data, 0, n);
            this.isDataAppendMode = true;
        } else if ((byArray[4] & 4) == 4) {
            this.locator = byArray;
            this.freeTmpLobOnEOF = bl;
            this.isTempLob = true;
        } else {
            this.locator = byArray;
        }
    }

    public void checkInvalidActionOnEmpty() throws SQLException {
        if (this.isEmpty) {
            throw TbError.newSQLException(-90629);
        }
    }

    public void close() throws SQLException {
        this.checkInvalidActionOnEmpty();
    }

    public void free() throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (this.isTempLob) {
            this.getLobAccessor().freeTemporary(this);
        }
    }

    public TbConnection getConnection() {
        return this.conn;
    }

    public byte[] getLobData() {
        return this.data;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public boolean getIsTempLob() {
        return this.isTempLob;
    }

    public boolean freeTmpLobOnEOF() {
        return this.freeTmpLobOnEOF;
    }

    protected abstract TbLobAccessor getLobAccessor();

    private int getFixedSlobLen() {
        int n = this.locator[0] << 8;
        return n += this.locator[1];
    }

    public int getLocatorLength() {
        if (!this.isInline()) {
            return this.locator == null ? 0 : this.locator.length;
        }
        if ((this.locator[4] & 4) != 0) {
            return this.locator.length;
        }
        return this.getFixedSlobLen();
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public long length() throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (this.length < 0L) {
            this.length = this.isDataAppendMode ? (this.data == null ? 0L : (long)this.data.length) : this.getLobAccessor().length(this);
        }
        return this.length;
    }

    protected long getLengthInternal() {
        return this.length;
    }

    public void open(int n) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (n != 0 && n != 1) {
            throw TbError.newSQLException(-590769);
        }
    }

    public long position(TbLob tbLob, long l) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590766, l);
        }
        return this.getLobAccessor().position(this, tbLob, l - 1L);
    }

    public void setEndOfStream(boolean bl) {
        this.endOfStream = bl;
    }

    public void setLocator(byte[] byArray) {
        this.locator = byArray;
    }

    public static void setMaxChunkSize(int n) {
        maxChunkSize = n >= 8 * DriverConstants.MEGA ? 8 * DriverConstants.MEGA : n;
    }

    public static int getMaxChunkSize() {
        return maxChunkSize;
    }

    public void truncate(long l) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 0L) {
            throw TbError.newSQLException(-590765, l);
        }
        this.getLobAccessor().truncate(this, l);
    }

    public boolean isInline() {
        return !this.isEmpty && (this.locator[5] & 0x10) != 0;
    }

    public boolean isXML() {
        return !this.isEmpty && (this.locator[5] & 8) != 0;
    }

    public boolean isRemote() {
        return !this.isEmpty && (this.locator[5] & 2) != 0;
    }

    public int getIlobLength() {
        return this.locator.length - this.getFixedSlobLen();
    }

    public int readIlob(int n, char[] cArray, byte[] byArray, int n2, int n3, DataTypeConverter dataTypeConverter, boolean bl) throws SQLException {
        int n4;
        int n5;
        int n6 = 0;
        if (bl) {
            n6 = this.getIlobLength() - this.getFixedSlobLen();
            if (n > n6) {
                throw TbError.newSQLException(-590785, n);
            }
            n5 = 2 * this.getFixedSlobLen() + n;
            n4 = Math.min(n3, n6 - n);
        } else {
            n6 = this.getIlobLength();
            if (n > n6) {
                throw TbError.newSQLException(-590785, n);
            }
            n5 = this.getFixedSlobLen() + n;
            n4 = Math.min(n3, n6 - n);
        }
        if (n4 == 0) {
            this.endOfStream = true;
            return 0;
        }
        if (n4 < n3) {
            this.endOfStream = true;
        }
        if (this instanceof TbClob || this instanceof TbNClob) {
            return dataTypeConverter.fixedBytesToChars(this.locator, n5, n4, cArray, n2, cArray.length - n2);
        }
        System.arraycopy(this.locator, n5, byArray, n2, n4);
        return n4;
    }
}

