/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs.key.type;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.StrUtil;
import java.util.Arrays;

public class RSAKey {
    private byte[] bPublicKey;
    private byte[] bPrivateKey;
    private String encoding = "UTF-8";

    public RSAKey(String publicKey) {
        if (publicKey == null || "".equals(publicKey)) {
            throw new AgentException("RSAKey PublicKey is null or Empty");
        }
        this.bPublicKey = StrUtil.convertByteArray(publicKey, this.encoding);
    }

    public RSAKey(String publicKey, String privateKey) {
        if (publicKey != null && !"".equals(publicKey)) {
            if (privateKey == null || "".equals(privateKey)) {
                throw new AgentException("RSAKey PrivateKey is null or Empty");
            }
        } else {
            throw new AgentException("RSAKey PublicKey is null or Empty");
        }
        this.bPublicKey = StrUtil.convertByteArray(publicKey, this.encoding);
        this.bPrivateKey = StrUtil.convertByteArray(privateKey, this.encoding);
    }

    public String getPublicKey() {
        return StrUtil.convertString(this.bPublicKey, this.encoding);
    }

    public String getPrivateKey() {
        return StrUtil.convertString(this.bPrivateKey, this.encoding);
    }

    public void zeroize() {
        int repeat;
        if (this.bPublicKey != null) {
            repeat = 0;
            while (repeat < 3) {
                Arrays.fill(this.bPublicKey, (byte)0);
                ++repeat;
            }
        }
        if (this.bPrivateKey != null) {
            repeat = 0;
            while (repeat < 3) {
                Arrays.fill(this.bPrivateKey, (byte)0);
                ++repeat;
            }
        }
    }
}

