/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs.key;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.Hex;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.module.cs.key.type.ECCKey;
import com.ubintis.agt5.module.cs.key.type.RSAKey;
import com.ubintis.crypto.ECC;
import com.ubintis.crypto.PRNG;
import com.ubintis.crypto.RSA;

public class KeyGenerator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RSAKey rsaKeyGenerate() {
        RSAKey rsaKey = null;
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        int rsasize = agentBean.getRsasize();
        if (rsasize < 1024) throw new AgentException("RSAKey Size value is null");
        RSA rsa = new RSA();
        rsa.GenKey(rsasize);
        String publicKey = StrUtil.NVL(rsa.get_Pubkey());
        String privateKey = StrUtil.NVL(rsa.get_Prikey());
        if ("".equals(publicKey)) throw new AgentException("RSAKey Generate value is null");
        if ("".equals(privateKey)) throw new AgentException("RSAKey Generate value is null");
        return new RSAKey(publicKey, privateKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ECCKey eccKeyGenerate() {
        ECCKey eccKey = null;
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        int ec_type = agentBean.getEc_type();
        if (ec_type <= -1) throw new AgentException("ECC Type value is incorrect");
        ECC ecc = new ECC();
        ecc.GenKey(ec_type);
        String publicKey = StrUtil.NVL(ecc.get_Pubkey());
        String privateKey = StrUtil.NVL(ecc.get_Prikey());
        if ("".equals(publicKey)) throw new AgentException("ECCKey Generate value is null");
        if ("".equals(privateKey)) throw new AgentException("ECCKey Generate value is null");
        return new ECCKey(publicKey, privateKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] calculateKeyGenerate(String ecPrivateKey, String ecPublicKey) {
        byte[] bCalculateKey = null;
        if (ecPrivateKey == null || "".equals(ecPrivateKey) || ecPublicKey == null || "".equals(ecPublicKey)) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        int ec_type = agentBean.getEc_type();
        if (ec_type <= -1) throw new AgentException("ECC Type value is incorrect");
        ECC ecc = new ECC();
        ecc.GenKey(ec_type);
        bCalculateKey = ecc.ECDH_CalculateKey(ecPrivateKey, ecPublicKey);
        if (bCalculateKey != null && bCalculateKey.length >= 1) return bCalculateKey;
        throw new AgentException("Calculate Key Generate value is null");
    }

    public byte[] randomGenerate(int nLen) {
        byte[] bRand = null;
        if (nLen > 0) {
            PRNG prng = new PRNG();
            bRand = prng.Generate_HASHDRBG(nLen);
            if (bRand == null || bRand.length < 1) {
                throw new AgentException("Random Generate value is null");
            }
        } else {
            throw new AgentException("Parameter value is 0 under");
        }
        return bRand;
    }

    public String randomGenerateToHex(int nLen) {
        byte[] bRand;
        String renRandom = "";
        if (nLen > 0) {
            PRNG prng = new PRNG();
            bRand = prng.Generate_HASHDRBG(nLen);
            if (bRand == null || bRand.length <= 0) {
                throw new AgentException("Random Generate value is null");
            }
        } else {
            throw new AgentException("Parameter value is 0 under");
        }
        renRandom = Hex.encode(bRand);
        return renRandom;
    }
}

