/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.jni.PniccJNI;
import com.ubintis.crypto.util.Hex;

public class Digest {
    public byte[] genHashSHA512(byte[] bPlain) {
        byte[] bHash = null;
        if (bPlain != null && bPlain.length > 0) {
            PniccJNI pniccJni = new PniccJNI();
            bHash = pniccJni.GenHASH((byte)6, bPlain);
            if (bHash == null || bHash.length == 0) {
                throw new AgentException("HASH data vlaue is null");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return bHash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String genHashToHex(String plainText) {
        String rtnData = "";
        if (plainText == null) throw new AgentException("Parameter value is null");
        if ("".equals(plainText)) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        byte digest = agentBean.getDigest();
        String encoding = agentBean.getEncoding();
        byte[] bPlain = StrUtil.convertByteArray(plainText, encoding);
        if (bPlain == null) throw new AgentException("String to byte[] convert error : " + encoding);
        if (bPlain.length <= 0) throw new AgentException("String to byte[] convert error : " + encoding);
        PniccJNI pniccJni = new PniccJNI();
        byte[] bHash = pniccJni.GenHASH(digest, bPlain);
        if (bHash == null) throw new AgentException("HASH data vlaue is null");
        if (bHash.length <= 0) throw new AgentException("HASH data vlaue is null");
        return Hex.encode((byte[])bHash);
    }

    public boolean verifyHash(String plainText, String hashToHex) {
        boolean rtnFalg = false;
        if (plainText != null && !"".equals(plainText) && hashToHex != null && !"".equals(hashToHex)) {
            String temp = StrUtil.NVL(this.genHashToHex(plainText));
            if (temp.equals(hashToHex)) {
                rtnFalg = true;
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return rtnFalg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String genHmacToHex(String plainText, SecretKey secretKey) {
        String rtnData = "";
        if (plainText == null) throw new AgentException("Parameter value is null");
        if ("".equals(plainText)) throw new AgentException("Parameter value is null");
        if (secretKey == null) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        byte digest = agentBean.getDigest();
        String encoding = agentBean.getEncoding();
        byte[] bPlain = StrUtil.convertByteArray(plainText, encoding);
        if (bPlain == null) throw new AgentException("String to byte[] convert error : " + encoding);
        if (bPlain.length <= 0) throw new AgentException("String to byte[] convert error : " + encoding);
        PniccJNI pniccJni = new PniccJNI();
        byte[] bHmac = pniccJni.GenHMAC2(digest, bPlain, secretKey.getMacKey());
        if (bHmac == null) throw new AgentException("HMAC data vlaue is null");
        if (bHmac.length <= 0) throw new AgentException("HMAC data vlaue is null");
        return Hex.encode((byte[])bHmac);
    }

    public boolean verifyHmac(String plainText, String hmacToHex, SecretKey secretKey) {
        boolean rtnFalg = false;
        if (plainText != null && !"".equals(plainText) && hmacToHex != null && !"".equals(hmacToHex) && secretKey != null) {
            String temp = StrUtil.NVL(this.genHmacToHex(plainText, secretKey));
            if (temp.equals(hmacToHex)) {
                rtnFalg = true;
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return rtnFalg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String genHmacToHex(String plainText, byte[] secretKey) {
        String rtnData = "";
        if (plainText == null) throw new AgentException("Parameter value is null");
        if ("".equals(plainText)) throw new AgentException("Parameter value is null");
        if (secretKey == null) throw new AgentException("Parameter value is null");
        if (secretKey.length <= 0) throw new AgentException("Parameter value is null");
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean == null) throw new AgentException("Agent Property load error");
        byte digest = agentBean.getDigest();
        String encoding = agentBean.getEncoding();
        byte[] bPlain = StrUtil.convertByteArray(plainText, encoding);
        if (bPlain == null) throw new AgentException("String to byte[] convert error : " + encoding);
        if (bPlain.length <= 0) throw new AgentException("String to byte[] convert error : " + encoding);
        PniccJNI pniccJni = new PniccJNI();
        byte[] bHmac = pniccJni.GenHMAC2(digest, bPlain, secretKey);
        if (bHmac == null) throw new AgentException("HMAC data vlaue is null");
        if (bHmac.length <= 0) throw new AgentException("HMAC data vlaue is null");
        return Hex.encode((byte[])bHmac);
    }

    public boolean verifyHmac(String plainText, String hmacToHex, byte[] secretKey) {
        boolean rtnFalg = false;
        if (plainText != null && !"".equals(plainText) && hmacToHex != null && !"".equals(hmacToHex) && secretKey != null && secretKey.length > 0) {
            String temp = StrUtil.NVL(this.genHmacToHex(plainText, secretKey));
            if (temp.equals(hmacToHex)) {
                rtnFalg = true;
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return rtnFalg;
    }
}

