/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs;

import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.crypto.jni.PniccJNI;

public class Crypto {
    private static final PniLogger LOGGER = PniLogger.getLogger();
    private int errRet = 0;

    public boolean cryptoInitialize() {
        boolean retFlag = false;
        try {
            PniccJNI pniccJni = new PniccJNI();
            if (pniccJni.GetModuleState() != 5) {
                int nRet = pniccJni.InitializeAPI();
                if (nRet == 1) {
                    retFlag = true;
                } else {
                    this.errRet = nRet;
                }
            } else {
                retFlag = true;
            }
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return retFlag;
    }

    public boolean cryptoFinalize() {
        boolean retFlag = false;
        try {
            PniccJNI pniccJni = new PniccJNI();
            int nRet = pniccJni.FinalizeAPI();
            if (nRet == 1) {
                retFlag = true;
            } else {
                this.errRet = nRet;
            }
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return retFlag;
    }

    public boolean cryptoSelfTest() {
        boolean retFlag = false;
        try {
            PniccJNI pniccJni = new PniccJNI();
            int nRet = pniccJni.SELFTEST_DoPowerUpSelfTest();
            if (nRet == 1) {
                retFlag = true;
            } else {
                this.errRet = nRet;
            }
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return retFlag;
    }

    public String getCryptoVersion() {
        String version = "";
        try {
            PniccJNI pniccJni = new PniccJNI();
            version = pniccJni.GetCMVPVersion();
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return version;
    }

    public String getJNIVersion() {
        String version = "";
        try {
            PniccJNI pniccJni = new PniccJNI();
            version = pniccJni.GetVersion();
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return version;
    }

    public int getCryptoModuleState() {
        int state = -1000;
        try {
            PniccJNI pniccJni = new PniccJNI();
            state = pniccJni.GetModuleState();
        }
        catch (Error e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return state;
    }

    public int getErrRet() {
        return this.errRet;
    }
}

