/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.jni.PniccJNI;

public class CipherBlockFix {
    public String encryptBySeed(byte[] bPlain, SecretKey secretKey) {
        String cipherText = "";
        if (bPlain != null && secretKey != null) {
            PniccJNI pniccJni = new PniccJNI();
            cipherText = pniccJni.BCipher_Encrypt((byte)4, bPlain, secretKey.getKey(), secretKey.getIv());
            if (cipherText == null || "".equals(cipherText)) {
                throw new AgentException("Encrypt Data value is null : Algorithm[SEED]");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return cipherText;
    }

    public byte[] decryptBySeed(String cipherText, SecretKey secretKey) {
        byte[] bPlain = null;
        if (cipherText != null && !"".equals(cipherText) && secretKey != null) {
            PniccJNI pniccJni = new PniccJNI();
            bPlain = pniccJni.BCipher_Decrypt((byte)4, cipherText, secretKey.getKey(), secretKey.getIv());
            if (bPlain == null || bPlain.length < 1) {
                throw new AgentException("Decrypt Data value is null : Algorithm[SEED]");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return bPlain;
    }

    public String encryptByAria(String plainText, String encoding, SecretKey secretKey) {
        String cipherText = "";
        if (plainText != null && !"".equals(plainText) && secretKey != null) {
            PniccJNI pniccJni = new PniccJNI();
            byte[] bPlain = StrUtil.convertByteArray(plainText, encoding);
            cipherText = pniccJni.BCipher_Encrypt((byte)3, bPlain, secretKey.getKey(), secretKey.getIv());
            if (cipherText == null || "".equals(cipherText)) {
                throw new AgentException("Encrypt Data value is null : Algorithm[ARIA256]");
            }
        } else {
            throw new AgentException("Parameter value is null");
        }
        return cipherText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String decryptByAria(String cipherText, String encoding, SecretKey secretKey) {
        String plainText = "";
        if (cipherText == null || "".equals(cipherText) || secretKey == null) throw new AgentException("Parameter value is null");
        PniccJNI pniccJni = new PniccJNI();
        byte[] bPlain = pniccJni.BCipher_Decrypt((byte)3, cipherText, secretKey.getKey(), secretKey.getIv());
        if (bPlain == null || bPlain.length <= 0) throw new AgentException("Decrypt Data value is null : Algorithm[ARIA256]");
        plainText = StrUtil.convertString(bPlain, encoding);
        if (plainText != null && !"".equals(plainText)) return plainText;
        throw new AgentException("String to byte[] convert error : " + encoding);
    }
}

