/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework.cert;

import com.ubintis.agt5.common.exception.AgentException;
import com.ubintis.agt5.common.util.Base64;
import com.ubintis.agt5.common.util.Hex;
import com.ubintis.agt5.common.util.JsonUtil;
import com.ubintis.agt5.common.util.NetworkUtil;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.module.cs.CipherBlockFix;
import com.ubintis.agt5.module.cs.key.KeyStorage;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.PRNG;
import com.ubintis.crypto.jni.PniccJNI;
import java.util.HashMap;
import java.util.List;

public class CertificateLoad {
    private static final PniLogger LOGGER = PniLogger.getLogger();
    private boolean flag = false;
    private String errorMsg = "";

    private CertificateLoad() {
        this.init();
    }

    public static CertificateLoad getInstance() {
        return Singleton.instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        this.flag = false;
        try {
            AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
            if (agentBean == null) throw new AgentException("AgentBean value is null");
            String agt_id = StrUtil.NVL(agentBean.getAgent_id());
            String secky = StrUtil.NVL(agentBean.getAgent_secky());
            String pni_key = StrUtil.NVL(agentBean.getAgent_pni_key());
            String pni_type = StrUtil.NVL(agentBean.getAgent_pni_type());
            if ("".equals(secky) || "".equals(pni_key)) throw new AgentException("secky, pni_key value is null or empty");
            if ("7".equals(pni_type)) {
                this.loadCert(agentBean);
                return;
            }
            HashMap<String, Object> keyMap = this.getKeyMap(pni_key, agt_id);
            String key = StrUtil.NVL(keyMap.get("key"));
            this.checkLicense(pni_type, keyMap, agentBean);
            this.checkVersion(agentBean);
            this.setKey(key, secky);
            this.flag = true;
            return;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            this.errorMsg = e.getMessage();
        }
    }

    public boolean getStatus() {
        return this.flag;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void destroy() throws Exception {
    }

    private void loadCert(AgentBean agentBean) {
        String secky = StrUtil.NVL(agentBean.getAgent_secky());
        String pni_key = StrUtil.NVL(agentBean.getAgent_pni_key());
        try {
            String password = StrUtil.NVL(System.getProperty("pni.password"));
            if (!"".equals(password)) {
                password = new String(Base64.decode(password));
            }
            HashMap<String, Object> keyMap = this.getKeyMap(pni_key, password);
            String key = StrUtil.NVL(keyMap.get("key"));
            this.checkLicense(null, keyMap, agentBean);
            this.checkVersion(agentBean);
            this.setKey(key, secky);
            System.clearProperty("pni.password");
            this.flag = true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private HashMap<String, Object> getKeyMap(String pni_key, String password) {
        if (pni_key == null || "".equals(pni_key) || password == null || "".equals(password)) {
            throw new AgentException("pni_key, password value is null");
        }
        String[] arrKeyData = pni_key.split("\\.");
        if (arrKeyData.length != 2) {
            throw new AgentException("key file data is split incorrect : size[" + arrKeyData.length + "]");
        }
        SecretKey passwordKey = this.passwordKeyGenerate(password, arrKeyData[0]);
        CipherBlockFix cipherBlockFix = new CipherBlockFix();
        String decData = cipherBlockFix.decryptByAria(arrKeyData[1], "UTF-8", passwordKey);
        passwordKey.zeroize();
        return JsonUtil.parse(decData);
    }

    private SecretKey passwordKeyGenerate(String key, String salt) {
        if (key == null || "".equals(key) || salt == null || "".equals(salt)) {
            throw new AgentException("key, salt value is null");
        }
        if (key.length() < 9) {
            throw new AgentException("key is size incorrect : size[" + key.length() + "]");
        }
        if (salt.length() < 32) {
            throw new AgentException("salt is size incorrect : size[" + salt.length() + "]");
        }
        byte[] bSalt = Hex.decode(salt);
        PniccJNI pniccJni = new PniccJNI();
        byte[] bArrayKey = pniccJni.PBKDF2_HMAC((byte)4, key, bSalt, 1000L, 80);
        byte[] bArraySalt = new PRNG().Generate_HASHDRBG(32);
        if (bArrayKey == null || bArraySalt == null) {
            throw new AgentException("PBKDF2_HMAC value is null");
        }
        return new SecretKey(bArrayKey, bArraySalt);
    }

    private void checkLicense(String certPniType, HashMap<String, Object> keyMap, AgentBean agentBean) {
        String server_id = StrUtil.NVL(keyMap.get("server_id"));
        String agent_id = StrUtil.NVL(keyMap.get("agent_id"));
        if ("".equals(server_id) || !server_id.equals(agentBean.getServer_id())) {
            throw new AgentException("Server Id Check Fail");
        }
        if ("".equals(agent_id) || !agent_id.equals(agentBean.getAgent_id())) {
            throw new AgentException("Agent Id Check Fail");
        }
        String before_date = StrUtil.NVL(keyMap.get("before_date"));
        String after_date = StrUtil.NVL(keyMap.get("after_date"));
        if (!"".equals(before_date) || !"".equals(after_date)) {
            long long_date = System.currentTimeMillis() / 1000L;
            long long_before_date = Long.parseLong(before_date);
            long long_after_date = Long.parseLong(after_date);
            if (long_date < long_before_date) {
                throw new AgentException("Agent License Check Fail : NotYetValid");
            }
            if (long_date > long_after_date) {
                throw new AgentException("Agent License Check Fail : Expired");
            }
        }
        boolean flag = false;
        String ip = StrUtil.NVL(keyMap.get("ip"));
        if (certPniType != null && "5".equals(certPniType)) {
            if (ip.equals(agent_id)) {
                flag = true;
            }
        } else {
            String[] licence_ip_arr = ip.split(",");
            List<String> serverIpList = NetworkUtil.getServerIpList();
            for (String serverIp : serverIpList) {
                String[] stringArray = licence_ip_arr;
                int n = licence_ip_arr.length;
                int n2 = 0;
                while (n2 < n) {
                    String licence_ip = stringArray[n2];
                    if (licence_ip.equals(serverIp)) {
                        flag = true;
                        break;
                    }
                    ++n2;
                }
                if (flag) break;
            }
        }
        if (!flag) {
            throw new AgentException("Agent License Check Fail");
        }
    }

    private void checkVersion(AgentBean agentBean) {
        String agent_pni_version = agentBean.getAgent_pni_version();
        if (!"token".equals(agent_pni_version)) {
            throw new AgentException("Agent pni version Check Fail[TK1]");
        }
    }

    private void setKey(String key, String secky) {
        byte[] bArrayKey = Hex.decode(key);
        byte[] bArraySalt = new PRNG().Generate_HASHDRBG(32);
        SecretKey masterKey = new SecretKey(bArrayKey, bArraySalt);
        KeyStorage keyStorage = KeyStorage.getInstance();
        keyStorage.addKey("com.ubintis.sso.agt.cs.key.MasterKey", masterKey);
        CipherBlockFix cipherBlockFix = new CipherBlockFix();
        String decSecky = cipherBlockFix.decryptByAria(secky, "UTF-8", masterKey);
        keyStorage.addKey("com.ubintis.sso.agt.cs.key.SecretKey", Hex.decode(decSecky));
    }

    /* synthetic */ CertificateLoad(CertificateLoad certificateLoad) {
        this();
    }

    private static class Singleton {
        private static final CertificateLoad instance = new CertificateLoad(null);

        private Singleton() {
        }
    }
}

