/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.framework;

import com.ubintis.agt5.api.ApiLogService;
import com.ubintis.agt5.common.util.NetworkUtil;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.cert.CertificateLoad;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.config.IntgrtyConfig;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.framework.log.PniLoggerUtil;
import com.ubintis.agt5.module.cs.Crypto;
import com.ubintis.agt5.module.cs.key.KeyStorage;
import com.ubintis.agt5.module.key.KeyExchange;
import com.ubintis.agt5.module.pt.SelfTestAgent;
import java.util.HashMap;

public class SSOInitialize {
    public static SSOInitialize getInstance() {
        return Singleton.instance;
    }

    private SSOInitialize() {
        this.init();
    }

    private String init() {
        StringBuffer sbLog = new StringBuffer();
        sbLog.append("\n");
        sbLog.append("################################################################################\n");
        sbLog.append("################################################################################\n");
        sbLog.append("### \n");
        sbLog.append("### Pass-Ni SSO Agent Initialization\n");
        sbLog.append("### Copyright (c) UbiNtisLab Co., Ltd. All rights reserved.\n");
        sbLog.append("### \n");
        sbLog.append("################################################################################\n");
        sbLog.append("### \n");
        String errorMsg = "";
        String agent_id = "";
        String product = "Pass-Ni SSO v5.0";
        String application = "Pass-Ni SSO Agent v5.0.002";
        try {
            AgentConfig agentConfig = AgentConfig.getInstance();
            AgentBean agentBean = agentConfig.getAgentBean();
            if (agentConfig.getStatus() && agentBean != null) {
                agent_id = StrUtil.NVL(agentBean.getAgent_id());
                product = StrUtil.NVL(agentBean.getProduct(), product);
                application = StrUtil.NVL(agentBean.getApplication(), application);
                sbLog.append("### AGENT ID : " + agent_id + " [" + NetworkUtil.getServerIp() + "]\n");
                sbLog.append("### \n");
                sbLog.append("### Agent Config Properties Load : Success\n");
            } else {
                errorMsg = "Agent Config Properties Load : Fail";
            }
            if ("".equals(errorMsg)) {
                IntgrtyConfig intgrtyConfig = IntgrtyConfig.getInstance();
                if (intgrtyConfig.getStatus()) {
                    sbLog.append("### Intgrty Config Properties Load : Success\n");
                } else {
                    errorMsg = "Intgrty Config Properties Load : Fail";
                }
            }
            if ("".equals(errorMsg)) {
                Crypto crypto = new Crypto();
                String cryptoVersion = StrUtil.NVL(crypto.getCryptoVersion(), "Pass-Ni Crypto");
                if (crypto.cryptoInitialize()) {
                    sbLog.append("### " + cryptoVersion + " Initialize : Success\n");
                } else {
                    errorMsg = String.valueOf(cryptoVersion) + " Initialize : Fail [" + crypto.getErrRet() + "]";
                }
            }
            if ("".equals(errorMsg)) {
                CertificateLoad certificateLoad = CertificateLoad.getInstance();
                if (certificateLoad.getStatus()) {
                    sbLog.append("### Certificate Load : Success\n");
                } else {
                    errorMsg = "Certificate Load : Fail [" + certificateLoad.getErrorMsg() + "]";
                }
            }
            if ("".equals(errorMsg)) {
                KeyExchange keyExchange = new KeyExchange();
                keyExchange.execute();
                if (keyExchange.getStatus()) {
                    sbLog.append("### Server - Agent Key Exchange : Success\n");
                } else {
                    sbLog.append("### Server - Agent Key Exchange : Fail [" + keyExchange.getErrorCode() + "]\n");
                }
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            PniLogger.getLogger().error(PniLoggerUtil.getPrintStackTrace(e));
        }
        if (!"".equals(errorMsg)) {
            sbLog.append("### " + errorMsg + "\n");
        }
        ApiLogService apiLogService = new ApiLogService();
        if ("".equals(errorMsg)) {
            sbLog.append("### \n");
            SelfTestAgent selfTestAgent = new SelfTestAgent();
            HashMap<String, Boolean> testMap = selfTestAgent.execute();
            if (testMap.get("moduleTest").booleanValue()) {
                sbLog.append("### Agent Module Test : Success\n");
            } else {
                sbLog.append("### Agent Module Test : Fail\n");
            }
            if (testMap.get("cryptoTest").booleanValue()) {
                sbLog.append("### Pass-Ni Crypto Self Test : Success\n");
            } else {
                sbLog.append("### Pass-Ni Crypto Self Test : Fail\n");
            }
            if (testMap.get("intgrtyTest").booleanValue()) {
                sbLog.append("### Agent Integrity Test : Success\n");
            } else {
                sbLog.append("### Agent Integrity Test : Fail\n");
            }
            apiLogService.startLog(true, testMap);
            sbLog.append("### \n");
            sbLog.append("################################################################################\n");
            sbLog.append("### \n");
            sbLog.append("### Product : " + product + "\n");
            sbLog.append("### Application : " + application + "\n");
            sbLog.append("### \n");
            sbLog.append("### Initialization Success\n");
        } else {
            apiLogService.startLog(false, null);
            sbLog.append("### \n");
            sbLog.append("################################################################################\n");
            sbLog.append("### \n");
            sbLog.append("### Product : " + product + "\n");
            sbLog.append("### Application : " + application + "\n");
            sbLog.append("### \n");
            sbLog.append("### Initialization Fail\n");
        }
        sbLog.append("### \n");
        sbLog.append("################################################################################\n");
        sbLog.append("################################################################################\n");
        sbLog.append("\n");
        PniLogger.getLogger().info(sbLog.toString());
        return errorMsg;
    }

    public void destory() {
        ApiLogService apiLogService = new ApiLogService();
        apiLogService.stopLog();
        StringBuffer sbLog = new StringBuffer();
        sbLog.append("\n");
        sbLog.append("################################################################################\n");
        sbLog.append("################################################################################\n");
        sbLog.append("### \n");
        sbLog.append("### Pass-Ni SSO Agent Destroyed\n");
        sbLog.append("### Copyright (c) UbiNtisLab Co., Ltd. All rights reserved.\n");
        sbLog.append("### \n");
        sbLog.append("################################################################################\n");
        sbLog.append("### \n");
        Crypto crypto = new Crypto();
        if (crypto.cryptoFinalize()) {
            sbLog.append("### Pass-Ni Crypto Finalize : Success\n");
        } else {
            sbLog.append("### Pass-Ni Crypto Finalize : Fail\n");
        }
        try {
            KeyStorage.getInstance().destroy();
            sbLog.append("### Key Storage Destroyed : Success\n");
        }
        catch (Exception e) {
            sbLog.append("### Key Storage Destroyed : fail\n");
        }
        try {
            AgentConfig.getInstance().destroy();
            sbLog.append("### Agent Config Properties Unload : Success\n");
        }
        catch (Exception e) {
            sbLog.append("### Agent Config Properties Unload : fail\n");
        }
        try {
            IntgrtyConfig.getInstance().destroy();
            sbLog.append("### Intgrty Config Properties Unload : Success\n");
        }
        catch (Exception e) {
            sbLog.append("### Intgrty Config Properties Unload : fail\n");
        }
        sbLog.append("### \n");
        sbLog.append("################################################################################\n");
        sbLog.append("################################################################################\n");
        sbLog.append("\n");
        PniLogger.getLogger().info(sbLog.toString());
    }

    /* synthetic */ SSOInitialize(SSOInitialize sSOInitialize) {
        this();
    }

    private static class Singleton {
        private static final SSOInitialize instance = new SSOInitialize(null);

        private Singleton() {
        }
    }
}

