/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetWarning;

public class TbJdbcRowSet
extends TbRowSet
implements JdbcRowSet,
Joinable {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private static boolean isInitializedDriver;

    public TbJdbcRowSet() {
        this(null);
    }

    public TbJdbcRowSet(Connection connection) {
        this.conn = connection;
        isInitializedDriver = false;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl = this.rs.absolute(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.rs.afterLast();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.rs.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.pstmt.clearParameters();
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
            this.conn.close();
        }
        this.notifyRowSetChanged();
        this.isClosed = true;
    }

    @Override
    public void commit() throws SQLException {
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.commit();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    @Override
    public void execute() throws SQLException {
        this.conn = this.getConnection(this);
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn.setTypeMap(this.getTypeMap());
        if (this.pstmt == null) {
            this.pstmt = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.pstmt.setFetchSize(this.getFetchSize());
        this.pstmt.setFetchDirection(this.getFetchDirection());
        this.pstmt.setMaxFieldSize(this.getMaxFieldSize());
        this.pstmt.setMaxRows(this.getMaxRows());
        this.pstmt.setQueryTimeout(this.getQueryTimeout());
        this.pstmt.setEscapeProcessing(this.getEscapeProcessing());
        this.setParams(this.getParams(), this.pstmt);
        this.rs = this.pstmt.executeQuery();
        this.notifyRowSetChanged();
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Object[])) {
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            if (objectArray2.length == 2) {
                this.setParams2Arg(i, objectArray2, preparedStatement);
                continue;
            }
            if (objectArray2.length != 3) continue;
            this.setParams3Arg(i, objectArray2, preparedStatement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams2Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        if (objectArray[0] == null) {
            preparedStatement.setNull(n + 1, (Integer)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof RowId) {
            preparedStatement.setRowId(n + 1, (RowId)objectArray[0]);
            return;
        } else if (objectArray[0] instanceof NClob) {
            preparedStatement.setNClob(n + 1, (NClob)objectArray[0]);
            return;
        } else if (objectArray[0] instanceof Date) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setDate(n + 1, (Date)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Time) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTime(n + 1, (Time)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Timestamp) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTimestamp(n + 1, (Timestamp)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Reader) {
            preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
            return;
        } else {
            if (!(objectArray[1] instanceof Integer)) return;
            if ((Integer)objectArray[1] == 0) {
                preparedStatement.setNString(n + 1, (String)objectArray[0]);
                return;
            } else {
                preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1]);
            }
        }
    }

    private void setParams3Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        block23: {
            block25: {
                block24: {
                    block22: {
                        if (objectArray[0] != null) break block22;
                        preparedStatement.setNull(n + 1, (Integer)objectArray[1], (String)objectArray[2]);
                        break block23;
                    }
                    if (!(objectArray[0] instanceof Reader)) break block24;
                    switch ((Integer)objectArray[2]) {
                        case 6: {
                            if (objectArray[1] instanceof Integer) {
                                preparedStatement.setClob(n + 1, (Reader)objectArray[0], ((Integer)objectArray[1]).intValue());
                            } else {
                                preparedStatement.setClob(n + 1, (Reader)objectArray[0], (Long)objectArray[1]);
                            }
                            break block23;
                        }
                        case 3: {
                            if (objectArray[1] instanceof Integer) {
                                preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
                            } else {
                                preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Long)objectArray[1]);
                            }
                            break block23;
                        }
                        case 4: {
                            if (objectArray[1] instanceof Integer) {
                                preparedStatement.setNCharacterStream(n + 1, (Reader)objectArray[0], ((Integer)objectArray[1]).intValue());
                            } else {
                                preparedStatement.setNCharacterStream(n + 1, (Reader)objectArray[0], (Long)objectArray[1]);
                            }
                            break block23;
                        }
                        default: {
                            throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                        }
                    }
                }
                if (!(objectArray[0] instanceof InputStream)) break block25;
                switch ((Integer)objectArray[2]) {
                    case 2: {
                        if (objectArray[1] instanceof Integer) {
                            preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        } else {
                            preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray[0], (Long)objectArray[1]);
                        }
                        break block23;
                    }
                    case 1: {
                        preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        break block23;
                    }
                    case 5: {
                        if (objectArray[1] instanceof Integer) {
                            preparedStatement.setBlob(n + 1, (InputStream)objectArray[0], ((Integer)objectArray[1]).intValue());
                        } else {
                            preparedStatement.setBlob(n + 1, (InputStream)objectArray[0], (Long)objectArray[1]);
                        }
                        break block23;
                    }
                    default: {
                        throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                    }
                }
            }
            if (objectArray[1] instanceof Integer && objectArray[2] instanceof Integer) {
                preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1], (int)((Integer)objectArray[2]));
            } else {
                throw TbError.newSQLException(-90846, objectArray[0].toString());
            }
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    @Override
    public boolean first() throws SQLException {
        boolean bl = this.rs.first();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return this.rs.getArray(n);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.rs.getArray(string);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(string);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.conn != null) {
            return this.conn.getAutoCommit();
        }
        throw TbError.newSQLException(-90827);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rs.getBigDecimal(n, n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(string);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rs.getBigDecimal(string, n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(string);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(n);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.rs.getBlob(string);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(n);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(string);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return this.rs.getByte(n);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.rs.getByte(string);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(string);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        return this.rs.getClob(n);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.rs.getClob(string);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return super.getConcurrency();
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        String string = rowSet.getUrl();
        String string2 = rowSet.getUsername();
        String string3 = rowSet.getPassword();
        String string4 = rowSet.getDataSourceName();
        if (this.conn != null && !this.conn.isClosed()) {
            return this.conn;
        }
        if (string4 != null && !string4.equals("")) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(string4);
                if (string2 == null || string3 == null) {
                    return dataSource.getConnection();
                }
                return dataSource.getConnection(string2, string3);
            }
            catch (NamingException namingException) {
                throw TbError.newSQLException(-90828);
            }
        }
        if (string != null && !string.equals("")) {
            if (!isInitializedDriver) {
                DriverManager.registerDriver(new TbDriver());
                isInitializedDriver = true;
            }
            if (string2.equals("") || string3.equals("")) {
                throw TbError.newSQLException(-90854);
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        throw TbError.newSQLException(-90852);
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(n, calendar);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.rs.getDate(string);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(string, calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return this.rs.getDouble(n);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.rs.getDouble(string);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return this.rs.getFloat(n);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.rs.getFloat(string);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rs.getHoldability();
    }

    @Override
    public int getInt(int n) throws SQLException {
        return this.rs.getInt(n);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.rs.getInt(string);
    }

    @Override
    public long getLong(int n) throws SQLException {
        return this.rs.getLong(n);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.rs.getLong(string);
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        return super.getMatchColumnIndexes();
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        return super.getMatchColumnNames();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbRowSetMetaData(this.rs.getMetaData());
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.rs.getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.rs.getNCharacterStream(string);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return this.rs.getNClob(n);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.rs.getNClob(string);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.rs.getNString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.rs.getNString(string);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.rs.getObject(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(n, map);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.rs.getObject(string);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(string, map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.rs.getRef(string);
    }

    @Override
    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        return this.rs.getRowId(n);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.rs.getRowId(string);
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public short getShort(int n) throws SQLException {
        return this.rs.getShort(n);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.rs.getShort(string);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return this.rs.getSQLXML(n);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.rs.getSQLXML(string);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.rs.getString(string);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(n, calendar);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.rs.getTime(string);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(string, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(string);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(string, calendar);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.rs.getUnicodeStream(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.rs.getUnicodeStream(string);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return this.rs.getURL(n);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.rs.getURL(string);
    }

    @Override
    public void insertRow() throws SQLException {
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        boolean bl = this.rs.last();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl = this.rs.next();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean bl = this.rs.previous();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        boolean bl = this.rs.relative(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback(savepoint);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.setAutoCommit(bl);
    }

    @Override
    public void setMatchColumn(int n) throws SQLException {
        super.setMatchColumn(n);
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        super.setMatchColumn(nArray);
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        super.setMatchColumn(string);
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        super.setMatchColumn(stringArray);
    }

    @Override
    public void setShowDeleted(boolean bl) throws SQLException {
        if (bl) {
            throw TbError.newSQLException(-90856);
        }
        super.setShowDeleted(bl);
    }

    @Override
    public void unsetMatchColumn(int n) throws SQLException {
        super.unsetMatchColumn(n);
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        super.unsetMatchColumn(nArray);
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        super.unsetMatchColumn(string);
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        super.unsetMatchColumn(stringArray);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.rs.updateArray(n, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.rs.updateArray(string, array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, l);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.rs.updateBlob(n, blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(n, inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.rs.updateBlob(string, blob);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(string, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(string, inputStream, l);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.rs.updateBoolean(n, bl);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.rs.updateBoolean(string, bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.rs.updateByte(n, by);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.rs.updateByte(string, by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.rs.updateBytes(n, byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.rs.updateBytes(string, byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(n, reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.rs.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(string, reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.rs.updateCharacterStream(string, reader, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.rs.updateClob(n, clob);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.rs.updateClob(n, reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateClob(n, reader, l);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.rs.updateClob(string, clob);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.rs.updateClob(string, reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateClob(string, reader, l);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.rs.updateDate(n, date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.rs.updateDate(string, date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.rs.updateDouble(n, d);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.rs.updateDouble(string, d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.rs.updateFloat(n, f);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.rs.updateFloat(string, f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.rs.updateInt(n, n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.rs.updateInt(string, n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.rs.updateLong(n, l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.rs.updateLong(string, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(string, reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.rs.updateNClob(n, nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.rs.updateNClob(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.rs.updateNClob(string, nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.rs.updateNClob(string, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(string, reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.rs.updateNString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.rs.updateNString(string, string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.rs.updateNull(n);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.rs.updateNull(string);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.rs.updateObject(n, object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.rs.updateObject(n, object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.rs.updateObject(string, object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.rs.updateObject(string, object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.rs.updateRef(n, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.rs.updateRef(string, ref);
    }

    @Override
    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.rs.updateRowId(n, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.rs.updateRowId(string, rowId);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.rs.updateShort(n, s);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.rs.updateShort(string, s);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(string, sQLXML);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.rs.updateString(n, string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.rs.updateString(string, string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.rs.updateTime(n, time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.rs.updateTime(string, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(string, timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        String string;
        switch (string = clazz.getName()) {
            case "java.sql.Array": {
                return (T)this.getObject(n);
            }
            case "java.io.InputStream": {
                return (T)this.getBinaryStream(n);
            }
            case "java.math.BigDecimal": {
                return (T)this.getBigDecimal(n);
            }
            case "java.sql.Blob": {
                return (T)this.getBlob(n);
            }
            case "java.lang.Byte": {
                return (T)new Byte(this.getByte(n));
            }
            case "byte[]": {
                return (T)this.getBytes(n);
            }
            case "java.io.Reader": {
                return (T)this.getCharacterStream(n);
            }
            case "java.sql.Clob": {
                return (T)this.getClob(n);
            }
            case "java.sql.Date": {
                return (T)this.getDate(n);
            }
            case "java.lang.Double": {
                return (T)new Double(this.getDouble(n));
            }
            case "java.lang.Float": {
                return (T)new Float(this.getFloat(n));
            }
            case "java.lang.Integer": {
                return (T)new Integer(this.getInt(n));
            }
            case "java.lang.Long": {
                return (T)new Long(this.getLong(n));
            }
            case "java.sql.NClob": {
                return (T)this.getNClob(n);
            }
            case "java.sql.Ref": {
                return (T)this.getRef(n);
            }
            case "java.sql.RowId": {
                return (T)this.getRowId(n);
            }
            case "java.lang.Short": {
                return (T)new Short(this.getShort(n));
            }
            case "java.sql.SQLXML": {
                return (T)this.getSQLXML(n);
            }
            case "java.lang.String": {
                return (T)this.getString(n);
            }
            case "java.sql.Time": {
                return (T)this.getTime(n);
            }
            case "java.sql.Timestamp": {
                return (T)this.getTimestamp(n);
            }
            case "java.time.LocalDate": {
                return (T)this.getDate(n).toLocalDate();
            }
            case "java.time.LocalTime": {
                return (T)this.getTime(n).toLocalTime();
            }
            case "java.time.LocalDateTime": {
                return (T)this.getTimestamp(n).toLocalDateTime();
            }
            case "java.time.OffsetTime": {
                return (T)OffsetTime.of(this.getTime(n).toLocalTime(), ZoneOffset.UTC);
            }
            case "java.time.OffsetDateTime": {
                return (T)OffsetDateTime.of(this.getTimestamp(n).toLocalDateTime(), ZoneOffset.UTC);
            }
            case "java.net.URL": {
                return (T)this.getURL(n);
            }
        }
        return (T)this.getObject(n);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }
}

