/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.util.Calendar;
import java.util.TimeZone;

public class TbTimestamp {
    static final short OFFSET_CENTURY = 0;
    static final short OFFSET_YEAR = 1;
    static final short OFFSET_MONTH = 2;
    static final short OFFSET_DAY_OF_MONTH = 3;
    static final short OFFSET_HOUR_OF_DAY = 4;
    static final short OFFSET_MINUTE = 5;
    static final short OFFSET_SECOND = 6;
    static final short OFFSET_DATE_END = 7;
    public static final char DELIMITER_DATE = '-';
    public static final char DELIMITER_TIME = ':';
    public static final char DELIMITER_MILLIS = '.';
    public static final char DELIMITER_BLANK = ' ';
    private byte[] bytes;

    public TbTimestamp(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data should not be null");
        }
        if (byArray.length != 12) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.bytes = byArray;
    }

    public TbTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.bytes = new byte[12];
        if (n7 > 999999999 || n7 < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.bytes[0] = (byte)(n / 100 + 100);
        this.bytes[1] = (byte)(n % 100 + 100);
        this.bytes[2] = (byte)n2;
        this.bytes[3] = (byte)n3;
        this.bytes[4] = (byte)n4;
        this.bytes[5] = (byte)n5;
        this.bytes[6] = (byte)n6;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(n7, this.bytes, 8, 4);
    }

    public TbTimestamp(long l) {
        this.bytes = new byte[12];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        if (n == 0) {
            n2 *= -1;
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = (int)(l % 1000L * 1000000L);
        if (n8 < 0) {
            n8 = 1000000000 + n8;
        }
        this.bytes[0] = (byte)(n2 / 100 + 100);
        this.bytes[1] = (byte)(n2 % 100 + 100);
        this.bytes[2] = (byte)n3;
        this.bytes[3] = (byte)n4;
        this.bytes[4] = (byte)n5;
        this.bytes[5] = (byte)n6;
        this.bytes[6] = (byte)n7;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(n8, this.bytes, 8, 4);
    }

    public TbTimestamp(long l, TimeZone timeZone) {
        this.bytes = new byte[12];
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(l);
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        if (n == 0) {
            n2 = n2 * -1 + 1;
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = (int)(l % 1000L * 1000000L);
        if (n8 < 0) {
            n8 = 1000000000 + n8;
        }
        this.bytes[0] = (byte)(n2 / 100 + 100);
        this.bytes[1] = (byte)(n2 % 100 + 100);
        this.bytes[2] = (byte)n3;
        this.bytes[3] = (byte)n4;
        this.bytes[4] = (byte)n5;
        this.bytes[5] = (byte)n6;
        this.bytes[6] = (byte)n7;
        this.bytes[7] = 0;
        TbCommon.int2Bytes(n8, this.bytes, 8, 4);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public int getYear() {
        int n = 0xFF & this.bytes[0];
        int n2 = 0xFF & this.bytes[1];
        int n3 = (n - 100) * 100 + (n2 - 100);
        return n3;
    }

    public int getDayOfMonth() {
        int n = 0xFF & this.bytes[3];
        return n;
    }

    public int getHourOfDay() {
        int n = 0xFF & this.bytes[4];
        return n;
    }

    public int getMinutes() {
        int n = 0xFF & this.bytes[5];
        return n;
    }

    public int getSeconds() {
        int n = 0xFF & this.bytes[6];
        return n;
    }

    public int getMonth() {
        int n = 0xFF & this.bytes[2];
        return n;
    }

    public int getNanos() {
        int n = TbCommon.bytes2Int(this.bytes, 8, 4);
        return n;
    }

    public String toString() {
        int n;
        char[] cArray = new char[30];
        int n2 = 0;
        int n3 = this.getYear();
        if (n3 < 10000 && n3 >= 0) {
            n2 += TbTimestamp.writeFormattedInt(cArray, n2, 4, this.getYear());
        } else {
            int n4;
            String string = Integer.toString(n3);
            for (n4 = 0; n4 < string.length(); ++n4) {
                cArray[n2 + n4] = string.charAt(n4);
            }
            n2 += n4;
        }
        cArray[n2++] = 45;
        n2 += TbTimestamp.writeFormattedInt(cArray, n2, 2, this.getMonth());
        cArray[n2++] = 45;
        n2 += TbTimestamp.writeFormattedInt(cArray, n2, 2, this.getDayOfMonth());
        cArray[n2++] = 32;
        n2 += TbTimestamp.writeFormattedInt(cArray, n2, 2, this.getHourOfDay());
        cArray[n2++] = 58;
        n2 += TbTimestamp.writeFormattedInt(cArray, n2, 2, this.getMinutes());
        cArray[n2++] = 58;
        n2 += TbTimestamp.writeFormattedInt(cArray, n2, 2, this.getSeconds());
        int n5 = this.getNanos();
        if (n5 < 0) {
            n5 = 0;
        }
        cArray[n2++] = 46;
        String string = Integer.toString(n5);
        int n6 = string.length();
        for (n = 0; n < 9; ++n) {
            cArray[n2 + n] = 9 - n > n6 ? 48 : string.charAt(n - 9 + n6);
        }
        for (n = 8; n > 0 && cArray[n2 + n] == '0'; --n) {
        }
        return new String(cArray, 0, n2 += n + 1);
    }

    private static int writeFormattedInt(char[] cArray, int n, int n2, int n3) {
        for (int i = n + n2 - 1; i >= n; --i) {
            int n4 = n3 % 10;
            cArray[i] = (char)(48 + n4);
            n3 /= 10;
        }
        return n2;
    }
}

