/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbAnydata;
import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbIntervalDts;
import com.tmax.tibero.jdbc.TbIntervalYtm;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRef;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.TbXMLInputStream;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbNrowId;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.data.TbTime;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.ZoneInfo;
import com.tmax.tibero.jdbc.data.charset.CharsetMapper;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbDTFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DataTypeConverter
implements Cloneable {
    public static final byte RPCOL_UDT_OBJ = -124;
    public static final byte RPCOL_UDT_COLL = -120;
    public static final byte RPCOL_UDT_ROOT = 1;
    public static final byte RPCOL_UDT_SUBTYPE = 2;
    public static final byte[] RPCOL_UDT_NOT_FINAL = new byte[]{-2, 0, 0, 0};
    public static final int RPCOL_UDT_MIN_SIZE = 3;
    public static final byte RPCOL_NULLOBJ_W_DEPTH = -4;
    public static byte RPCOL_NULLOBJ;
    public static byte RPCOL_5BYTE;
    public static final int COLLECTION_META_LENGTH = 40;
    public static final int STRUCT_META_LENGTH = 40;
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";
    private TbConnection conn = null;
    private CharsetMapper charsetMapper = new CharsetMapper(2);
    private CharsetMapper nCharsetMapper = null;
    public static final String BUDDHA_CALENDAR = "THAI BUDDHA";
    public static final int BUDDHA_YEAR_GAP = 543;
    private static final int[] pr2six;
    private static final byte[] d;

    public DataTypeConverter(TbConnection tbConnection) throws SQLException {
        this.conn = tbConnection;
    }

    public void buildColumnMetadata(TbColumnDesc[] tbColumnDescArray, TbResultSet tbResultSet, int n) throws SQLException {
        this.buildColumnMetaData(tbColumnDescArray, 0, n, tbResultSet.getCols());
        for (int i = 0; i < n; ++i) {
            if (!DataType.isLocatorCategory(tbColumnDescArray[i].dataType)) continue;
            tbResultSet.setHaveLocator(true);
        }
    }

    public void buildColumnMetaData(TbColumnDesc[] tbColumnDescArray, int n, int n2, Column[] columnArray) throws SQLException {
        if (tbColumnDescArray.length > n2) {
            int n3;
            HashMap hashMap = new HashMap();
            try {
                block7: for (n3 = n2; n3 < tbColumnDescArray.length; ++n3) {
                    if (tbColumnDescArray[n3].name == null || !tbColumnDescArray[n3].name.matches("[0-9a-zA-Z]{32}")) continue;
                    switch (tbColumnDescArray[n3].dataType) {
                        case 28: 
                        case 32: {
                            TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(tbColumnDescArray[n3].dataType, tbColumnDescArray[n3].name, this.conn);
                            this.descPut(hashMap, n3, tbStructDescriptor);
                            continue block7;
                        }
                        case 29: 
                        case 30: 
                        case 31: {
                            TbArrayDescriptor tbArrayDescriptor = TbArrayDescriptor.createDescriptor(tbColumnDescArray[n3].dataType, tbColumnDescArray[n3].name, this.conn);
                            this.descPut(hashMap, n3, tbArrayDescriptor);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() <= -90400 && sQLException.getErrorCode() > -90500) {
                    throw sQLException;
                }
                this.conn.addWarning(TbError.newSQLWarning(-90664, sQLException));
            }
            catch (Exception exception) {
                this.conn.addWarning(TbError.newSQLWarning(-90664, exception));
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (DataType.isUDTCategory(tbColumnDescArray[n3].dataType)) {
                    columnArray[n3].set(n3, tbColumnDescArray[n3], (TbTypeDescriptor)this.descGet(hashMap, tbColumnDescArray[n3].scale));
                    continue;
                }
                columnArray[n3].set(n3, tbColumnDescArray[n3]);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                columnArray[i].set(i, tbColumnDescArray[i]);
            }
        }
    }

    private static String colDesc2Str(TbColumnDesc[] tbColumnDescArray) {
        if (tbColumnDescArray == null) {
            return "[(null)]";
        }
        StringBuffer stringBuffer = new StringBuffer(tbColumnDescArray.length * 40);
        stringBuffer.append("[#\n");
        for (int i = 0; i < tbColumnDescArray.length; ++i) {
            stringBuffer.append("  coldesc idx=").append(i).append("/type=").append(tbColumnDescArray[i].dataType).append("/size=").append(tbColumnDescArray[i].maxSize).append("/prec=").append(tbColumnDescArray[i].precision).append("/scale=").append(tbColumnDescArray[i].scale).append("/etc=").append(tbColumnDescArray[i].etcMeta).append("/name=").append(tbColumnDescArray[i].name).append("\n");
        }
        stringBuffer.append("#]");
        return stringBuffer.toString();
    }

    private <K, V> V descGet(Map<K, V> map, K k) {
        return map.get(k);
    }

    private <K, V> V descPut(Map<K, V> map, K k, V v) {
        return map.put(k, v);
    }

    public int bytesToChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        return this.charsetMapper.bytesToChars(byArray, n, n2, cArray, n3, n4, false);
    }

    public int bytesToNChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        return this.nCharsetMapper.bytesToChars(byArray, n, n2, cArray, n3, n4, false);
    }

    public byte[] castFromBigDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(bigDecimal.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(bigDecimal.toString());
            }
            case 1: {
                return this.fromBigDecimal(bigDecimal);
            }
            case 4: {
                return bigDecimal.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromBigDecimal(byte[] byArray, int n, BigDecimal bigDecimal, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, bigDecimal.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, bigDecimal.toString());
            }
            case 1: {
                return this.fromBigDecimal(byArray, n, bigDecimal);
            }
            case 4: {
                byte[] byArray2 = bigDecimal.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromBoolean(boolean bl, int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.fromInt(bl ? 1 : 0);
            }
            case 2: 
            case 3: {
                return this.fromString(bl ? "1" : "0");
            }
            case 18: 
            case 19: {
                return this.fromNString(bl ? "1" : "0");
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromBoolean(byte[] byArray, int n, boolean bl, int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return this.fromInt(byArray, n, bl ? 1 : 0);
            }
            case 2: 
            case 3: {
                return this.fromString(byArray, n, bl ? "1" : "0");
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, bl ? "1" : "0");
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromByte(byte by, int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.fromInt(by);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromByte(byte[] byArray, int n, byte by, int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return this.fromInt(byArray, n, by);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromBytes(byte[] byArray, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(new String(byArray));
            }
            case 18: 
            case 19: {
                return this.fromNString(new String(byArray));
            }
            case 4: {
                return byArray;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromBytes(byte[] byArray, int n, byte[] byArray2, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, new String(byArray2));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, new String(byArray2));
            }
            case 4: {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromDate(byte[] byArray, int n, Date date, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, date.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, date.toString());
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromDate(byArray, n, calendar);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromTimestamp(byArray, n, calendar, 0);
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromTime(byArray, n, calendar, 0);
            }
            case 4: {
                byte[] byArray2 = date.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromTbDate(byte[] byArray, int n, TbDate tbDate, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, tbDate.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, tbDate.toString());
            }
            case 5: 
            case 6: {
                return this.fromTbDate(byArray, n, tbDate);
            }
            case 7: {
                TbTimestamp tbTimestamp = new TbTimestamp(tbDate.getYear(), tbDate.getMonth(), tbDate.getDayOfMonth(), tbDate.getHourOfDay(), tbDate.getMinutes(), tbDate.getSeconds(), 0);
                return this.fromTbTimestamp(byArray, n, tbTimestamp);
            }
            case 4: {
                byte[] byArray2 = tbDate.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromDate(Date date, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(date.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(date.toString());
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromDate(calendar);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromTimestamp(calendar, 0);
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromTime(calendar, 0);
            }
            case 4: {
                return date.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromDouble(byte[] byArray, int n, double d, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, Double.toString(d));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, Double.toString(d));
            }
            case 1: {
                return this.fromDouble(byArray, n, d);
            }
            case 4: {
                byte[] byArray2 = Double.toString(d).getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
            case 24: {
                return this.fromBinaryDouble(byArray, n, d);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromDouble(double d, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Double.toString(d));
            }
            case 18: 
            case 19: {
                return this.fromNString(Double.toString(d));
            }
            case 1: {
                return this.fromDouble(d);
            }
            case 4: {
                return Double.toString(d).getBytes();
            }
            case 24: {
                return this.fromBinaryDouble(d);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromFloat(byte[] byArray, int n, float f, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, Float.toString(f));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, Float.toString(f));
            }
            case 1: {
                return this.fromFloat(byArray, n, f);
            }
            case 4: {
                byte[] byArray2 = Float.toString(f).getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
            case 23: {
                return this.fromBinaryFloat(byArray, n, f);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromFloat(float f, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Float.toString(f));
            }
            case 18: 
            case 19: {
                return this.fromNString(Float.toString(f));
            }
            case 1: {
                return this.fromFloat(f);
            }
            case 4: {
                return Float.toString(f).getBytes();
            }
            case 23: {
                return this.fromBinaryFloat(f);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromInt(byte[] byArray, int n, int n2, int n3) throws SQLException {
        switch (n3) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, Integer.toString(n2));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, Integer.toString(n2));
            }
            case 1: {
                return this.fromInt(byArray, n, n2);
            }
            case 4: {
                byte[] byArray2 = Integer.toString(n2).getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n3));
    }

    public byte[] castFromInt(int n, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Integer.toString(n));
            }
            case 18: 
            case 19: {
                return this.fromNString(Integer.toString(n));
            }
            case 1: {
                return this.fromInt(n);
            }
            case 4: {
                return Integer.toString(n).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromLong(byte[] byArray, int n, long l, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, Long.toString(l));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, Long.toString(l));
            }
            case 1: {
                return this.fromLong(byArray, n, l);
            }
            case 4: {
                byte[] byArray2 = Long.toString(l).getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromLong(long l, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Long.toString(l));
            }
            case 18: 
            case 19: {
                return this.fromNString(Long.toString(l));
            }
            case 1: {
                return this.fromLong(l);
            }
            case 4: {
                return Long.toString(l).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public byte[] castFromObject(Object object, int n) throws SQLException {
        if (object instanceof String) {
            return this.castFromString((String)object, n);
        }
        if (object instanceof Boolean) {
            return this.castFromBoolean((Boolean)object, n);
        }
        if (object instanceof Byte) {
            return this.castFromByte((Byte)object, n);
        }
        if (object instanceof byte[]) {
            return this.castFromBytes((byte[])object, n);
        }
        if (object instanceof BigDecimal) {
            return this.castFromBigDecimal((BigDecimal)object, n);
        }
        if (object instanceof Integer) {
            return this.castFromInt((Integer)object, n);
        }
        if (object instanceof Float) {
            return this.castFromFloat(((Float)object).floatValue(), n);
        }
        if (object instanceof Double) {
            return this.castFromDouble((Double)object, n);
        }
        if (object instanceof Long) {
            return this.castFromLong((Long)object, n);
        }
        if (object instanceof Short) {
            return this.castFromShort((Short)object, n);
        }
        if (object instanceof Date) {
            return this.castFromDate((Date)object, n);
        }
        if (object instanceof Time) {
            return this.castFromTime((Time)object, n);
        }
        if (object instanceof Timestamp) {
            return this.castFromTimestamp((Timestamp)object, n);
        }
        if (object instanceof LocalDate) {
            return this.castFromDate(Date.valueOf((LocalDate)object), n);
        }
        if (object instanceof LocalTime) {
            return this.castFromLocalTime((LocalTime)object, n);
        }
        if (object instanceof LocalDateTime) {
            return this.castFromTimestamp(Timestamp.valueOf((LocalDateTime)object), n);
        }
        if (object instanceof OffsetTime) {
            if (n == 21) {
                byte[] byArray = new byte[17];
                LocalTime localTime = ((OffsetTime)object).toLocalTime();
                LocalDateTime localDateTime = LocalDateTime.of(LocalDate.of(1970, 1, 1), localTime);
                TbTimestampTZ tbTimestampTZ = new TbTimestampTZ(Timestamp.valueOf(localDateTime), TimeZone.getTimeZone(((OffsetTime)object).getOffset().normalized()));
                this.castFromTbTimestampTZ(byArray, 0, tbTimestampTZ, n);
                return byArray;
            }
            return this.castFromLocalTime(((OffsetTime)object).toLocalTime(), n);
        }
        if (object instanceof OffsetDateTime) {
            if (n == 21) {
                byte[] byArray = new byte[17];
                LocalDateTime localDateTime = ((OffsetDateTime)object).toLocalDateTime();
                TbTimestampTZ tbTimestampTZ = new TbTimestampTZ(Timestamp.valueOf(localDateTime), TimeZone.getTimeZone(((OffsetDateTime)object).getOffset().normalized()));
                this.castFromTbTimestampTZ(byArray, 0, tbTimestampTZ, n);
                return byArray;
            }
            return this.castFromTimestamp(Timestamp.valueOf(((OffsetDateTime)object).toLocalDateTime()), n);
        }
        throw TbError.newSQLException(-90610, object.toString());
    }

    public int castFromRowId(byte[] byArray, int n, String string, int n2) throws SQLException {
        ServerInfo serverInfo = this.conn.getServerInfo();
        int n3 = serverInfo.getServerEndian();
        switch (n2) {
            case 15: {
                if (serverInfo.getServerIsNanobase() == 1) {
                    return new TbNrowId(this.conn).getServerBytes(byArray, n, n3, string);
                }
                return new TbRowId().fromString(byArray, n, n3, string);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromShort(byte[] byArray, int n, short s, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, Short.toString(s));
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, Short.toString(s));
            }
            case 1: {
                return this.fromShort(byArray, n, s);
            }
            case 4: {
                byte[] byArray2 = Short.toString(s).getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromShort(short s, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Short.toString(s));
            }
            case 18: 
            case 19: {
                return this.fromNString(Short.toString(s));
            }
            case 1: {
                return this.fromShort(s);
            }
            case 4: {
                return Short.toString(s).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromString(byte[] byArray, int n, String string, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, string);
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, string);
            }
            case 1: {
                BigDecimal bigDecimal = new BigDecimal(string);
                return this.fromBigDecimal(byArray, n, bigDecimal);
            }
            case 4: {
                byte[] byArray2 = string.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
            case 5: {
                Date date = Date.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromDate(byArray, n, calendar);
            }
            case 6: {
                Time time = Time.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTime(byArray, n, calendar, 0);
            }
            case 7: {
                Timestamp timestamp = Timestamp.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTimestamp(byArray, n, calendar, timestamp.getNanos());
            }
            case 13: {
                return this.stringToFixedBytes(string, 0, string.length(), byArray, n, byArray.length);
            }
            case 20: {
                return this.getDBEncodedNBytes(byArray, n, string);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromString(String string, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(string);
            }
            case 18: 
            case 19: {
                return this.fromNString(string);
            }
            case 1: {
                BigDecimal bigDecimal = new BigDecimal(string);
                return this.fromBigDecimal(bigDecimal);
            }
            case 4: {
                return string.toString().getBytes();
            }
            case 5: {
                Date date = Date.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return this.fromDate(calendar);
            }
            case 6: {
                Time time = Time.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTime(calendar, 0);
            }
            case 7: {
                Timestamp timestamp = Timestamp.valueOf(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTimestamp(calendar, timestamp.getNanos());
            }
            case 13: {
                byte[] byArray = new byte[string.length() * 2];
                this.stringToFixedBytes(string, 0, string.length(), byArray, 0, byArray.length);
                return byArray;
            }
            case 20: {
                return this.getDBEncodedNBytes(string);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromTime(byte[] byArray, int n, Time time, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, time.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, time.toString());
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTime(byArray, n, calendar, 0);
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromDate(byArray, n, calendar);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTimestamp(byArray, n, calendar, 0);
            }
            case 4: {
                byte[] byArray2 = time.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromTime(Time time, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(time.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(time.toString());
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTime(calendar, 0);
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromDate(calendar);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTimestamp(calendar, 0);
            }
            case 4: {
                return time.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public byte[] castFromLocalTime(LocalTime localTime, int n) throws SQLException {
        Time time = Time.valueOf(localTime);
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(time.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(time.toString());
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTime(calendar, localTime.getNano() / 1000000);
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromDate(calendar);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                return this.fromTimestamp(calendar, localTime.getNano() / 1000000);
            }
            case 4: {
                return time.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromTimestamp(byte[] byArray, int n, Timestamp timestamp, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, timestamp.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, timestamp.toString());
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromDate(byArray, n, calendar);
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTime(byArray, n, calendar, timestamp.getNanos());
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTimestamp(byArray, n, calendar, timestamp.getNanos());
            }
            case 4: {
                byte[] byArray2 = timestamp.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public byte[] castFromTimestamp(Timestamp timestamp, int n) throws SQLException {
        switch (n) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(timestamp.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(timestamp.toString());
            }
            case 5: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromDate(calendar);
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTime(calendar, timestamp.getNanos());
            }
            case 7: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                return this.fromTimestamp(calendar, timestamp.getNanos());
            }
            case 4: {
                return timestamp.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
    }

    public int castFromTbTimestamp(byte[] byArray, int n, TbTimestamp tbTimestamp, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, tbTimestamp.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, tbTimestamp.toString());
            }
            case 5: 
            case 6: {
                TbDate tbDate = new TbDate(tbTimestamp.getYear(), tbTimestamp.getMonth(), tbTimestamp.getDayOfMonth(), tbTimestamp.getHourOfDay(), tbTimestamp.getMinutes(), tbTimestamp.getSeconds());
                return this.fromTbDate(byArray, n, tbDate);
            }
            case 7: {
                return this.fromTbTimestamp(byArray, n, tbTimestamp);
            }
            case 4: {
                byte[] byArray2 = tbTimestamp.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromTbTimestampTZ(byte[] byArray, int n, TbTimestampTZ tbTimestampTZ, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, tbTimestampTZ.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, tbTimestampTZ.toString());
            }
            case 5: 
            case 6: {
                Calendar calendar = Calendar.getInstance(tbTimestampTZ.getTimeZone());
                calendar.setTimeInMillis(tbTimestampTZ.getTime());
                TbDate tbDate = new TbDate(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return this.fromTbDate(byArray, n, tbDate);
            }
            case 7: {
                Calendar calendar = Calendar.getInstance(tbTimestampTZ.getTimeZone());
                calendar.setTimeInMillis(tbTimestampTZ.getTime());
                TbTimestamp tbTimestamp = new TbTimestamp(calendar.getTimeInMillis());
                return this.fromTbTimestamp(byArray, n, tbTimestamp);
            }
            case 21: {
                return this.fromTbTimestampTZ(byArray, n, tbTimestampTZ);
            }
            case 4: {
                byte[] byArray2 = tbTimestampTZ.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromTimestampLTZ(byte[] byArray, int n, Timestamp timestamp, int n2) throws SQLException {
        switch (n2) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(byArray, n, timestamp.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(byArray, n, timestamp.toString());
            }
            case 5: 
            case 6: {
                TimeZone timeZone = TimeZone.getTimeZone("UTC");
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTimeInMillis(timestamp.getTime());
                TbDate tbDate = new TbDate(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                return this.fromTbDate(byArray, n, tbDate);
            }
            case 22: {
                TimeZone timeZone = TimeZone.getTimeZone("UTC");
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTimeInMillis(timestamp.getTime());
                TbTimestamp tbTimestamp = new TbTimestamp(calendar.getTimeInMillis(), timeZone);
                return this.fromTbTimestamp(byArray, n, tbTimestamp);
            }
            case 4: {
                byte[] byArray2 = timestamp.toString().getBytes();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromTbIntervalYtm(byte[] byArray, int n, TbIntervalYtm tbIntervalYtm, int n2) throws SQLException {
        switch (n2) {
            case 8: {
                return this.fromTbIntervalYtm(byArray, n, tbIntervalYtm);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int castFromTbIntervalDts(byte[] byArray, int n, TbIntervalDts tbIntervalDts, int n2) throws SQLException {
        switch (n2) {
            case 9: {
                return this.fromTbIntervalDts(byArray, n, tbIntervalDts);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n2));
    }

    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.charsetMapper.charsToBytes(cArray, n, n2, byArray, n3, n4, false);
    }

    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        byte by = 0;
        byte by2 = 0;
        int n5 = n3;
        for (int i = n; i < n + n2; ++i) {
            by = (byte)(cArray[i] >> 8 & 0xFF);
            by2 = (byte)(cArray[i] & 0xFF);
            if (n5 + 1 >= n3 + n4) {
                throw TbError.newSQLException(-590744, n5 + 1 + " >= " + n4);
            }
            byArray[n5++] = by;
            byArray[n5++] = by2;
        }
        return n5 - n3;
    }

    public int fixedBytesToChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        if (n2 % 2 != 0) {
            throw TbError.newSQLException(-590748, n2);
        }
        for (int i = n; i < n + n2; i += 2) {
            if (n5 >= n3 + n4) {
                throw TbError.newSQLException(-590744, n5 + " >= " + n3 + " + " + n4);
            }
            cArray[n5++] = (char)((short)(byArray[i] << 8 & 0xFFFF) + (short)(byArray[i + 1] & 0xFF));
        }
        return n5 - n3;
    }

    private byte[] fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        return TbNumber.fromString(bigDecimal.toString());
    }

    public int fromBigDecimal(byte[] byArray, int n, BigDecimal bigDecimal) throws SQLException {
        return TbNumber.fromString(byArray, n, bigDecimal.toString());
    }

    public int fromDate(byte[] byArray, int n, Calendar calendar) throws SQLException {
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        if (n2 == 0) {
            n3 *= -1;
        }
        byArray[n] = (byte)(n3 / 100 + 100);
        byArray[n + 1] = (byte)(n3 % 100 + 100);
        byArray[n + 2] = (byte)(calendar.get(2) + 1);
        byArray[n + 3] = (byte)calendar.get(5);
        byArray[n + 4] = calendar.get(9) == 0 ? (byte)calendar.get(10) : (byte)(calendar.get(10) + 12);
        byArray[n + 5] = (byte)calendar.get(12);
        byArray[n + 6] = (byte)calendar.get(13);
        byArray[n + 7] = 0;
        return 8;
    }

    private byte[] fromDate(Calendar calendar) throws SQLException {
        byte[] byArray = new byte[8];
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        if (n == 0) {
            n2 *= -1;
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = calendar.get(9) == 0 ? (byte)calendar.get(10) : (byte)(calendar.get(10) + 12);
        byArray[5] = (byte)calendar.get(12);
        byArray[6] = (byte)calendar.get(13);
        return byArray;
    }

    public int fromTbDate(byte[] byArray, int n, TbDate tbDate) throws SQLException {
        System.arraycopy(tbDate.getBytes(), 0, byArray, n, 8);
        return 8;
    }

    public int fromDouble(byte[] byArray, int n, double d) throws SQLException {
        return TbNumber.fromString(byArray, n, Double.toString(d));
    }

    private byte[] fromDouble(double d) throws SQLException {
        return TbNumber.fromString(Double.toString(d));
    }

    public int fromFloat(byte[] byArray, int n, float f) throws SQLException {
        return TbNumber.fromString(byArray, n, Float.toString(f));
    }

    private byte[] fromFloat(float f) throws SQLException {
        return TbNumber.fromString(Float.toString(f));
    }

    public int fromBinaryDouble(byte[] byArray, int n, double d) throws SQLException {
        return this.convertDouble2Bytes(byArray, n, d);
    }

    public byte[] fromBinaryDouble(double d) throws SQLException {
        byte[] byArray = new byte[8];
        this.convertDouble2Bytes(byArray, 0, d);
        return byArray;
    }

    private int convertDouble2Bytes(byte[] byArray, int n, double d) {
        int n2 = 8;
        if (Double.compare(d, Double.NaN) == 0) {
            byArray[n] = -1;
            byArray[n + 1] = -8;
            byArray[n + 2] = 0;
            byArray[n + 3] = 0;
            byArray[n + 4] = 0;
            byArray[n + 5] = 0;
            byArray[n + 6] = 0;
            byArray[n + 7] = 0;
        } else if (Double.compare(d, -0.0) == 0 || Double.compare(d, 0.0) == 0) {
            byArray[n] = -128;
            byArray[n + 1] = 0;
            byArray[n + 2] = 0;
            byArray[n + 3] = 0;
            byArray[n + 4] = 0;
            byArray[n + 5] = 0;
            byArray[n + 6] = 0;
            byArray[n + 7] = 0;
        } else if (d > 0.0) {
            long l = Double.doubleToRawLongBits(d *= -1.0);
            TbCommon.long2Bytes(l, byArray, n, n2);
        } else if (d < 0.0) {
            long l = Double.doubleToRawLongBits(d);
            TbCommon.long2Bytes(l ^= 0xFFFFFFFFFFFFFFFFL, byArray, n, n2);
        } else {
            long l = Double.doubleToRawLongBits(d);
            TbCommon.long2Bytes(l, byArray, n, n2);
        }
        return n2;
    }

    public int fromBinaryFloat(byte[] byArray, int n, float f) throws SQLException {
        return this.convertFloat2Bytes(byArray, n, f);
    }

    public byte[] fromBinaryFloat(float f) throws SQLException {
        byte[] byArray = new byte[4];
        this.convertFloat2Bytes(byArray, 0, f);
        return byArray;
    }

    private int convertFloat2Bytes(byte[] byArray, int n, float f) {
        int n2 = 4;
        if (Float.compare(f, Float.NaN) == 0) {
            byArray[n] = -1;
            byArray[n + 1] = -64;
            byArray[n + 2] = 0;
            byArray[n + 3] = 0;
        } else if (Float.compare(f, -0.0f) == 0 || Float.compare(f, 0.0f) == 0) {
            byArray[n] = -128;
            byArray[n + 1] = 0;
            byArray[n + 2] = 0;
            byArray[n + 3] = 0;
        } else if (f > 0.0f) {
            int n3 = Float.floatToRawIntBits(f *= -1.0f);
            TbCommon.int2Bytes(n3, byArray, n, n2);
        } else if (f < 0.0f) {
            int n4 = Float.floatToRawIntBits(f);
            TbCommon.int2Bytes(n4 ^= 0xFFFFFFFF, byArray, n, n2);
        } else {
            int n5 = Float.floatToRawIntBits(f);
            TbCommon.int2Bytes(n5, byArray, n, n2);
        }
        return n2;
    }

    public int fromInt(byte[] byArray, int n, int n2) throws SQLException {
        return TbNumber.fromInteger(byArray, n, n2);
    }

    private byte[] fromInt(int n) throws SQLException {
        return TbNumber.fromInteger(n);
    }

    public int fromLong(byte[] byArray, int n, long l) throws SQLException {
        return TbNumber.fromLong(byArray, n, l);
    }

    private byte[] fromLong(long l) throws SQLException {
        return TbNumber.fromLong(l);
    }

    public int fromNString(byte[] byArray, int n, String string) throws SQLException {
        return this.getDBEncodedNBytes(byArray, n, string);
    }

    private byte[] fromNString(String string) throws SQLException {
        return this.getDBEncodedNBytes(string);
    }

    public int fromShort(byte[] byArray, int n, short s) throws SQLException {
        return this.fromInt(byArray, n, s);
    }

    private byte[] fromShort(short s) throws SQLException {
        return this.fromInt(s);
    }

    public int fromString(byte[] byArray, int n, String string) throws SQLException {
        return this.getDBEncodedBytes(byArray, n, string);
    }

    public byte[] fromString(String string) throws SQLException {
        return this.getDBEncodedBytes(string);
    }

    public int fromTime(byte[] byArray, int n, Calendar calendar, int n2) throws SQLException {
        int n3 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n3 += 12;
        }
        byArray[n] = (byte)n3;
        byArray[n + 1] = (byte)calendar.get(12);
        byArray[n + 2] = (byte)calendar.get(13);
        byArray[n + 3] = 0;
        if (n2 != 0) {
            TbCommon.int2Bytes(n2, byArray, n + 4, 4);
        } else {
            int n4 = calendar.get(14) * 1000000;
            TbCommon.int2Bytes(n4, byArray, n + 4, 4);
        }
        return 8;
    }

    private byte[] fromTime(Calendar calendar, int n) throws SQLException {
        byte[] byArray = new byte[8];
        int n2 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n2 += 12;
        }
        byArray[0] = (byte)n2;
        byArray[1] = (byte)calendar.get(12);
        byArray[2] = (byte)calendar.get(13);
        byArray[3] = 0;
        TbCommon.int2Bytes(n, byArray, 4, 4);
        return byArray;
    }

    public int fromTimestamp(byte[] byArray, int n, Calendar calendar, int n2) throws SQLException {
        int n3 = calendar.get(0);
        int n4 = calendar.get(1);
        if (n3 == 0) {
            n4 *= -1;
        }
        int n5 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n5 += 12;
        }
        byArray[n] = (byte)(n4 / 100 + 100);
        byArray[n + 1] = (byte)(n4 % 100 + 100);
        byArray[n + 2] = (byte)(calendar.get(2) + 1);
        byArray[n + 3] = (byte)calendar.get(5);
        byArray[n + 4] = (byte)n5;
        byArray[n + 5] = (byte)calendar.get(12);
        byArray[n + 6] = (byte)calendar.get(13);
        byArray[n + 7] = 0;
        TbCommon.int2Bytes(n2, byArray, n + 8, 4);
        return 12;
    }

    public int fromTimestampTZ(byte[] byArray, int n, Calendar calendar, int n2, TimeZone timeZone) throws SQLException {
        int n3 = calendar.get(0);
        int n4 = calendar.get(1);
        if (n3 == 0) {
            n4 *= -1;
        }
        int n5 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n5 += 12;
        }
        byArray[n] = (byte)(n4 / 100 + 100);
        byArray[n + 1] = (byte)(n4 % 100 + 100);
        byArray[n + 2] = (byte)(calendar.get(2) + 1);
        byArray[n + 3] = (byte)calendar.get(5);
        byArray[n + 4] = (byte)n5;
        byArray[n + 5] = (byte)calendar.get(12);
        byArray[n + 6] = (byte)calendar.get(13);
        byArray[n + 7] = 0;
        TbCommon.int2Bytes(n2, byArray, n + 8, 4);
        String string = timeZone.getID();
        int n6 = ZoneInfo.getTimeZoneIdByName(string);
        int n7 = timeZone.getOffset(calendar.getTimeInMillis());
        int n8 = (n7 /= 1000) % 60;
        int n9 = n7 / 60 % 60;
        int n10 = n7 / 3600;
        byArray[n + 12] = (byte)((0xFF & n10) + 100);
        byArray[n + 13] = (byte)(0xFF & n9);
        byArray[n + 14] = (byte)(0xFF & n8);
        TbCommon.int2Bytes(n6, byArray, n + 15, 2);
        return 17;
    }

    private byte[] fromTimestamp(Calendar calendar, int n) throws SQLException {
        byte[] byArray = new byte[12];
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        if (n2 == 0) {
            n3 *= -1;
        }
        int n4 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n4 += 12;
        }
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)n4;
        byArray[5] = (byte)calendar.get(12);
        byArray[6] = (byte)calendar.get(13);
        TbCommon.int2Bytes(n, byArray, 8, 4);
        return byArray;
    }

    public int fromTbTimestamp(byte[] byArray, int n, TbTimestamp tbTimestamp) throws SQLException {
        System.arraycopy(tbTimestamp.getBytes(), 0, byArray, n, 12);
        return 12;
    }

    public int fromTbTimestampTZ(byte[] byArray, int n, TbTimestampTZ tbTimestampTZ) throws SQLException {
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        calendar.setTimeInMillis(tbTimestampTZ.getTime());
        return this.fromTimestampTZ(byArray, n, calendar, tbTimestampTZ.getNanos(), tbTimestampTZ.getTimeZone());
    }

    public int fromTbIntervalYtm(byte[] byArray, int n, TbIntervalYtm tbIntervalYtm) throws SQLException {
        System.arraycopy(tbIntervalYtm.getBytes(), 0, byArray, n, 5);
        return 5;
    }

    public int fromTbIntervalDts(byte[] byArray, int n, TbIntervalDts tbIntervalDts) throws SQLException {
        System.arraycopy(tbIntervalDts.getBytes(), 0, byArray, n, 12);
        return 12;
    }

    private String getDBDecodedNString(byte[] byArray, int n, int n2) throws SQLException {
        return this.nCharsetMapper.bytesToString(byArray, n, n2, false);
    }

    public String getDBDecodedString(byte[] byArray, int n, int n2) throws SQLException {
        return this.charsetMapper.bytesToString(byArray, n, n2, false);
    }

    private int getDBEncodedBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.charsetMapper.stringToBytes(byArray, n, string);
    }

    public byte[] getDBEncodedBytes(String string) throws SQLException {
        return this.charsetMapper.stringToBytes(string);
    }

    private int getDBEncodedNBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.nCharsetMapper.stringToBytes(byArray, n, string);
    }

    private byte[] getDBEncodedNBytes(String string) throws SQLException {
        return this.nCharsetMapper.stringToBytes(string);
    }

    public int getEndingBytePos(byte[] byArray, int n) {
        return this.charsetMapper.getEndingBytePos(byArray, n);
    }

    public int getEndingBytePosNCharset(byte[] byArray, int n) {
        return this.nCharsetMapper.getEndingBytePos(byArray, n);
    }

    public int getLeadingBytePos(byte[] byArray, int n) {
        return this.charsetMapper.getLeadingBytePos(byArray, n);
    }

    public int getLeadingBytePosNCharset(byte[] byArray, int n) {
        return this.nCharsetMapper.getLeadingBytePos(byArray, n);
    }

    public int getMaxBytesPerChar() {
        return this.charsetMapper.getMaxBytesPerChar();
    }

    public int getMaxBytesPerNChar() {
        return this.nCharsetMapper.getMaxBytesPerChar();
    }

    public int getUCS2MaxBytesPerChar() {
        return 2;
    }

    public boolean isEndingByte(byte[] byArray, int n) {
        return this.charsetMapper.isEndingByte(byArray, n);
    }

    public boolean isEndingByteNCharset(byte[] byArray, int n) {
        return this.nCharsetMapper.isEndingByte(byArray, n);
    }

    public boolean isLeadingByte(byte[] byArray, int n) {
        return this.charsetMapper.isLeadingByte(byArray, n);
    }

    public boolean isLeadingByteNCharset(byte[] byArray, int n) {
        return this.nCharsetMapper.isLeadingByte(byArray, n);
    }

    public int nCharsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.nCharsetMapper.charsToBytes(cArray, n, n2, byArray, n3, n4, false);
    }

    public void reset() {
        this.charsetMapper = null;
        this.nCharsetMapper = null;
        this.conn = null;
    }

    public void setCharset(int n, int n2) throws SQLException {
        if (n == 27) {
            n = 7;
        }
        if (n2 == 27) {
            n2 = 7;
        }
        if (n == 28 || n == 29) {
            n = 13;
        }
        if (n2 == 28 || n2 == 29) {
            n2 = 13;
        }
        this.charsetMapper = new CharsetMapper(n);
        this.nCharsetMapper = new CharsetMapper(n2);
    }

    private int stringToFixedBytes(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        byte by = 0;
        byte by2 = 0;
        int n5 = n3;
        for (int i = n; i < n2; ++i) {
            by = (byte)(string.charAt(i) >> 8 & 0xFF);
            by2 = (byte)(string.charAt(i) & 0xFF);
            if (n5 + 1 >= n4) {
                throw TbError.newSQLException(-590744, n5 + 1 + " >= " + n4);
            }
            byArray[n5++] = by;
            byArray[n5++] = by2;
        }
        return n5 - n3;
    }

    public Object toStruct(Object object, int n, int n2, int n3, boolean bl, TbStructDescriptor tbStructDescriptor, Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        boolean bl2;
        Object object2;
        int n4;
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (n3 != 32 && n3 != 28) {
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        if (tbStructDescriptor == null) {
            throw TbError.newSQLException(-90612, "obj_desc null");
        }
        if (!(object instanceof byte[])) {
            throw TbError.newSQLException(-90612, "inst=" + object.toString());
        }
        byte[] byArray = (byte[])object;
        if (byArray.length > n + 3 && byArray[n] == -124) {
            n4 = n;
        } else if (byArray.length > n + 5 && n2 > 5) {
            int n5;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            object2 = new TbBlob(this.conn, byArray2, true);
            long l = ((TbLob)object2).length();
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90612, "rp(lob) len=" + l);
            }
            byArray = ((TbBlob)object2).getBytes(1L, (int)l);
            int n6 = n5 = byArray == null ? 0 : byArray.length;
            if (n5 < 3) {
                throw TbError.newSQLException(-90612, "udt_lob_len=" + n5);
            }
            if (byArray[0] != -124) {
                throw TbError.newSQLException(-90612, "udt_rpflag=0x" + Integer.toHexString(0xFF & byArray[0]));
            }
            n4 = 0;
        } else {
            throw TbError.newSQLException(-90612, object.toString());
        }
        if (byArray[n4 + 1] == 1) {
            bl2 = true;
        } else if (byArray[n4 + 1] == 2) {
            bl2 = false;
        } else {
            throw TbError.newSQLException(-90612, "udt_inherit=0x" + Integer.toHexString(0xFF & byArray[n4 + 1]));
        }
        object2 = tbStructDescriptor;
        if (byArray[n4 += 2] == RPCOL_UDT_NOT_FINAL[0] && byArray.length >= n4 + 4 && byArray[n4 + 1] == RPCOL_UDT_NOT_FINAL[1] && byArray[n4 + 2] == RPCOL_UDT_NOT_FINAL[2] && byArray[n4 + 3] == RPCOL_UDT_NOT_FINAL[3]) {
            n4 += RPCOL_UDT_NOT_FINAL.length;
        }
        if (this.conn.serverInfo.getProtocolMajorVersion() >= 2 && this.conn.serverInfo.getProtocolMinorVersion() >= 16) {
            RPCOL_NULLOBJ = (byte)-5;
            RPCOL_5BYTE = (byte)-3;
        } else {
            RPCOL_NULLOBJ = (byte)-3;
            RPCOL_5BYTE = (byte)-5;
        }
        int n7 = byArray[n4] & 0xFF;
        if (n7 <= 250) {
            ++n4;
        } else if (n7 == 254) {
            n7 = TbCommon.bytes2Int(byArray, n4 + 1, 2);
            n4 += 3;
        } else if ((byte)n7 == RPCOL_5BYTE) {
            n7 = TbCommon.bytes2Int(byArray, n4 + 1, 4);
            n4 += 5;
        } else {
            throw TbError.newSQLException(-90612, "udt_rplen=0x" + Integer.toHexString(n7));
        }
        if (!bl2) {
            int n8 = 0xFF & byArray[n4];
            byte[] byArray3 = this.toBytes((Object)byArray, n4 + 1, n8, 4, bl);
            n4 += 1 + n8;
            char[] cArray = "0123456789ABCDEF".toCharArray();
            StringBuilder stringBuilder = new StringBuilder(n8 * 2);
            for (int i = 0; i < n8; ++i) {
                stringBuilder.append(cArray[byArray3[i] >> 4 & 0xF]);
                stringBuilder.append(cArray[byArray3[i] & 0xF]);
            }
            String string = stringBuilder.toString();
            try {
                object2 = TbStructDescriptor.createDescriptor(n3, string, this.conn);
            }
            catch (SQLException sQLException) {
                throw TbError.newSQLException(-90612, sQLException);
            }
        }
        LinkedList<ObjInstBldCtx> linkedList = new LinkedList<ObjInstBldCtx>();
        Object object3 = new ObjInstBldCtx((TbStructDescriptor)object2);
        block11: while (true) {
            Object object4;
            Object object5;
            Object object6;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            switch (byArray[n4]) {
                case -4: {
                    n10 = 0xFF & byArray[n4 + 1];
                    n4 += 2;
                    break;
                }
                case 0: {
                    n10 = Integer.MAX_VALUE;
                    ++n4;
                    break;
                }
                default: {
                    if (byArray[n4] == RPCOL_NULLOBJ) {
                        ++n4;
                        break;
                    }
                    n11 = byArray[n4] & 0xFF;
                    if (n11 <= 250) {
                        ++n4;
                        break;
                    }
                    if (n11 == 254) {
                        n11 = TbCommon.bytes2Int(byArray, n4 + 1, 2);
                        n4 += 3;
                        break;
                    }
                    if ((byte)n11 == RPCOL_5BYTE) {
                        n11 = TbCommon.bytes2Int(byArray, n4 + 1, 4);
                        n4 += 5;
                        break;
                    }
                    throw TbError.newSQLException(-90612, "subRpLen=" + n11);
                }
            }
            while (((ObjInstBldCtx)object3).desc.getAttributeTypes()[((ObjInstBldCtx)object3).attrProcessed] == 32 && (n11 != 0 || n9 < n10)) {
                String string = ((ObjInstBldCtx)object3).desc.getAttributeTypeNames()[((ObjInstBldCtx)object3).attrProcessed];
                String string2 = ((ObjInstBldCtx)object3).desc.getAttributeOIDs()[((ObjInstBldCtx)object3).attrProcessed];
                for (ObjInstBldCtx objInstBldCtx : linkedList) {
                    if (objInstBldCtx.attrProcessed > 0) break;
                    if ((string == null || !string.equalsIgnoreCase(objInstBldCtx.desc.getSQLTypeName())) && (string2 == null || !string2.equalsIgnoreCase(objInstBldCtx.desc.getOID()))) continue;
                    throw TbError.newSQLException(-90612, byArray.toString());
                }
                object6 = null;
                if (string2 != null && (object6 = this.conn.getDescriptor(_DESC_OID_PREFIX + string2)) == null) {
                    object6 = TbStructDescriptor.createDescriptor(32, string2, this.conn);
                }
                if (object6 == null && string != null && (object6 = this.conn.getDescriptor(string)) == null) {
                    object6 = TbStructDescriptor.createDescriptor(string, (Connection)this.conn);
                }
                if (object6 == null) {
                    throw TbError.newSQLException(-90665, "parent=" + ((ObjInstBldCtx)object3).desc.getSQLTypeName() + ", attrIdx=" + ((ObjInstBldCtx)object3).attrProcessed + ", attr=" + string + ", attrOID=" + string2);
                }
                if (!(object6 instanceof TbStructDescriptor) || !((TbStructDescriptor)object6).isFinal()) break;
                TbStructDescriptor tbStructDescriptor2 = (TbStructDescriptor)object6;
                object5 = new ObjInstBldCtx(tbStructDescriptor2);
                linkedList.addFirst((ObjInstBldCtx)object3);
                object3 = object5;
                ++n9;
            }
            int n12 = ((ObjInstBldCtx)object3).desc.getAttributeTypes()[((ObjInstBldCtx)object3).attrProcessed];
            int n13 = DataType.getSqlType(n12);
            object6 = ((ObjInstBldCtx)object3).desc.getAttributeTypeNames()[((ObjInstBldCtx)object3).attrProcessed];
            String object72 = ((ObjInstBldCtx)object3).desc.getAttributeOIDs()[((ObjInstBldCtx)object3).attrProcessed];
            object5 = null;
            switch (n12) {
                case 29: 
                case 30: 
                case 31: {
                    if (object72 != null && (object5 = this.conn.getDescriptor(object72)) == null) {
                        object5 = TbArrayDescriptor.createDescriptor(n12, object72, this.conn);
                    }
                    if (object5 == null && object6 != null && (object5 = this.conn.getDescriptor((String)object6)) == null) {
                        object5 = TbArrayDescriptor.createDescriptor((String)object6, this.conn);
                    }
                    if (object5 != null) break;
                    throw TbError.newSQLException(-90665, "parent=" + ((ObjInstBldCtx)object3).desc.getSQLTypeName() + ", attrIdx=" + ((ObjInstBldCtx)object3).attrProcessed + ", attr=" + (String)object6 + ", attrOID=" + object72);
                }
                case 28: 
                case 32: {
                    if (object72 != null && (object5 = this.conn.getDescriptor(object72)) == null) {
                        object5 = TbStructDescriptor.createDescriptor(n12, object72, this.conn);
                    }
                    if (object5 == null && object6 != null && (object5 = this.conn.getDescriptor((String)object6)) == null) {
                        object5 = TbStructDescriptor.createDescriptor((String)object6, (Connection)this.conn);
                    }
                    if (object5 != null) break;
                    throw TbError.newSQLException(-90665, "parent=" + ((ObjInstBldCtx)object3).desc.getSQLTypeName() + ", attrIdx=" + ((ObjInstBldCtx)object3).attrProcessed + ", attr=" + (String)object6 + ", attrOID=" + object72);
                }
            }
            if (object5 instanceof TbArrayDescriptor) {
                object4 = (TbArrayDescriptor)object5;
                ((ObjInstBldCtx)object3).values[((ObjInstBldCtx)object3).attrProcessed] = this.toArray(byArray, n4, n11, n12, bl, (TbArrayDescriptor)object4, map);
            } else if (object5 instanceof TbStructDescriptor) {
                object4 = (TbStructDescriptor)object5;
                ((ObjInstBldCtx)object3).values[((ObjInstBldCtx)object3).attrProcessed] = this.toStruct(byArray, n4, n11, n12, bl, (TbStructDescriptor)object4, null, map);
            } else {
                if (((ObjInstBldCtx)object3).desc.getAttributeTypes()[((ObjInstBldCtx)object3).attrProcessed] == 1 && n11 > 0) {
                    --n4;
                    ++n11;
                }
                ((ObjInstBldCtx)object3).values[((ObjInstBldCtx)object3).attrProcessed] = this.toObject(byArray, n4, n11, n12, n13, bl);
            }
            ++((ObjInstBldCtx)object3).attrProcessed;
            n4 += n11;
            n9 = 0;
            while (true) {
                if (((ObjInstBldCtx)object3).values.length > ((ObjInstBldCtx)object3).attrProcessed) continue block11;
                object4 = new TbStruct(((ObjInstBldCtx)object3).desc, this.conn, ((ObjInstBldCtx)object3).values);
                Object object7 = null;
                boolean bl3 = linkedList.isEmpty();
                if (object4 != null) {
                    object7 = bl3 && clazz != null ? ((TbStruct)object4).toClass(clazz, map) : ((TbStruct)object4).toClass(map);
                }
                if (bl3) {
                    return object7;
                }
                ObjInstBldCtx objInstBldCtx = (ObjInstBldCtx)linkedList.removeFirst();
                objInstBldCtx.values[objInstBldCtx.attrProcessed++] = object7;
                object3 = objInstBldCtx;
            }
            break;
        }
    }

    public Array toArray(Object object, int n, int n2, int n3, boolean bl, TbArrayDescriptor tbArrayDescriptor, Map<String, Class<?>> map) throws SQLException {
        int n4;
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (!(object instanceof byte[])) {
            throw TbError.newSQLException(-90612, "inst=" + object.toString());
        }
        if (n3 != 29 && n3 != 30 && n3 != 31) {
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        if (tbArrayDescriptor == null) {
            throw TbError.newSQLException(-90612, "arr_desc=null");
        }
        byte[] byArray = (byte[])object;
        if (byArray.length > n + 3 && byArray[n] == -120 && byArray[n + 1] == 1) {
            n4 = n + 2;
        } else if (byArray.length > n + 5) {
            int n5;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            TbBlob tbBlob = new TbBlob(this.conn, byArray2, true);
            long l = tbBlob.length();
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90612, "rp(lob) len=" + l);
            }
            byArray = tbBlob.getBytes(1L, (int)l);
            int n6 = n5 = byArray == null ? 0 : byArray.length;
            if (n5 < 3) {
                throw TbError.newSQLException(-90612, "udt_lob_len=" + n5);
            }
            if (byArray[0] != -120 || byArray[1] != 1) {
                throw TbError.newSQLException(-90612, "udt_rpflag=0x" + Integer.toHexString(0xFF & byArray[0]) + ",0x" + Integer.toHexString(0xFF & byArray[1]));
            }
            n4 = 2;
        } else {
            throw TbError.newSQLException(-90612, object.toString());
        }
        int n7 = tbArrayDescriptor.getElementType();
        int n8 = tbArrayDescriptor.getBaseType();
        if (this.conn.serverInfo.getProtocolMajorVersion() >= 2 && this.conn.serverInfo.getProtocolMinorVersion() >= 16) {
            RPCOL_NULLOBJ = (byte)-5;
            RPCOL_5BYTE = (byte)-3;
        } else {
            RPCOL_NULLOBJ = (byte)-3;
            RPCOL_5BYTE = (byte)-5;
        }
        int n9 = byArray[n4] & 0xFF;
        if (n9 <= 250) {
            ++n4;
        } else if (n9 == 254) {
            n9 = TbCommon.bytes2Int(byArray, n4 + 1, 2);
            n4 += 3;
        } else if ((byte)n9 == RPCOL_5BYTE) {
            n9 = TbCommon.bytes2Int(byArray, n4 + 1, 4);
            n4 += 5;
        } else {
            throw TbError.newSQLException(-90612, "rplen=" + n9);
        }
        if (byArray[n4] != 0 || byArray[n4 + 1] != 0 || byArray[n4 + 2] != 0) {
            throw TbError.newSQLException(-90612, "illegal_input");
        }
        int n10 = byArray[n4 += 3] & 0xFF;
        if (n10 <= 250) {
            ++n4;
        } else if (n10 == 254) {
            n10 = TbCommon.bytes2Int(byArray, n4 + 1, 2);
            n4 += 3;
        } else if ((byte)n10 == RPCOL_5BYTE) {
            n10 = TbCommon.bytes2Int(byArray, n4 + 1, 4);
            n4 += 5;
        } else {
            throw TbError.newSQLException(-90612, "arrayElemCnt=" + n10);
        }
        Object[] objectArray = new Object[n10];
        for (int i = 0; i < n10; ++i) {
            int n11 = byArray[n4] & 0xFF;
            if (n11 <= 250) {
                ++n4;
            } else if (n11 == 254) {
                n11 = TbCommon.bytes2Int(byArray, n4 + 1, 2);
                n4 += 3;
            } else if ((byte)n11 == RPCOL_5BYTE) {
                n11 = TbCommon.bytes2Int(byArray, n4 + 1, 4);
                n4 += 5;
            } else {
                if ((byte)n11 == RPCOL_NULLOBJ) {
                    objectArray[i] = null;
                    ++n4;
                    continue;
                }
                throw TbError.newSQLException(-90612, "subRpLen=" + n11);
            }
            switch (n7) {
                case 29: 
                case 30: 
                case 31: {
                    Object object2;
                    Object object3 = this.conn.getDescriptor(tbArrayDescriptor.getElementTypeName());
                    if (object3 == null) {
                        object3 = TbArrayDescriptor.createDescriptor(n7, tbArrayDescriptor.getElementTypeName(), this.conn);
                    }
                    if (object3 instanceof TbArrayDescriptor) {
                        object2 = (TbArrayDescriptor)object3;
                        objectArray[i] = this.toArray(byArray, n4, n11, n7, bl, (TbArrayDescriptor)object2, map);
                        break;
                    }
                    TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
                    break;
                }
                case 28: 
                case 32: {
                    Object object2 = this.conn.getDescriptor(tbArrayDescriptor.getElementTypeName());
                    if (object2 == null) {
                        object2 = TbStructDescriptor.createDescriptor(n7, tbArrayDescriptor.getElementTypeName(), this.conn);
                    }
                    if (object2 instanceof TbStructDescriptor) {
                        TbStructDescriptor tbStructDescriptor = (TbStructDescriptor)object2;
                        objectArray[i] = this.toStruct(byArray, n4, n11, n7, bl, tbStructDescriptor, null, map);
                        break;
                    }
                    TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
                    break;
                }
                case 1: {
                    if (n11 == 0) {
                        objectArray[i] = null;
                        break;
                    }
                    objectArray[i] = this.toObject(byArray, n4 - 1, n11 + 1, n7, n8, bl);
                    break;
                }
                default: {
                    objectArray[i] = this.toObject(byArray, n4, n11, n7, n8, bl);
                }
            }
            n4 += n11;
        }
        return new TbArray(tbArrayDescriptor, this.conn, objectArray);
    }

    public Ref toRef(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 33: {
                    return new TbRef(byArray, n, n2, this.conn);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toAsciiStream(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 == 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    return new ByteArrayInputStream(byArray, n, n2);
                }
                case 10: {
                    byte[] byArray2;
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        byArray2 = this.conn.getTbComm().readLongRaw(byArray3);
                    }
                    return new ByteArrayInputStream(byArray2, 0, byArray2.length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public BigDecimal toBigDecimal(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 == 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return new BigDecimal(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
                case 1: {
                    return TbNumber.toBigDecimal(byArray, n, n2);
                }
                case 24: {
                    Double d = new Double(TbNumber.toBinaryDouble(byArray, n, n2));
                    return new BigDecimal(d.toString());
                }
                case 23: {
                    Float f = new Float(TbNumber.toBinaryFloat(byArray, n, n2));
                    return new BigDecimal(f.toString());
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toBinaryStream(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 == 0 || object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            try {
                ((InputStream)object).reset();
                return (InputStream)object;
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90616, iOException);
            }
        }
        if (object instanceof Blob) {
            return ((TbBlob)object).getBinaryStream();
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    return new ByteArrayInputStream(byArray, n, n2);
                }
                case 11: {
                    byte[] byArray2;
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        byArray2 = this.conn.getTbComm().readLongRaw(byArray3);
                    }
                    return new ByteArrayInputStream(byArray2, 0, byArray2.length);
                }
                case 12: 
                case 34: {
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray, n, byArray4, 0, n2);
                    return new TbBlob(this.conn, byArray4, false).getBinaryStream();
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public Blob toBlob(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        if (n2 == 0 || object == null) {
            return null;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 12: 
                case 34: {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    return new TbBlob(this.conn, byArray2, bl);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public boolean toBoolean(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 == 0 || object == null) {
            return false;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    String string = this.getDBDecodedString(byArray, n, n2).trim();
                    return string != null && (string.equals("t") || string.equals("1") || string.equalsIgnoreCase("true"));
                }
                case 18: 
                case 19: {
                    String string = this.getDBDecodedNString(byArray, n, n2).trim();
                    return string != null && (string.equals("t") || string.equals("1") || string.equalsIgnoreCase("true"));
                }
                case 1: {
                    return TbNumber.toInteger(byArray, n, n2) != 0;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public byte toByte(Object object, int n, int n2, int n3) throws SQLException {
        int n4 = this.toIntInternal(object, n, n2, n3);
        if (n4 > 127 || n4 < -128) {
            throw TbError.newSQLException(-590749, n4);
        }
        return (byte)n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        if (n2 == 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 10: 
                case 11: {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        return this.conn.getTbComm().readLongRaw(byArray2);
                    }
                }
                case 12: 
                case 34: {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    TbBlob tbBlob = new TbBlob(this.conn, byArray3, bl);
                    byte[] byArray4 = tbBlob.getBytes(1L, (int)tbBlob.length());
                    if (tbBlob.getIsTempLob() && bl) {
                        tbBlob.free();
                    }
                    return byArray4;
                }
                case 13: 
                case 20: {
                    throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
                }
            }
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray, n, byArray5, 0, n2);
            return byArray5;
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public int toBytes(Object object, int n, int n2, int n3, byte[] byArray) throws SQLException {
        if (n2 <= 0 || object == null) {
            return 0;
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 20: 
                case 34: {
                    throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
                }
            }
            if (n2 > byArray.length) {
                throw TbError.newSQLException(-90650);
            }
            System.arraycopy(object, n, byArray, 0, n2);
            return n2;
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader toCharacterStream(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof Reader) {
            try {
                ((Reader)object).reset();
                return (Reader)object;
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90616, iOException);
            }
        }
        if (object instanceof Clob) {
            return ((TbClob)object).getCharacterStream();
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    return new StringReader(this.getDBDecodedString(byArray, n, n2));
                }
                case 18: 
                case 19: {
                    return new StringReader(this.getDBDecodedNString(byArray, n, n2));
                }
                case 10: {
                    String string;
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        string = this.conn.getTbComm().readLong(byArray2);
                    }
                    return new StringReader(string);
                }
                case 13: {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    return new TbClob(this.conn, byArray3, false).getCharacterStream();
                }
                case 20: {
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray, n, byArray4, 0, n2);
                    return new TbNClob(this.conn, byArray4, false).getCharacterStream();
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public Clob toClob(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 13: {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    return new TbClob(this.conn, byArray2, bl);
                }
                case 20: {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    return new TbNClob(this.conn, byArray3, bl);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public Date toDate(Object object, int n, int n2, int n3) throws SQLException {
        return this.toDate(object, n, n2, n3, null);
    }

    public Date toDate(Object object, int n, int n2, int n3, Calendar calendar) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    String string = this.getDBDecodedString(byArray, n, n2);
                    Date date = Date.valueOf(string.trim());
                    if (this.conn.getNlsCalendar().equals(BUDDHA_CALENDAR)) {
                        long l = date.getTime();
                        Date date2 = new Date(l);
                        int n4 = date2.getYear();
                        date2.setYear(n4 + 543);
                        date = new Date(date2.getTime());
                    }
                    return date;
                }
                case 5: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590750, n2);
                    }
                    Date date = this.toDateFromBytes(byArray, n, calendar);
                    if (this.conn.getNlsCalendar().equals(BUDDHA_CALENDAR)) {
                        long l = date.getTime();
                        Date date3 = new Date(l);
                        int n5 = date3.getYear();
                        date3.setYear(n5 + 543);
                        date = new Date(date3.getTime());
                    }
                    return date;
                }
                case 7: {
                    if (n2 != 12) {
                        throw TbError.newSQLException(-590751, n2);
                    }
                    Date date = this.toDateFromBytes(byArray, n, calendar);
                    if (this.conn.getNlsCalendar().equals(BUDDHA_CALENDAR)) {
                        long l = date.getTime();
                        Date date4 = new Date(l);
                        int n6 = date4.getYear();
                        date4.setYear(n6 + 543);
                        date = new Date(date4.getTime());
                    }
                    return date;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    private Date toDateFromBytes(byte[] byArray, int n, Calendar calendar) {
        if (calendar == null) {
            return this.toDateFromBytes(byArray, n);
        }
        int n2 = 0xFF & byArray[n];
        int n3 = 0xFF & byArray[n + 1];
        int n4 = 0xFF & byArray[n + 2];
        int n5 = 0xFF & byArray[n + 3];
        int n6 = 0xFF & byArray[n + 4];
        int n7 = 0xFF & byArray[n + 5];
        int n8 = 0xFF & byArray[n + 6];
        int n9 = (n2 - 100) * 100 + (n3 - 100);
        int n10 = n4 - 1;
        if (n9 < 0) {
            ++n9;
        }
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.set(n9, n10, n5, n6, n7, n8);
        calendar2.clear(14);
        return new Date(calendar2.getTimeInMillis());
    }

    private Date toDateFromBytes(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[n];
        int n3 = 0xFF & byArray[n + 1];
        int n4 = 0xFF & byArray[n + 2];
        int n5 = 0xFF & byArray[n + 3];
        int n6 = 0xFF & byArray[n + 4];
        int n7 = 0xFF & byArray[n + 5];
        int n8 = 0xFF & byArray[n + 6];
        int n9 = (n2 - 100) * 100 + (n3 - 100);
        int n10 = n4 - 1;
        if (n9 < 0) {
            ++n9;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n9, n10, n5, n6, n7, n8);
        calendar.clear(14);
        return new Date(calendar.getTimeInMillis());
    }

    public TbDate toTbDate(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 5: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590750, n2);
                    }
                    byte[] byArray2 = new byte[8];
                    System.arraycopy(byArray, n, byArray2, 0, 8);
                    TbDate tbDate = new TbDate(byArray2);
                    return tbDate;
                }
                case 7: {
                    if (n2 != 12) {
                        throw TbError.newSQLException(-590751, n2);
                    }
                    byte[] byArray3 = new byte[8];
                    System.arraycopy(byArray, n, byArray3, 0, 8);
                    TbDate tbDate = new TbDate(byArray3);
                    return tbDate;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public TbTime toTbTime(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 6: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590752, n2);
                    }
                    byte[] byArray2 = new byte[8];
                    System.arraycopy(byArray, n, byArray2, 0, 8);
                    TbTime tbTime = new TbTime(byArray2);
                    return tbTime;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public double toDouble(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return 0.0;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return Double.parseDouble(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0.0;
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String string = this.getDBDecodedNString(byArray, n, n2);
                        return Double.parseDouble(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0.0;
                    }
                }
                case 1: {
                    return TbNumber.toDouble(byArray, n, n2);
                }
                case 24: {
                    return TbNumber.toBinaryDouble(byArray, n, n2);
                }
                case 23: {
                    return TbNumber.toBinaryFloat(byArray, n, n2);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public float toFloat(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return 0.0f;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return Float.parseFloat(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0.0f;
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String string = this.getDBDecodedNString(byArray, n, n2);
                        return Float.parseFloat(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0.0f;
                    }
                }
                case 1: {
                    return (float)TbNumber.toDouble(byArray, n, n2);
                }
                case 24: {
                    return (float)TbNumber.toBinaryDouble(byArray, n, n2);
                }
                case 23: {
                    return TbNumber.toBinaryFloat(byArray, n, n2);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public int toInt(Object object, int n, int n2, int n3) throws SQLException {
        return this.toIntInternal(object, n, n2, n3);
    }

    public TbIntervalDts toIntervalDts(Object object, int n, int n2, int n3, int n4, int n5) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 9: {
                    byte[] byArray = new byte[n2];
                    System.arraycopy(object, n, byArray, 0, n2);
                    return new TbIntervalDts(byArray, n4, n5);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public TbIntervalYtm toIntervalYtm(Object object, int n, int n2, int n3, int n4) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 8: {
                    byte[] byArray = new byte[n2];
                    System.arraycopy(object, n, byArray, 0, n2);
                    return new TbIntervalYtm(byArray, n4);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public int toIntInternal(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return 0;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return TbCommon.bytes2Int(byArray, n, n2);
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return Integer.parseInt(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return TbCommon.bytes2Int(byArray, n, n2);
                    }
                }
                case 1: {
                    return TbNumber.toInteger(byArray, n, n2);
                }
                case 24: {
                    return (int)TbNumber.toBinaryDouble(byArray, n, n2);
                }
                case 23: {
                    return (int)TbNumber.toBinaryFloat(byArray, n, n2);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public long toLong(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return 0L;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    try {
                        String string = this.getDBDecodedString(byArray, n, n2);
                        return Long.parseLong(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return TbCommon.bytes2Long(byArray, n, n2);
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String string = this.getDBDecodedNString(byArray, n, n2);
                        return Long.parseLong(string.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        return TbCommon.bytes2Long(byArray, n, n2);
                    }
                }
                case 1: {
                    return TbNumber.toLong(byArray, n, n2);
                }
                case 24: {
                    return (long)TbNumber.toBinaryDouble(byArray, n, n2);
                }
                case 23: {
                    return (long)TbNumber.toBinaryFloat(byArray, n, n2);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toLongRawBytes(Object object, int n, int n2) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = new byte[n2];
            System.arraycopy(object, n, byArray, 0, n2);
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                return this.conn.getTbComm().readLongRaw(byArray);
            }
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toLongRawStream(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 10: 
                case 11: {
                    byte[] byArray2;
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, n, byArray3, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        byArray2 = this.conn.getTbComm().readLongRaw(byArray3);
                    }
                    return new ByteArrayInputStream(byArray2, 0, byArray2.length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toLongString(Object object, int n, int n2) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = new byte[n2];
            System.arraycopy(object, n, byArray, 0, n2);
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                return this.conn.getTbComm().readLong(byArray);
            }
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public NClob toNClob(Object object, int n, int n2, int n3) throws SQLException {
        return this.toTbNClob(object, n, n2, n3);
    }

    public TbNClob toTbNClob(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof TbNClob || object instanceof NClob) {
            return (TbNClob)object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 20: {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    return new TbNClob(this.conn, byArray2, false);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public TbNrowId toNrowId(Object object, int n, int n2) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            TbNrowId tbNrowId = new TbNrowId(this.conn);
            System.arraycopy(object, n, tbNrowId.nrowid, 0, 8);
            return tbNrowId;
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public Object toObject(Object object, int n, int n2, int n3, int n4, boolean bl) throws SQLException {
        return this.toObject(object, n, n2, n3, n4, -1, -1, bl, null, null, null, null);
    }

    public Object toObject(Object object, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, TbTypeDescriptor tbTypeDescriptor, Class<?> clazz, Map<String, Class<?>> map, Statement statement) throws SQLException {
        switch (n3) {
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                return this.toString(object, n, n2, n3, bl);
            }
            case 10: {
                return this.toLongString(object, n, n2);
            }
            case 11: {
                return this.toLongRawBytes(object, n, n2);
            }
            case 1: {
                BigDecimal bigDecimal = this.toBigDecimal(object, n, n2, n3);
                switch (n4) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Integer(bigDecimal.intValue());
                    }
                    case -5: {
                        return new Long(bigDecimal.longValue());
                    }
                    case 7: {
                        return new Float(bigDecimal.floatValue());
                    }
                    case 6: 
                    case 8: {
                        return new Double(bigDecimal.doubleValue());
                    }
                }
                return bigDecimal;
            }
            case 24: {
                return new Double(this.toDouble(object, n, n2, n3));
            }
            case 23: {
                return new Float(this.toFloat(object, n, n2, n3));
            }
            case 5: {
                switch (n4) {
                    case 91: {
                        return this.toDate(object, n, n2, n3);
                    }
                    case 93: {
                        return this.toTimestamp(object, n, n2, n3);
                    }
                    case 92: {
                        return this.toTime(object, n, n2, n3);
                    }
                }
                throw TbError.newSQLException(-590703, Integer.toString(n4));
            }
            case 6: {
                return this.toTime(object, n, n2, n3);
            }
            case 7: 
            case 21: 
            case 22: {
                return this.toTimestamp(object, n, n2, n3);
            }
            case 4: {
                return this.toBytes(object, n, n2, n3, bl);
            }
            case 15: {
                if (this.conn.getServerInfo().getServerIsNanobase() == 1) {
                    return this.toNrowId(object, n, n2);
                }
                return this.toRowId(object, n, n2, n3);
            }
            case 12: 
            case 34: {
                return this.toBlob(object, n, n2, n3, bl);
            }
            case 13: 
            case 20: {
                if (n4 == 2009) {
                    return this.toSQLXML(object, n, n2, n3, bl);
                }
                return this.toClob(object, n, n2, n3, bl);
            }
            case 9: {
                return this.toIntervalDts(object, n, n2, n3, n5, n6);
            }
            case 8: {
                return this.toIntervalYtm(object, n, n2, n3, n5);
            }
            case 29: 
            case 30: 
            case 31: {
                if (tbTypeDescriptor instanceof TbArrayDescriptor) {
                    return this.toArray(object, n, n2, n3, bl, (TbArrayDescriptor)tbTypeDescriptor, map);
                }
                if (n2 != 0) break;
                return null;
            }
            case 28: 
            case 32: {
                if (tbTypeDescriptor instanceof TbStructDescriptor) {
                    if (tbTypeDescriptor.getOID().compareTo("00000000000000000000000000000001") == 0 && clazz == null && (map == null || map.get(tbTypeDescriptor.getSQLTypeName()) == null)) {
                        return this.toStruct(object, n, n2, n3, bl, (TbStructDescriptor)tbTypeDescriptor, TbSQLXML.class, map);
                    }
                    if (tbTypeDescriptor.getOID().compareTo("0000000000000000000000000000000A") == 0) {
                        return new TbAnydata((Struct)this.toStruct(object, n, n2, n3, bl, (TbStructDescriptor)tbTypeDescriptor, clazz, map));
                    }
                    return this.toStruct(object, n, n2, n3, bl, (TbStructDescriptor)tbTypeDescriptor, clazz, map);
                }
                if (n2 != 0) break;
                return null;
            }
            case 16: {
                TbResultSet tbResultSet = this.toResultSet(object, n, 4, (TbStatement)statement);
                return tbResultSet;
            }
            case 33: {
                return this.toRef(object, n, n2, n3);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(n3));
    }

    static short swap(short s) {
        return (short)(s << 8 | s >> 8 & 0xFF);
    }

    static int swap(int n) {
        return DataTypeConverter.swap((short)n) << 16 | DataTypeConverter.swap((short)(n >> 16)) & 0xFFFF;
    }

    int fromByteArray(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbResultSet toResultSet(Object object, int n, int n2, TbStatement tbStatement) throws SQLException {
        TbResultSet tbResultSet;
        int n3 = TbCommon.bytes2Int((byte[])object, n, n2);
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            tbResultSet = this.conn.getTbComm().describeCSRReply(tbStatement, n3);
        }
        return tbResultSet;
    }

    public TbResultSet toResultSet(int n, int n2, int n3, TbColumnDesc[] tbColumnDescArray, TbStatement tbStatement, byte[] byArray) throws SQLException {
        int n4 = n - n2;
        TbResultSet tbResultSet = TbResultSetFactory.buildResultSet(tbStatement, n3, n4, n2, byArray);
        this.buildColumnMetadata(tbColumnDescArray, tbResultSet, n);
        tbResultSet.setFetchCompleted(0);
        return tbResultSet;
    }

    public TbResultSet toResultSet(TbStatement tbStatement, byte[] byArray, BindItem bindItem) throws SQLException {
        int n = bindItem.getLength();
        int n2 = TbCommon.bytes2Int(byArray, 0, n);
        TbColumnDesc[] tbColumnDescArray = bindItem.getColMeta();
        if (n2 == -1) {
            return null;
        }
        if (tbColumnDescArray == null) {
            throw TbError.newSQLException(-90644);
        }
        TbResultSet tbResultSet = TbResultSetFactory.buildResultSet(tbStatement, n2, tbColumnDescArray.length, 0, null);
        this.buildColumnMetadata(tbColumnDescArray, tbResultSet, tbColumnDescArray.length);
        tbResultSet.setFetchCompleted(0);
        return tbResultSet;
    }

    public TbRowId toRowId(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 15: {
                    TbRowId tbRowId = new TbRowId();
                    tbRowId.fromBytes(this.conn.getServerInfo().getServerEndian(), (byte[])object, n);
                    return tbRowId;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public short toShort(Object object, int n, int n2, int n3) throws SQLException {
        int n4 = this.toIntInternal(object, n, n2, n3);
        if (n4 > Short.MAX_VALUE || n4 < Short.MIN_VALUE) {
            throw TbError.newSQLException(-590749, n4);
        }
        return (short)n4;
    }

    public SQLXML toSQLXML(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 13: {
                    byte[] byArray = new byte[n2];
                    System.arraycopy(object, n, byArray, 0, n2);
                    TbClob tbClob = new TbClob(this.conn, byArray, bl);
                    TbXMLInputStream tbXMLInputStream = new TbXMLInputStream(tbClob);
                    return new TbSQLXML(this.conn, tbXMLInputStream);
                }
                case 28: 
                case 32: {
                    Object object2 = this.conn.getDescriptor("/O00000000000000000000000000000001");
                    Object object3 = null;
                    if (object2 instanceof TbStructDescriptor) {
                        object3 = this.toStruct(object, n, n2, n3, bl, (TbStructDescriptor)object2, null, null);
                    }
                    Object object4 = null;
                    if (object3 instanceof TbStruct && ((TbStruct)object3).getNumOfFields() > 1) {
                        object4 = ((TbStruct)object3).getAttributes()[0];
                    }
                    if (!(object4 instanceof TbClob)) break;
                    TbXMLInputStream tbXMLInputStream = new TbXMLInputStream((TbClob)object4);
                    return new TbSQLXML(this.conn, tbXMLInputStream);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public String toString(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        return this.toString(object, n, n2, n3, -1, -1, bl);
    }

    public String toString(Object object, int n, int n2, int n3, int n4, int n5, boolean bl) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    return this.getDBDecodedString(byArray, n, n2);
                }
                case 18: 
                case 19: {
                    return this.getDBDecodedNString(byArray, n, n2);
                }
                case 4: {
                    return TbCommon.bytes2String(byArray, n, n2);
                }
                case 13: {
                    Clob clob = this.toClob(object, n, n2, n3, bl);
                    String string = clob.getSubString(1L, (int)clob.length());
                    if (((TbLob)((Object)clob)).getIsTempLob() && bl) {
                        ((TbLob)((Object)clob)).free();
                    }
                    return string;
                }
                case 20: {
                    TbNClob tbNClob = (TbNClob)this.toClob(object, n, n2, n3, bl);
                    String string = tbNClob.getSubString(1L, (int)tbNClob.length());
                    if (tbNClob.getIsTempLob() && bl) {
                        tbNClob.free();
                    }
                    return string;
                }
                case 12: {
                    Blob blob = this.toBlob(object, n, n2, n3, bl);
                    byte[] byArray2 = blob.getBytes(1L, (int)blob.length());
                    if (((TbLob)((Object)blob)).getIsTempLob() && bl) {
                        ((TbLob)((Object)blob)).free();
                    }
                    return TbCommon.bytes2String(byArray2, 0, byArray2.length);
                }
                case 34: {
                    Blob blob = this.toBlob(object, n, n2, n3, bl);
                    byte[] byArray3 = blob.getBytes(1L, (int)blob.length());
                    if (((TbLob)((Object)blob)).getIsTempLob() && bl) {
                        ((TbLob)((Object)blob)).free();
                    }
                    try {
                        return new String(byArray3, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw TbError.newSQLException(-590714);
                    }
                }
                case 10: {
                    return this.toLongString(object, n, n2);
                }
                case 11: {
                    byte[] byArray4 = this.toLongRawBytes(object, n, n2);
                    return TbCommon.bytes2String(byArray4, 0, byArray4.length);
                }
                case 1: {
                    return TbNumber.getNormalForm(byArray, n, n2);
                }
                case 24: {
                    return Double.toString(this.toDouble(object, n, n2, n3));
                }
                case 23: {
                    return Float.toString(this.toFloat(object, n, n2, n3));
                }
                case 5: {
                    TbDate tbDate = this.toTbDate(object, n, n2, n3);
                    if (tbDate == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsDateFormat(), tbDate, n5);
                    }
                    return tbDate.toString();
                }
                case 6: {
                    TbTime tbTime = this.toTbTime(object, n, n2, n3);
                    if (tbTime == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsTimeFormat(), tbTime, n5);
                    }
                    return tbTime.toString();
                }
                case 7: {
                    TbTimestamp tbTimestamp = this.toTbTimestamp(object, n, n2, n3);
                    if (tbTimestamp == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsTimestampFormat(), tbTimestamp, n5);
                    }
                    return tbTimestamp.toString();
                }
                case 21: {
                    TimeZone timeZone = this.toTimeZoneFromBytes(byArray, n, n2);
                    TbTimestamp tbTimestamp = this.getTbTimestampTZFromBytes(byArray, n, n2, timeZone);
                    if (tbTimestamp == null) {
                        return null;
                    }
                    String string = timeZone.getID();
                    if (this.getTimeZoneIdFromBytes(byArray, n, n2) == ZoneInfo.TZ_ID_OFFSET.getId().intValue() && string.startsWith("GMT")) {
                        string = string.substring("GMT".length());
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        String string2 = TbDTFormatter.format(this.conn.getParsedNlsTimestampTZFormat(), tbTimestamp, n5);
                        Date date = this.toDateFromBytes(byArray, n, null);
                        return this.getTbTimestampTZFmtString(string2, date, timeZone, string);
                    }
                    return tbTimestamp.toString() + " " + string;
                }
                case 22: {
                    TimeZone timeZone = TimeZone.getDefault();
                    TbTimestamp tbTimestamp = this.getTbTimestampLTZFromBytes(byArray, n, n2, timeZone);
                    if (tbTimestamp == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsTimestampFormat(), tbTimestamp, n5);
                    }
                    return tbTimestamp.toString();
                }
            }
            Object object2 = this.toObject(object, n, n2, n3, DataType.getSqlType(n3, 0, this.conn.getMapDateToTimestamp()), n4, n5, bl, null, null, null, null);
            return object2 == null ? null : object2.toString();
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public Time toTime(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    String string = this.getDBDecodedString(byArray, n, n2);
                    return Time.valueOf(string.trim());
                }
                case 18: 
                case 19: {
                    String string = this.getDBDecodedNString(byArray, n, n2);
                    return Time.valueOf(string.trim());
                }
                case 5: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590750, n2);
                    }
                    return this.toTimeFromDate(byArray, n);
                }
                case 6: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590752, n2);
                    }
                    return this.toTimeFromBytes(byArray, n);
                }
                case 7: {
                    if (n2 != 12) {
                        throw TbError.newSQLException(-590751, n2);
                    }
                    return this.toTimeFromTimestamp(byArray, n);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    private Time toTimeFromBytes(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[n];
        int n3 = 0xFF & byArray[n + 1];
        int n4 = 0xFF & byArray[n + 2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n2, n3, n4);
        calendar.clear(14);
        return new Time(calendar.getTimeInMillis());
    }

    private Time toTimeFromDate(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[n + 4];
        int n3 = 0xFF & byArray[n + 5];
        int n4 = 0xFF & byArray[n + 6];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n2, n3, n4);
        calendar.clear(14);
        return new Time(calendar.getTimeInMillis());
    }

    private Time toTimeFromTimestamp(byte[] byArray, int n) {
        int n2 = 0xFF & byArray[n + 4];
        int n3 = 0xFF & byArray[n + 5];
        int n4 = 0xFF & byArray[n + 6];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n2, n3, n4);
        calendar.clear(14);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        return new Time(timestamp.getTime());
    }

    public Timestamp toTimestamp(Object object, int n, int n2, int n3) throws SQLException {
        return this.toTimestamp(object, n, n2, n3, null);
    }

    public Timestamp toTimestamp(Object object, int n, int n2, int n3, Calendar calendar) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 2: 
                case 3: {
                    String string = this.getDBDecodedString(byArray, n, n2);
                    return Timestamp.valueOf(string.trim());
                }
                case 18: 
                case 19: {
                    String string = this.getDBDecodedNString(byArray, n, n2);
                    return Timestamp.valueOf(string.trim());
                }
                case 5: {
                    return this.toTimestampFromDate(byArray, n, n2);
                }
                case 6: {
                    return this.toTimestampFromTime(byArray, n, n2);
                }
                case 7: {
                    if (calendar == null) {
                        return this.toTimestampFromBytes(byArray, n, n2);
                    }
                    return this.toTimestampFromBytes(byArray, n, n2, calendar);
                }
                case 21: {
                    return this.toTimestampTZFromBytes(byArray, n, n2);
                }
                case 22: {
                    return this.toTimestampLTZFromBytes(byArray, n, n2);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public TbTimestamp toTbTimestamp(Object object, int n, int n2, int n3) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            switch (n3) {
                case 5: {
                    if (n2 != 8) {
                        throw TbError.newSQLException(-590750, n2);
                    }
                    byte[] byArray2 = new byte[12];
                    System.arraycopy(byArray, n, byArray2, 0, 8);
                    for (int i = 8; i < byArray2.length; ++i) {
                        byArray2[i] = 0;
                    }
                    TbTimestamp tbTimestamp = new TbTimestamp(byArray2);
                    return tbTimestamp;
                }
                case 7: {
                    if (n2 != 12) {
                        throw TbError.newSQLException(-590751, n2);
                    }
                    byte[] byArray3 = new byte[12];
                    System.arraycopy(byArray, n, byArray3, 0, 12);
                    TbTimestamp tbTimestamp = new TbTimestamp(byArray3);
                    return tbTimestamp;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    private Timestamp toTimestampFromBytes(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 12) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        if (n10 < 0) {
            ++n10;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n10, n11, n6, n7, n8, n9);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n12);
        return timestamp;
    }

    private Timestamp toTimestampFromBytes(byte[] byArray, int n, int n2, Calendar calendar) throws SQLException {
        if (n2 != 12) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        if (n10 < 0) {
            ++n10;
        }
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.set(n10, n11, n6, n7, n8, n9);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(n12);
        return timestamp;
    }

    private Timestamp toTimestampFromTime(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 8) {
            throw TbError.newSQLException(-590752, n2);
        }
        int n3 = 0xFF & byArray[n];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = TbCommon.bytes2Int(byArray, n + 4, 4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n3, n4, n5);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n6);
        return timestamp;
    }

    private Timestamp toTimestampFromDate(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 8) {
            throw TbError.newSQLException(-590750, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = 0;
        if (n10 < 0) {
            ++n10;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n10, n11, n6, n7, n8, n9);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n12);
        return timestamp;
    }

    private int getTimeZoneIdFromBytes(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 17) {
            throw TbError.newSQLException(-590751, n2);
        }
        return TbCommon.bytes2Int(byArray, n + 15, 2);
    }

    public TimeZone toTimeZoneFromBytes(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 17) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = TbCommon.bytes2Int(byArray, n + 15, 2);
        if (n3 == ZoneInfo.TZ_ID_OFFSET.getId()) {
            int n4 = (0xFF & byArray[n + 12]) - 100;
            int n5 = 0xFF & byArray[n + 13];
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumIntegerDigits(2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("GMT");
            if (n4 >= 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(numberFormat.format(n4));
            stringBuffer.append(":");
            stringBuffer.append(numberFormat.format(n5));
            return TimeZone.getTimeZone(stringBuffer.toString());
        }
        String string = ZoneInfo.getZoneNameById(n3);
        return TimeZone.getTimeZone(string);
    }

    private String getTbTimestampTZFmtString(String string, Date date, TimeZone timeZone, String string2) {
        String string3 = string.replaceAll("TZR", string2);
        if (Pattern.matches("(.*)TZH(.*)", string3) || Pattern.matches("(.*)TZM(.*)", string3)) {
            int n = timeZone.getOffset(date.getTime());
            boolean bl = true;
            if (n < 0) {
                n = Math.abs(n);
                bl = false;
            }
            int n2 = n / 3600000;
            int n3 = n % 3600000 / 60000;
            String string4 = String.valueOf(n2);
            if (string4.length() < 2) {
                string4 = "0" + string4;
                string4 = bl ? "+" + string4 : "-" + string4;
            }
            string3 = string3.replaceAll("TZH", string4);
            String string5 = String.valueOf(n3);
            if (string5.length() < 2) {
                string5 = "0" + string5;
            }
            string3 = string3.replaceAll("TZM", string5);
        }
        string3 = string3.replaceAll("TZD", "");
        return string3;
    }

    private TbTimestamp getTbTimestampTZFromBytes(byte[] byArray, int n, int n2, TimeZone timeZone) throws SQLException {
        if (n2 != 17) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        if (n10 < 0) {
            ++n10;
        }
        calendar.set(n10, n11, n6, n7, n8, n9);
        calendar.clear(14);
        long l = calendar.getTimeInMillis();
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(l);
        TbTimestamp tbTimestamp = new TbTimestamp(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), n12);
        return tbTimestamp;
    }

    private TbTimestamp getTbTimestampLTZFromBytes(byte[] byArray, int n, int n2, TimeZone timeZone) throws SQLException {
        if (n2 != 12) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        if (n10 < 0) {
            ++n10;
        }
        calendar.set(n10, n11, n6, n7, n8, n9);
        calendar.clear(14);
        long l = calendar.getTimeInMillis();
        calendar.setTimeZone(timeZone);
        calendar.setTimeInMillis(l);
        byArray = new byte[12];
        int n13 = calendar.get(1);
        byArray[0] = (byte)(n13 / 100 + 100);
        byArray[1] = (byte)(n13 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)calendar.get(11);
        byArray[5] = (byte)calendar.get(12);
        byArray[6] = (byte)calendar.get(13);
        byArray[7] = 0;
        TbCommon.int2Bytes(n12, byArray, 8, 4);
        TbTimestamp tbTimestamp = new TbTimestamp(byArray);
        return tbTimestamp;
    }

    private Timestamp toTimestampTZFromBytes(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 17) {
            throw TbError.newSQLException(-590751, n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        if (n10 < 0) {
            ++n10;
        }
        calendar.set(n10, n11, n6, n7, n8, n9);
        calendar.clear(14);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n12);
        return timestamp;
    }

    private Timestamp toTimestampLTZFromBytes(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 != 12) {
            throw TbError.newSQLException(-590751, "" + n2);
        }
        int n3 = 0xFF & byArray[n + 0];
        int n4 = 0xFF & byArray[n + 1];
        int n5 = 0xFF & byArray[n + 2];
        int n6 = 0xFF & byArray[n + 3];
        int n7 = 0xFF & byArray[n + 4];
        int n8 = 0xFF & byArray[n + 5];
        int n9 = 0xFF & byArray[n + 6];
        int n10 = (n3 - 100) * 100 + (n4 - 100);
        int n11 = n5 - 1;
        int n12 = TbCommon.bytes2Int(byArray, n + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        if (n10 < 0) {
            ++n10;
        }
        calendar.set(n10, n11, n6, n7, n8, n9);
        long l = calendar.getTimeInMillis();
        calendar.setTimeInMillis(l);
        calendar.clear(14);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n12);
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toUnicodeStream(Object object, int n, int n2, int n3, boolean bl) throws SQLException {
        if (n2 <= 0 || object == null) {
            return null;
        }
        if (DataType.isCharacterCategory(n3)) {
            String string = this.toString(object, n, n2, n3, bl);
            return new ByteArrayInputStream(string.getBytes());
        }
        if (object instanceof byte[]) {
            switch (n3) {
                case 10: {
                    String string;
                    byte[] byArray = new byte[n2];
                    System.arraycopy(object, n, byArray, 0, n2);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        string = this.conn.getTbComm().readLong(byArray);
                    }
                    return new ByteArrayInputStream(string.getBytes());
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(n3));
        }
        throw TbError.newSQLException(-90612, object.toString());
    }

    public static String tbBase64Encode(byte[] byArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < byArray.length - 2; n += 3) {
            stringBuilder.append(DataTypeConverter.encode(byArray[n] >> 2 & 0x3F));
            stringBuilder.append(DataTypeConverter.encode((byArray[n] & 3) << 4 | (byArray[n + 1] & 0xF0) >> 4));
            stringBuilder.append(DataTypeConverter.encode((byArray[n + 1] & 0xF) << 2 | (byArray[n + 2] & 0xC0) >> 6));
            stringBuilder.append(DataTypeConverter.encode(byArray[n + 2] & 0x3F));
        }
        if (n < byArray.length) {
            stringBuilder.append(DataTypeConverter.encode(byArray[n] >> 2 & 0x3F));
            if (n == byArray.length - 1) {
                stringBuilder.append(DataTypeConverter.encode((byArray[n] & 3) << 4));
                stringBuilder.append('=');
            } else {
                stringBuilder.append(DataTypeConverter.encode((byArray[n] & 3) << 4 | (byArray[n + 1] & 0xF0) >> 4));
                stringBuilder.append(DataTypeConverter.encode((byArray[n + 1] & 0xF) << 2));
            }
            stringBuilder.append('=');
        }
        return stringBuilder.toString();
    }

    private static char encode(int n) {
        char[] cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        return cArray[n];
    }

    public static byte[] tbBase64Decode(byte[] byArray) {
        int n = 0;
        while (n < byArray.length && pr2six[byArray[n++]] <= 63) {
        }
        int n2 = n - 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        n = 0;
        while (n2 > 4) {
            byteArrayOutputStream.write(pr2six[byArray[n]] << 2 | pr2six[byArray[n + 1]] >> 4);
            byteArrayOutputStream.write(pr2six[byArray[n + 1]] << 4 | pr2six[byArray[n + 2]] >> 2);
            byteArrayOutputStream.write(pr2six[byArray[n + 2]] << 6 | pr2six[byArray[n + 3]]);
            n += 4;
            n2 -= 4;
        }
        if (n2 > 1) {
            byteArrayOutputStream.write(pr2six[byArray[n]] << 2 | pr2six[byArray[n + 1]] >> 4);
        }
        if (n2 > 2) {
            byteArrayOutputStream.write(pr2six[byArray[n + 1]] << 4 | pr2six[byArray[n + 2]] >> 2);
        }
        if (n2 > 3) {
            byteArrayOutputStream.write(pr2six[byArray[n + 2]] << 6 | pr2six[byArray[n + 3]]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] base64Decode2(String string) throws Exception {
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        byte[] byArray = string.getBytes("ASCII");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            if (nArray[byArray[n]] == -1) {
                ++n;
                continue;
            }
            n2 = (nArray[byArray[n]] & 0xFF) << 18;
            int n3 = 0;
            if (n + 1 < byArray.length && nArray[byArray[n + 1]] != -1) {
                n2 |= (nArray[byArray[n + 1]] & 0xFF) << 12;
                ++n3;
            }
            if (n + 2 < byArray.length && nArray[byArray[n + 2]] != -1) {
                n2 |= (nArray[byArray[n + 2]] & 0xFF) << 6;
                ++n3;
            }
            if (n + 3 < byArray.length && nArray[byArray[n + 3]] != -1) {
                n2 |= nArray[byArray[n + 3]] & 0xFF;
                ++n3;
            }
            while (n3 > 0) {
                int n4 = (n2 & 0xFF0000) >> 16;
                byteArrayOutputStream.write((char)n4);
                n2 <<= 8;
                --n3;
            }
            n += 4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] base64Decode(byte[] byArray) throws Exception {
        int n = 0;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block5: for (int i = 0; i < byArray.length; ++i) {
            byte by = d[byArray[i]];
            switch (by) {
                case 64: {
                    continue block5;
                }
                case 66: {
                    return null;
                }
                case 65: {
                    continue block5;
                }
                default: {
                    n = n << 6 | by;
                    if (++n2 != 4) continue block5;
                    byteArrayOutputStream.write((byte)(n >> 16 & 0xFF));
                    byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
                    byteArrayOutputStream.write((byte)(n & 0xFF));
                    n = 0;
                    n2 = 0;
                }
            }
        }
        if (n2 == 3) {
            byteArrayOutputStream.write((byte)(n >> 10 & 0xFF));
            byteArrayOutputStream.write((byte)(n >> 2 & 0xFF));
        } else if (n2 == 2) {
            byteArrayOutputStream.write((byte)(n >> 4 & 0xFF));
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        pr2six = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        d = new byte[]{66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 64, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 62, 66, 66, 66, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 66, 66, 66, 65, 66, 66, 66, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 66, 66, 66, 66, 66, 66, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66};
    }

    class ObjInstBldCtx {
        TbStructDescriptor desc;
        Object[] values;
        int attrProcessed;

        ObjInstBldCtx(TbStructDescriptor tbStructDescriptor) {
            this.desc = tbStructDescriptor;
            this.values = new Object[tbStructDescriptor.getNumOfFields()];
            this.attrProcessed = 0;
        }
    }
}

