/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.RowId;
import java.sql.SQLException;

public class TbRowId
implements RowId {
    private static final int ROWID_SGMT_BYTE_CNT = 4;
    private static final int ROWID_BLOCK_BYTE_CNT = 4;
    private static final int ROWID_FILE_BYTE_CNT = 2;
    private static final int ROWID_ROW_BYTE_CNT = 2;
    private static final byte[] rowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int ROWID_DIVISION_SHIFT = 6;
    private static final int ROWID_REMAINDER_BIT = 63;
    private static final int ROWID_SGMT_LEN = 6;
    private static final int ROWID_FILE_LEN = 3;
    private static final int ROWID_BLOCK_LEN = 6;
    private static final int ROWID_ROW_LEN = 3;
    private static final int ROWID_SGMT_LAST = 5;
    private static final int ROWID_FILE_LAST = 8;
    private static final int ROWID_BLOCK_LAST = 14;
    private static final int ROWID_ROW_LAST = 17;
    private static final int ROWID_BYTE_CNT = 12;
    private static final long ROWID_SGMT_MAX = 0xFFFFFFFFL;
    private static final long ROWID_BLOCK_MAX = 0xFFFFFFFFL;
    private static final int ROWID_FILE_MAX = 65535;
    private static final int ROWID_ROW_MAX = 65535;
    private static final int ROWID_LEN = 18;
    private long sgmt;
    private long block;
    private int file;
    private int row;
    private byte[] erowid = new byte[12];

    private int convSingleRowId(byte by) {
        return 65 <= by && by <= 90 ? by - 65 + 0 : (97 <= by && by <= 122 ? by - 97 + 26 : (48 <= by && by <= 57 ? by - 48 + 52 : (43 == by ? 62 : (47 == by ? 63 : -1))));
    }

    public void fromBytes(int n, byte[] byArray, int n2) throws SQLException {
        this.setRowIdFields(0L, 0L, 0, 0);
        if (n == 1) {
            this.sgmt = TbCommon.bytes2Long(byArray, n2, 4);
            this.block = TbCommon.bytes2Long(byArray, n2 += 4, 4);
            this.file = TbCommon.bytes2Int(byArray, n2 += 4, 2);
            this.row = TbCommon.bytes2Int(byArray, n2 += 2, 2);
        } else if (n == 0) {
            this.sgmt = TbCommon.bytes2LongR(byArray, n2, 4);
            this.block = TbCommon.bytes2LongR(byArray, n2 += 4, 4);
            this.file = TbCommon.bytes2IntR(byArray, n2 += 4, 2);
            this.row = TbCommon.bytes2IntR(byArray, n2 += 2, 2);
        }
        if (n == 1) {
            TbCommon.long2Bytes(this.sgmt, this.erowid, 0, 4);
            TbCommon.long2Bytes(this.block, this.erowid, 4, 4);
            TbCommon.int2Bytes(this.file, this.erowid, 8, 2);
            TbCommon.int2Bytes(this.row, this.erowid, 10, 2);
        } else {
            TbCommon.long2BytesR(this.sgmt, this.erowid, 0, 4);
            TbCommon.long2BytesR(this.block, this.erowid, 4, 4);
            TbCommon.int2BytesR(this.file, this.erowid, 8, 2);
            TbCommon.int2BytesR(this.row, this.erowid, 10, 2);
        }
    }

    public int fromString(byte[] byArray, int n, int n2, String string) throws SQLException {
        int n3;
        byte[] byArray2 = string.getBytes();
        this.setRowIdFields(0L, 0L, 0, 0);
        long l = 1L;
        int n4 = 5;
        while (n4 >= 0) {
            n3 = this.convSingleRowId(byArray2[n4]);
            if (n3 < 0) {
                throw TbError.newSQLException(-590753, n3);
            }
            if (0xFFFFFFFFL - this.sgmt < l * (long)n3) {
                throw TbError.newSQLException(-590753, "4294967295 - " + this.sgmt + " < " + l + " * " + n3);
            }
            this.sgmt += l * (long)n3;
            n3 = this.convSingleRowId(byArray2[9 + n4]);
            if (n3 < 0) {
                throw TbError.newSQLException(-590753, n3);
            }
            if (0xFFFFFFFFL - this.block < l * (long)n3) {
                throw TbError.newSQLException(-590754, "4294967295 - " + this.block + " < " + l + " * " + n3);
            }
            this.block += l * (long)n3;
            --n4;
            l <<= 6;
        }
        int n5 = 1;
        n4 = 8;
        while (n4 > 5) {
            n3 = this.convSingleRowId(byArray2[n4]);
            if (n3 < 0) {
                throw TbError.newSQLException(-590753, n3);
            }
            if (65535 - this.file < n5 * n3) {
                throw TbError.newSQLException(-590755, "65535 - " + this.file + " < " + n5 + " * " + n3);
            }
            this.file += n5 * n3;
            n3 = this.convSingleRowId(byArray2[9 + n4]);
            if (n3 < 0) {
                throw TbError.newSQLException(-590753, n3);
            }
            if (65535 - this.row < n5 * n3) {
                throw TbError.newSQLException(-590757, "65535 - " + this.row + " < " + n5 + " * " + n3);
            }
            this.row += n5 * n3;
            --n4;
            n5 <<= 6;
        }
        if (n2 == 1) {
            TbCommon.long2Bytes(this.sgmt, byArray, n, 4);
            TbCommon.long2Bytes(this.block, byArray, n + 4, 4);
            TbCommon.int2Bytes(this.file, byArray, n + 8, 2);
            TbCommon.int2Bytes(this.row, byArray, n + 10, 2);
        } else {
            TbCommon.long2BytesR(this.sgmt, byArray, n, 4);
            TbCommon.long2BytesR(this.block, byArray, n + 4, 4);
            TbCommon.int2BytesR(this.file, byArray, n + 8, 2);
            TbCommon.int2BytesR(this.row, byArray, n + 10, 2);
        }
        return 12;
    }

    @Override
    public byte[] getBytes() {
        return this.erowid;
    }

    private void setRowIdFields(long l, long l2, int n, int n2) {
        this.sgmt = l;
        this.block = l2;
        this.file = n;
        this.row = n2;
    }

    @Override
    public String toString() {
        int n;
        byte[] byArray = new byte[18];
        long l = this.sgmt;
        long l2 = this.block;
        int n2 = this.file;
        int n3 = this.row;
        for (n = 5; n >= 0; --n) {
            byArray[n] = rowid_encoding[(int)l & 0x3F];
            l >>= 6;
            byArray[9 + n] = rowid_encoding[(int)l2 & 0x3F];
            l2 >>= 6;
        }
        for (n = 8; n > 5; --n) {
            byArray[n] = rowid_encoding[n2 & 0x3F];
            n2 >>= 6;
            byArray[9 + n] = rowid_encoding[n3 & 0x3F];
            n3 >>= 6;
        }
        return new String(byArray);
    }
}

