/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.ext.TbXAException;
import java.io.Serializable;
import javax.transaction.xa.Xid;

public class TbXid
implements Xid,
Serializable {
    private static final long serialVersionUID = 8653403137105513841L;
    public static int DATA_SIZE = 128;
    public static int SERIALIZED_SIZE = 24 + DATA_SIZE;
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    private volatile String xidAsString;

    public TbXid(int n, byte[] byArray, byte[] byArray2) throws TbXAException {
        if (byArray != null && byArray.length > 64) {
            throw new TbXAException(-4, "GTRID is null or greater than 64");
        }
        if (byArray2 != null && byArray2.length > 64) {
            throw new TbXAException(-4, "BQUAL is null or greater than 64");
        }
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        String string = this.xidAsString;
        if (string == null) {
            String string2;
            int n;
            StringBuilder stringBuilder = new StringBuilder(300);
            stringBuilder.append("TbXid@").append(this.hashCode()).append("[");
            if (this.gtrid != null) {
                for (n = 0; n < this.gtrid.length; ++n) {
                    string2 = Integer.toHexString(this.gtrid[n] & 0xFF);
                    if (string2.length() == 1) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append('.');
            if (this.bqual != null) {
                for (n = 0; n < this.bqual.length; ++n) {
                    string2 = Integer.toHexString(this.bqual[n] & 0xFF);
                    if (string2.length() == 1) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append('.');
            stringBuilder.append("0x").append(Integer.toHexString(this.formatId));
            stringBuilder.append("]");
            this.xidAsString = string = stringBuilder.toString();
        }
        return string;
    }
}

