/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DPLReaderBinder
extends DPLBinder {
    private final int EXTRA_DATA_LENGTH = 12;
    private final int DPL_CHUNK_SIZE = 1628000;
    private int length;
    private byte[] byteBuf = new byte[16384];
    private int offset;
    private int unReadBytes = 0;

    @Override
    public void bind(TbConnection tbConnection, TbDirPathStream tbDirPathStream, TbStreamDataWriter tbStreamDataWriter, int n, int n2) throws SQLException {
        DataTypeConverter dataTypeConverter = tbConnection.getTypeConverter();
        Reader reader = tbDirPathStream.getParamReader(n);
        StreamBuffer streamBuffer = tbStreamDataWriter.getStreamBuf();
        int n3 = tbDirPathStream.getDPLMetaData().getDataType(n + 1);
        char[] cArray = new char[4096];
        byte[] byArray = new byte[16384];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            if (streamBuffer.getRemained() <= 12) {
                tbDirPathStream.dirPathLoadStream(tbStreamDataWriter, 0);
            }
            tbStreamDataWriter.writeInt(0, 4);
            while (n2 >= 0) {
                n4 = n2 > 4096 ? 4096 : n2;
                n5 = reader.read(cArray, 0, n4);
                if (n5 <= 0) {
                    if (n7 > 0) {
                        tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - n7 - 4, n7, 4);
                        tbStreamDataWriter.writePaddingDPL(n7);
                    }
                    return;
                }
                n6 = n3 == 13 || n3 == 20 ? dataTypeConverter.charsToFixedBytes(cArray, 0, n5, byArray, 0, byArray.length) : dataTypeConverter.charsToBytes(cArray, 0, n5, byArray, 0, byArray.length);
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (true) {
                    if ((n10 = n6 - n8) > (n9 = streamBuffer.getRemained()) - 12 && n9 > 12) {
                        tbStreamDataWriter.writeBytes(byArray, n8, n9 -= 12);
                        n8 += n9;
                        tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - (n7 += n9) - 4, n7, 4);
                        tbStreamDataWriter.writePaddingDPL(n7);
                        tbDirPathStream.dirPathLoadStream(tbStreamDataWriter, 1);
                        n7 = 0;
                        tbStreamDataWriter.writeInt(0, 4);
                        continue;
                    }
                    if (n10 < 1628000 - n7 - 12) break;
                    n10 = 1628000 - n7 - 12;
                    tbStreamDataWriter.writeBytes(byArray, n8, n10);
                    n8 += n10;
                    tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - (n7 += n10) - 4, n7, 4);
                    tbStreamDataWriter.writePaddingDPL(n7);
                    tbDirPathStream.dirPathLoadStream(tbStreamDataWriter, 1);
                    n7 = 0;
                    tbStreamDataWriter.writeInt(0, 4);
                }
                tbStreamDataWriter.writeBytes(byArray, n8, n10);
                n7 += n10;
                n8 += n10;
                n2 -= n5;
            }
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
    }

    @Override
    public int bind(TbConnection tbConnection, TbDirPathStream tbDirPathStream, TbStreamDataWriter tbStreamDataWriter, int n, int n2, boolean bl) throws SQLException {
        DataTypeConverter dataTypeConverter = tbConnection.getTypeConverter();
        Reader reader = tbDirPathStream.getParamReader(n);
        StreamBuffer streamBuffer = tbStreamDataWriter.getStreamBuf();
        int n3 = tbDirPathStream.getDPLMetaData().getDataType(n + 1);
        char[] cArray = new char[4096];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!bl) {
            this.length = n2;
            this.offset = 0;
        }
        try {
            if (streamBuffer.getRemained() <= 12) {
                return 3;
            }
            tbStreamDataWriter.writeInt(0, 4);
            if (bl) {
                n7 = this.unReadBytes;
                tbStreamDataWriter.writeBytes(this.byteBuf, this.offset, n7);
            }
            while (this.length >= 0) {
                n4 = this.length > 4096 ? 4096 : this.length;
                n5 = reader.read(cArray, 0, n4);
                if (n5 <= 0) {
                    tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - n7 - 4, n7, 4);
                    tbStreamDataWriter.writePaddingDPL(n7);
                    return 0;
                }
                n6 = n3 == 13 || n3 == 20 ? dataTypeConverter.charsToFixedBytes(cArray, 0, n5, this.byteBuf, 0, this.byteBuf.length) : dataTypeConverter.charsToBytes(cArray, 0, n5, this.byteBuf, 0, this.byteBuf.length);
                int n8 = streamBuffer.getRemained();
                this.offset = 0;
                this.unReadBytes = n6;
                if (this.unReadBytes > n8 - 12) {
                    tbStreamDataWriter.writeBytes(this.byteBuf, this.offset, n8 -= 12);
                    this.offset = n8;
                    this.unReadBytes -= n8;
                    tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - (n7 += n8) - 4, n7, 4);
                    tbStreamDataWriter.writePaddingDPL(n7);
                    this.length -= n5;
                    return 1;
                }
                tbStreamDataWriter.writeBytes(this.byteBuf, this.offset, this.unReadBytes);
                n7 += this.unReadBytes;
                this.length -= n5;
            }
            tbStreamDataWriter.reWriteInt(streamBuffer.getCurDataSize() - n7 - 4, n7, 4);
            tbStreamDataWriter.writePaddingDPL(n7);
            return 0;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
    }

    @Override
    public void init() {
        this.length = 0;
        this.offset = 0;
        this.unReadBytes = 0;
    }
}

