/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbXAException;
import com.tmax.tibero.jdbc.ext.TbXid;
import com.tmax.tibero.jdbc.msg.TbMsgSend;
import com.tmax.tibero.jdbc.msg.TbMsgXaRecoverReply;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class TbXACommType4
extends TbCommType4
implements TbXAComm {
    public TbXACommType4(TbConnection tbConnection) {
        super(tbConnection);
    }

    private void deserializeXid(byte[] byArray, TbXid[] tbXidArray) throws TbXAException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        int n5 = tbXidArray.length;
        for (int i = 0; i < n5; ++i) {
            n2 = TbCommon.bytes2Int(byArray, n, 8);
            n3 = TbCommon.bytes2Int(byArray, n += 8, 8);
            byArray2 = new byte[n3];
            n4 = TbCommon.bytes2Int(byArray, n += 8, 8);
            byArray3 = new byte[n4];
            System.arraycopy(byArray, n += 8, byArray2, 0, n3);
            System.arraycopy(byArray, n += n3, byArray3, 0, n4);
            n += n4;
            n += TbXid.SERIALIZED_SIZE - 24 - n3 - n4;
            tbXidArray[i] = new TbXid(n2, byArray2, byArray3);
        }
    }

    private void doXAErrorReply(int n, TbMsg tbMsg) throws TbXAException, SQLException {
        SQLException sQLException = this.getErrorMessage(n, tbMsg);
        throw this.processException(sQLException);
    }

    private int doXAForgetErrorReply(TbMsg tbMsg) throws TbXAException {
        int n = -3;
        try {
            SQLException sQLException = this.getErrorMessage(-90542, tbMsg);
            n = this.mappingXAErrorCode(sQLException.getErrorCode());
            if (n != 3 && n != -4) {
                throw new TbXAException(n, sQLException.getMessage());
            }
        }
        catch (SQLException sQLException) {
            this.processException(sQLException);
        }
        return n;
    }

    private int doXAPrepareErrorReply(TbMsg tbMsg) throws TbXAException {
        int n = -3;
        try {
            SQLException sQLException = this.getErrorMessage(-90529, tbMsg);
            n = this.mappingXAErrorCode(sQLException.getErrorCode());
            if (n != 3 && n != -4) {
                throw new TbXAException(n, sQLException.getMessage());
            }
        }
        catch (SQLException sQLException) {
            this.processException(sQLException);
        }
        return n;
    }

    private Xid[] doXARecoverOK(TbMsgXaRecoverReply tbMsgXaRecoverReply) throws TbXAException {
        try {
            int n = tbMsgXaRecoverReply.xidCount;
            Xid[] xidArray = new TbXid[n];
            byte[] byArray = tbMsgXaRecoverReply.xids;
            int n2 = byArray.length;
            if (n2 != n * TbXid.SERIALIZED_SIZE) {
                throw TbError.newSQLException(-590730);
            }
            if (n > 0) {
                this.deserializeXid(byArray, (TbXid[])xidArray);
            }
            return xidArray;
        }
        catch (SQLException sQLException) {
            throw this.processException(sQLException);
        }
    }

    private int mappingXAErrorCode(int n) {
        switch (n) {
            case -25001: {
                return -6;
            }
            case -25005: {
                return -5;
            }
            case -25002: {
                return -4;
            }
            case -25007: {
                return 3;
            }
            case -25008: {
                return -8;
            }
            case -25010: {
                return 7;
            }
            case -25011: {
                return 6;
            }
            case -25012: {
                return 5;
            }
            case -25009: {
                return -3;
            }
            case -25003: {
                return -9;
            }
            case -25004: {
                return -2;
            }
            case -25006: {
                return 100;
            }
            case -25013: {
                return 4;
            }
        }
        if (n <= -90400 && n > -90500) {
            return -7;
        }
        return -3;
    }

    private TbXAException processException(SQLException sQLException) {
        int n = sQLException.getErrorCode();
        TbXAException tbXAException = new TbXAException(this.mappingXAErrorCode(n), sQLException.getMessage());
        tbXAException.initCause(sQLException);
        return tbXAException;
    }

    private void serializeXid(Xid xid, byte[] byArray) {
        int n = 0;
        int n2 = xid.getFormatId();
        byte[] byArray2 = xid.getGlobalTransactionId();
        byte[] byArray3 = xid.getBranchQualifier();
        int n3 = byArray2.length + byArray3.length;
        TbCommon.long2Bytes(n2, byArray, n, 8);
        TbCommon.long2Bytes(byArray2.length, byArray, n += 8, 8);
        TbCommon.long2Bytes(byArray3.length, byArray, n += 8, 8);
        System.arraycopy(byArray2, 0, byArray, n += 8, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, n += byArray2.length, byArray3.length);
        n += byArray3.length;
        if (n3 < TbXid.DATA_SIZE) {
            for (int i = 0; i < TbXid.DATA_SIZE - n3; ++i) {
                byArray[n] = 0;
            }
        }
    }

    @Override
    public void xaCommit(Xid xid, boolean bl) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        int n = bl ? 0x40000000 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 4, n, byArray, byArray.length, 0);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90530, tbMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public void xaEnd(Xid xid, int n) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 1, n, byArray, byArray.length, 0);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90528, tbMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public int xaForget(Xid xid) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 5, 0, byArray, byArray.length, 0);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return 0;
                    }
                    case 76: {
                        return this.doXAForgetErrorReply(tbMsg);
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public void xaOpen() throws SQLException {
        TbMsg tbMsg = null;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.XA_OPEN(this.stream, 0, 500, 60, 0);
            tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    return;
                }
            }
            throw TbError.newSQLException(-90402, tbMsg.getMsgType());
        }
    }

    @Override
    public int xaPrepare(Xid xid) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 3, 0, byArray, byArray.length, 0);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return 0;
                    }
                    case 76: {
                        return this.doXAPrepareErrorReply(tbMsg);
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public Xid[] xaRecover(int n) throws TbXAException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA_RECOVER(this.stream);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 70: {
                        return this.doXARecoverOK((TbMsgXaRecoverReply)tbMsg);
                    }
                    case 76: {
                        this.doXAErrorReply(-90532, tbMsg);
                        return null;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public void xaRollback(Xid xid) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 2, 0, byArray, byArray.length, 0);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90531, tbMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }

    @Override
    public void xaStart(Xid xid, int n) throws TbXAException {
        byte[] byArray = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, byArray);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 0, n & 0xFFFEFFFF, byArray, byArray.length, n & 0x10000);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90527, tbMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + tbMsg.getMsgType());
            }
            catch (SQLException sQLException) {
                throw this.processException(sQLException);
            }
        }
    }
}

