/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbRef;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbStruct
implements Struct {
    private TbStructDescriptor descriptor;
    private TbConnection conn;
    private Object[] attributes;
    private Params subParams;

    public TbStruct(TbStructDescriptor tbStructDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (tbStructDescriptor == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (connection == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = tbStructDescriptor;
        this.conn = (TbConnection)connection;
        this.attributes = objectArray;
        int n = tbStructDescriptor.getNumOfFields();
        int[] nArray = tbStructDescriptor.getAttributeTypes();
        this.subParams = new Params();
        this.initSubParams(n, nArray, objectArray);
    }

    private void initSubParams(int n, int[] nArray, Object[] objectArray) throws SQLException {
        int n2 = objectArray == null ? 0 : objectArray.length;
        Params.access$002(this.subParams, new Binder[n]);
        this.subParams.bindData = new BindData(n);
        block20: for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) {
                ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                continue;
            }
            switch (nArray[i]) {
                case 1: {
                    if (this.subParams.paramBigDecimal == null) {
                        Params.access$202(this.subParams, new BigDecimal[n]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                    if (objectArray[i] instanceof Short) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Short)objectArray[i]).intValue());
                    } else if (objectArray[i] instanceof Integer) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Integer)objectArray[i]);
                    } else if (objectArray[i] instanceof Long) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Long)objectArray[i]);
                    } else if (objectArray[i] instanceof BigInteger) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((BigInteger)objectArray[i]);
                    } else if (objectArray[i] instanceof BigDecimal) {
                        ((Params)this.subParams).paramBigDecimal[i] = (BigDecimal)objectArray[i];
                    } else if (objectArray[i] instanceof Float) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Float)objectArray[i]).floatValue());
                    } else if (objectArray[i] instanceof Double) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Double)objectArray[i]);
                    } else if (objectArray[i] instanceof String) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((String)objectArray[i]);
                    } else if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Boolean)objectArray[i] != false ? 1.0 : 0.0);
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 2: 
                case 3: 
                case 10: {
                    byte[] byArray;
                    int n3;
                    Object object2;
                    if (this.subParams.paramString == null) {
                        Params.access$302(this.subParams, new String[n]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStringBinder();
                    if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                    } else if (objectArray[i] instanceof Reader) {
                        int n4 = this.conn.getMaxDFRCharCount() + 1;
                        object2 = new char[n4];
                        n3 = 0;
                        try {
                            n3 = ((Reader)objectArray[i]).read((char[])object2, 0, n4);
                        }
                        catch (IOException iOException) {
                            throw TbError.newSQLException(-90202, iOException.getMessage());
                        }
                        if (n3 < 0) {
                            ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                            continue block20;
                        }
                        if (n3 > this.conn.getMaxDFRCharCount()) {
                            throw TbError.newSQLException(-90201);
                        }
                        ((Params)this.subParams).paramString[i] = new String((char[])object2, 0, n3);
                    } else if (objectArray[i] instanceof InputStream) {
                        int n5 = 65533;
                        object2 = new byte[n5];
                        n3 = 0;
                        if (this.subParams.paramBytes == null) {
                            Params.access$402(this.subParams, new byte[n][]);
                        }
                        try {
                            n3 = ((InputStream)objectArray[i]).read((byte[])object2, 0, n5);
                        }
                        catch (IOException iOException) {
                            throw TbError.newSQLException(-90202, iOException.getMessage());
                        }
                        if (n3 < 0) {
                            ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                            continue block20;
                        }
                        if (n3 > 65532) {
                            throw TbError.newSQLException(-90201);
                        }
                        byArray = new byte[n3];
                        System.arraycopy(object2, 0, byArray, 0, n3);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                        ((Params)this.subParams).paramBytes[i] = byArray;
                    } else {
                        ((Params)this.subParams).paramString[i] = objectArray[i].toString();
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 18: 
                case 19: {
                    if (this.subParams.paramString == null) {
                        Params.access$302(this.subParams, new String[n]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNStringBinder();
                    ((Params)this.subParams).paramString[i] = objectArray[i] instanceof Boolean ? ((Boolean)objectArray[i] != false ? "1" : "0") : (objectArray[i] == null ? null : objectArray[i].toString());
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 4: {
                    byte[] byArray;
                    int n3;
                    Object object2;
                    if (this.subParams.paramBytes == null) {
                        Params.access$402(this.subParams, new byte[n][]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (objectArray[i] instanceof byte[]) {
                        ((Params)this.subParams).paramBytes[i] = (byte[])objectArray[i];
                    } else if (objectArray[i] instanceof InputStream) {
                        int n6 = 65533;
                        object2 = new byte[n6];
                        n3 = 0;
                        try {
                            n3 = ((InputStream)objectArray[i]).read((byte[])object2, 0, n6);
                        }
                        catch (IOException iOException) {
                            throw TbError.newSQLException(-90202, iOException.getMessage());
                        }
                        if (n3 < 0) {
                            ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                            continue block20;
                        }
                        if (n3 > 65532) {
                            throw TbError.newSQLException(-90201);
                        }
                        byArray = new byte[n3];
                        System.arraycopy(object2, 0, byArray, 0, n3);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                        ((Params)this.subParams).paramBytes[i] = byArray;
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 5: {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance(((TbTimestampTZ)objectArray[i]).getTimeZone());
                        ((Calendar)object).setTime((TbTimestampTZ)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[n]);
                        }
                        object = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).paramTbDate[i] = new TbDate(((TbTimestamp)object).getYear(), ((TbTimestamp)object).getMonth(), ((TbTimestamp)object).getDayOfMonth(), ((TbTimestamp)object).getHourOfDay(), ((TbTimestamp)object).getMinutes(), ((TbTimestamp)object).getSeconds());
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[n]);
                        }
                        ((Params)this.subParams).paramTbDate[i] = (TbDate)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof Timestamp) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Timestamp)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(Date.valueOf((String)objectArray[i]));
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 6: {
                    Object object;
                    if (objectArray[i] instanceof Time) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Time)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimeBinder();
                    } else if (objectArray[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(Time.valueOf((String)objectArray[i]));
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimeBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 7: {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[n]);
                        }
                        ((Params)this.subParams).paramTbTimestamp[i] = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[n]);
                        }
                        object = (TbDate)objectArray[i];
                        ((Params)this.subParams).paramTbTimestamp[i] = new TbTimestamp(((TbDate)object).getYear(), ((TbDate)object).getMonth(), ((TbDate)object).getDayOfMonth(), ((TbDate)object).getHourOfDay(), ((TbDate)object).getMinutes(), ((TbDate)object).getSeconds(), 0);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (objectArray[i] instanceof Timestamp) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof String) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = Timestamp.valueOf((String)objectArray[i]);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 12: 
                case 13: 
                case 20: {
                    if (objectArray[i] instanceof TbLob) {
                        if (this.subParams.paramBytes == null) {
                            Params.access$402(this.subParams, new byte[n][]);
                        }
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    ((Params)this.subParams).paramBytes[i] = ((TbLob)objectArray[i]).getLocator();
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 15: {
                    if (this.subParams.paramBytes == null) {
                        Params.access$402(this.subParams, new byte[n][]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (!(objectArray[i] instanceof TbRowId)) {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    ((Params)this.subParams).paramBytes[i] = ((TbRowId)objectArray[i]).getBytes();
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 33: {
                    if (this.subParams.paramBytes == null) {
                        Params.access$402(this.subParams, new byte[n][]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (!(objectArray[i] instanceof TbRef)) {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    ((Params)this.subParams).paramBytes[i] = ((TbRef)objectArray[i]).getRawData();
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 29: 
                case 30: 
                case 31: {
                    if (this.subParams.paramArray == null) {
                        Params.access$902(this.subParams, new Array[n]);
                    }
                    if (objectArray[i] instanceof Array) {
                        ((Params)this.subParams).paramArray[i] = (Array)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getArrayInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbArray)objectArray[i]).getDescriptor());
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramArray[i] = null;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, nArray[i], 0);
                    continue block20;
                }
                case 28: 
                case 32: {
                    Object object;
                    if (this.subParams.paramStruct == null) {
                        Params.access$1002(this.subParams, new Struct[n]);
                    }
                    if (objectArray[i] instanceof Struct) {
                        ((Params)this.subParams).paramStruct[i] = (Struct)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)objectArray[i]).getDescriptor());
                        continue block20;
                    }
                    if (objectArray[i] instanceof SQLData) {
                        ((Params)this.subParams).paramStruct[i] = object = (Struct)TbStruct.toStruct(objectArray[i], this.conn);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)object).getDescriptor());
                        continue block20;
                    }
                    if (objectArray[i] == null) {
                        ((Params)this.subParams).paramStruct[i] = null;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                        continue block20;
                    }
                    Object object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                default: {
                    throw TbError.newSQLException(-590703, DataType.getDBTypeName(nArray[i]));
                }
            }
        }
    }

    public TbStructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public int getNumOfFields() {
        return this.descriptor.getNumOfFields();
    }

    public static Object toStruct(Object object, Connection connection) throws SQLException {
        TbStruct tbStruct = null;
        if (object != null) {
            if (object instanceof TbStruct) {
                tbStruct = (TbStruct)object;
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(sQLData.getSQLTypeName(), connection);
                SQLOutput sQLOutput = tbStructDescriptor.toSQLOutput();
                sQLData.writeSQL(sQLOutput);
                tbStruct = ((TbSQLOutput)sQLOutput).getStruct();
            } else {
                throw TbError.newSQLException(-90651, String.valueOf(object));
            }
        }
        return tbStruct;
    }

    public ParamContainer getSubParams() {
        return this.subParams;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getSQLTypeName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    public Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        if (clazz == null) {
            return this;
        }
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
            if (var3_3 instanceof SQLData) {
                ((SQLData)var3_3).readSQL(this.descriptor.toSQLInput(this, map), this.descriptor.getSQLTypeName());
            }
        }
        catch (InstantiationException instantiationException) {
            throw TbError.newSQLException(-90651, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw TbError.newSQLException(-90651, illegalAccessException);
        }
        return var3_3;
    }

    public Object toClass(Map<String, Class<?>> map) throws SQLException {
        Class<?> clazz;
        Object object = this;
        Map<String, Class<?>> map2 = map;
        if (map2 != null) {
            Class<?> clazz2 = this.descriptor.getClass(map2);
            if (clazz2 != null) {
                object = this.toClass(clazz2, map2);
            }
        } else if (this.conn != null && (clazz = this.descriptor.getClass(map2 = this.conn.getTypeMap())) != null) {
            object = this.toClass(clazz, map2);
        }
        return object;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        int n;
        Object[] objectArray = new Object[this.attributes.length];
        if (this.attributes.length == 0) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.attributes[i];
        }
        Map<String, Class<?>> map2 = map;
        if (this.conn != null) {
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof SQLData)) continue;
                objectArray[n] = (Struct)TbStruct.toStruct(objectArray[n], this.conn);
            }
        }
        if (map2 != null) {
            for (n = 0; n < objectArray.length; ++n) {
                Class<?> clazz;
                if (!(objectArray[n] instanceof Struct) || (clazz = ((TbStruct)objectArray[n]).getDescriptor().getClassWithExplicitMap(map2)) == null) continue;
                objectArray[n] = ((TbStruct)objectArray[n]).toClass(clazz, map2);
            }
        }
        return objectArray;
    }

    class Params
    implements ParamContainer {
        private Binder[] attributeBinders;
        private BindData bindData;
        private BigDecimal[] paramBigDecimal;
        private String[] paramString;
        private Timestamp[] paramTimestamp;
        private TbTimestampTZ[] paramTbTimestampTZ;
        private TbTimestamp[] paramTbTimestamp;
        private TbDate[] paramTbDate;
        private Calendar[] paramCalendar;
        private byte[][] paramBytes;
        private InputStream[] paramStream;
        private Reader[] paramReader;
        private Struct[] paramStruct;
        private Array[] paramArray;

        Params() {
        }

        @Override
        public BindData getBindData() {
            return this.bindData;
        }

        @Override
        public Binder[][] getBinder() {
            return null;
        }

        @Override
        public Binder getBinder(int n, int n2) {
            return this.attributeBinders[n2];
        }

        @Override
        public int getParameterCnt() {
            return 1;
        }

        @Override
        public byte getParamType(int n, int n2) {
            return 0;
        }

        @Override
        public byte[][] getParamTypes() {
            return null;
        }

        @Override
        public byte[] getParamTypesOfRow(int n) {
            return null;
        }

        @Override
        public Array getParamArray(int n, int n2) {
            return this.paramArray[n2];
        }

        @Override
        public Array[] getParamArrayOfRow(int n) {
            return null;
        }

        @Override
        public BigDecimal getParamBigDecimal(int n, int n2) {
            return this.paramBigDecimal[n2];
        }

        @Override
        public BigDecimal[] getParamBigDecimalOfRow(int n) {
            return null;
        }

        @Override
        public byte[] getParamBytes(int n, int n2) {
            return this.paramBytes[n2];
        }

        @Override
        public byte[][] getParamBytesOfRow(int n) {
            return null;
        }

        @Override
        public Calendar getParamCalendar(int n, int n2) {
            return this.paramCalendar[n2];
        }

        @Override
        public Calendar[] getParamCalendarOfRow(int n) {
            return null;
        }

        @Override
        public double getParamDouble(int n, int n2) {
            return 0.0;
        }

        @Override
        public double[] getParamDoubleOfRow(int n) {
            return null;
        }

        @Override
        public float getParamFloat(int n, int n2) {
            return 0.0f;
        }

        @Override
        public float[] getParamFloatOfRow(int n) {
            return null;
        }

        @Override
        public int getParamInt(int n, int n2) {
            return 0;
        }

        @Override
        public int[] getParamIntOfRow(int n) {
            return null;
        }

        @Override
        public long getParamLong(int n, int n2) {
            return 0L;
        }

        @Override
        public long[] getParamLongOfRow(int n) {
            return null;
        }

        @Override
        public Reader getParamReader(int n, int n2) {
            return this.paramReader[n2];
        }

        @Override
        public Reader[] getParamReaderOfRow(int n) {
            return null;
        }

        @Override
        public InputStream getParamStream(int n, int n2) {
            return this.paramStream[n2];
        }

        @Override
        public InputStream[] getParamStreamOfRow(int n) {
            return null;
        }

        @Override
        public String getParamString(int n, int n2) {
            return this.paramString[n2];
        }

        @Override
        public String[] getParamStringOfRow(int n) {
            return null;
        }

        @Override
        public Struct getParamStruct(int n, int n2) {
            return this.paramStruct[n2];
        }

        @Override
        public Struct[] getParamStructOfRow(int n) {
            return null;
        }

        @Override
        public TbDate getParamTbDate(int n, int n2) {
            return this.paramTbDate[n2];
        }

        @Override
        public TbDate[] getParamTbDateOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestamp getParamTbTimestamp(int n, int n2) {
            return this.paramTbTimestamp[n2];
        }

        @Override
        public TbTimestamp[] getParamTbTimestampOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
            return this.paramTbTimestampTZ[n2];
        }

        @Override
        public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
            return null;
        }

        @Override
        public Timestamp getParamTimestamp(int n, int n2) {
            return this.paramTimestamp[n2];
        }

        @Override
        public Timestamp[] getParamTimestampOfRow(int n) {
            return null;
        }

        static /* synthetic */ Binder[] access$002(Params params, Binder[] binderArray) {
            params.attributeBinders = binderArray;
            return binderArray;
        }

        static /* synthetic */ BigDecimal[] access$202(Params params, BigDecimal[] bigDecimalArray) {
            params.paramBigDecimal = bigDecimalArray;
            return bigDecimalArray;
        }

        static /* synthetic */ String[] access$302(Params params, String[] stringArray) {
            params.paramString = stringArray;
            return stringArray;
        }

        static /* synthetic */ byte[][] access$402(Params params, byte[][] byArray) {
            params.paramBytes = byArray;
            return byArray;
        }

        static /* synthetic */ Calendar[] access$502(Params params, Calendar[] calendarArray) {
            params.paramCalendar = calendarArray;
            return calendarArray;
        }

        static /* synthetic */ TbDate[] access$602(Params params, TbDate[] tbDateArray) {
            params.paramTbDate = tbDateArray;
            return tbDateArray;
        }

        static /* synthetic */ Timestamp[] access$702(Params params, Timestamp[] timestampArray) {
            params.paramTimestamp = timestampArray;
            return timestampArray;
        }

        static /* synthetic */ TbTimestamp[] access$802(Params params, TbTimestamp[] tbTimestampArray) {
            params.paramTbTimestamp = tbTimestampArray;
            return tbTimestampArray;
        }

        static /* synthetic */ Array[] access$902(Params params, Array[] arrayArray) {
            params.paramArray = arrayArray;
            return arrayArray;
        }

        static /* synthetic */ Struct[] access$1002(Params params, Struct[] structArray) {
            params.paramStruct = structArray;
            return structArray;
        }
    }
}

