/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class TbRef
implements Ref {
    public final int REF_TOID_OFFSET = 1;
    public final int REF_ROID_OFFSET = 17;
    public final int REF_ROWID_OFFSET = 33;
    public final int REF_TOID_LEN = 16;
    public final int REF_ROID_LEN = 16;
    public final int REF_ROWID_LEN = 10;
    public final int REF_LEN = 43;
    private byte[] rawData;
    private TbStructDescriptor realDesc;
    private String hexEncodedTOID;
    private TbConnection conn;

    public TbRef(byte[] byArray, int n, int n2, TbConnection tbConnection) {
        this.rawData = new byte[n2];
        System.arraycopy(byArray, n, this.rawData, 0, n2);
        this.setHexTOID();
        this.conn = tbConnection;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            if (this.conn != null) {
                this.realDesc = TbStructDescriptor.createDescriptor(this, (Connection)this.conn);
            }
        }
        catch (SQLException sQLException) {
            throw TbError.newSQLException(-90612, sQLException);
        }
        return this.realDesc.getSQLTypeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        String string = "SELECT DEREF(?) FROM DUAL";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setRef(1, this);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            Object object = resultSet.getObject(1, map);
            return object;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() throws SQLException {
        String string = "SELECT DEREF(?) FROM DUAL";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setRef(1, this);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            Object object = resultSet.getObject(1);
            return object;
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void setObject(Object object) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    private void setHexTOID() {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        StringBuilder stringBuilder = new StringBuilder(32);
        for (int i = 0; i < 16; ++i) {
            stringBuilder.append(cArray[this.rawData[i + 1] >> 4 & 0xF]);
            stringBuilder.append(cArray[this.rawData[i + 1] & 0xF]);
        }
        this.hexEncodedTOID = stringBuilder.toString();
    }

    public String getHexTOID() {
        return this.hexEncodedTOID;
    }

    public byte[] getRawData() {
        return this.rawData;
    }
}

