/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;

public class TbAnydata {
    boolean isNull;
    Blob largeData;
    byte[] data;
    byte[] type;
    private Struct struct;
    Connection conn = null;

    public TbAnydata(Struct struct) throws SQLException {
        this.largeData = (Blob)struct.getAttributes()[0];
        this.data = (byte[])struct.getAttributes()[1];
        this.type = (byte[])struct.getAttributes()[2];
        this.struct = struct;
    }

    public static TbAnydata convertObject(Object object, Connection connection) throws SQLException {
        if (object instanceof Blob || object instanceof Clob) {
            byte[] byArray = new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54};
            byArray[16] = (byte)DataType.getDataType(DataType.getSqlType(object));
            if (object instanceof TbClobBase) {
                TbClobBase tbClobBase = (TbClobBase)object;
                TbConnection tbConnection = (TbConnection)connection;
                TbBlob tbBlob = new TbBlob(tbConnection, tbClobBase.getLocator(), tbClobBase.freeTmpLobOnEOF());
                Object[] objectArray = new Object[]{tbBlob, null, byArray};
                Struct struct = connection.createStruct("SYS.ANYDATA", objectArray);
                return new TbAnydata(struct);
            }
            Object[] objectArray = new Object[]{object, null, byArray};
            Struct struct = connection.createStruct("SYS.ANYDATA", objectArray);
            return new TbAnydata(struct);
        }
        String string = TbAnydata.getTypeName(DataType.getDataType(DataType.getSqlType(object)));
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERT" + string + "(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertTimestampTZ(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTTIMESTAMPTZ(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertTimestampLTZ(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTTIMESTAMPLTZ(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertChar(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTCHAR(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object, 1);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertNChar(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTNCHAR(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object, -15);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertNVarchar(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTNVARCHAR2(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object, -9);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertBFloat(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTBFLOAT(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object, 100);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertBDouble(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTBDOUBLE(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object, 101);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertIntervalYM(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTINTERVALYM(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public static TbAnydata convertIntervalDS(Object object, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("BEGIN ? := SYS.ANYDATA.CONVERTINTERVALDS(?); END;");
        callableStatement.registerOutParameter(1, 2002, "SYS.ANYDATA");
        callableStatement.setObject(2, object);
        callableStatement.execute();
        return new TbAnydata((Struct)callableStatement.getObject(1));
    }

    public Object toJDBCObject(Connection connection) throws SQLException {
        switch (TbCommon.bytes2Int(this.type, 13, 4)) {
            case 13: {
                return new TbClob((TbConnection)connection, ((TbBlob)this.largeData).getLocator(), ((TbBlob)this.largeData).freeTmpLobOnEOF());
            }
            case 20: {
                return new TbNClob((TbConnection)connection, ((TbBlob)this.largeData).getLocator(), ((TbBlob)this.largeData).freeTmpLobOnEOF());
            }
            case 12: {
                return this.largeData;
            }
        }
        String string = TbAnydata.getTypeName(TbCommon.bytes2Int(this.type, 13, 4));
        CallableStatement callableStatement = connection.prepareCall("DECLARE L_ANY SYS.ANYDATA; BEGIN L_ANY := ?;  ? := L_ANY.GET" + string + "(?); END;");
        callableStatement.registerOutParameter(2, 4);
        if (string.equalsIgnoreCase("INTERVALYM") || string.equalsIgnoreCase("INTERVALDS")) {
            callableStatement.registerOutParameter(3, 12);
            callableStatement.setObject(1, (Object)this.struct);
            callableStatement.execute();
            return callableStatement.getObject(3);
        }
        if (string.equalsIgnoreCase("OBJECT") || string.equalsIgnoreCase("COLLECTION")) {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT OWNER, OBJECT_NAME FROM ALL_OBJECTS WHERE OBJECT_ID=?");
            preparedStatement.setInt(1, TbCommon.bytes2Int(this.type, 17, 4));
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string2 = resultSet.getString(1) + "." + resultSet.getString(2);
            resultSet.close();
            callableStatement.registerOutParameter(3, DataType.getSqlType(TbCommon.bytes2Int(this.type, 13, 4)), string2);
            callableStatement.setObject(1, (Object)this.struct);
            callableStatement.execute();
            if (TbCommon.bytes2Int(this.type, 13, 4) == 32) {
                return callableStatement.getObject(3);
            }
            return callableStatement.getArray(3);
        }
        callableStatement.registerOutParameter(3, DataType.getSqlType(TbCommon.bytes2Int(this.type, 13, 4)));
        callableStatement.setObject(1, (Object)this.struct);
        callableStatement.execute();
        return callableStatement.getObject(3);
    }

    private static String getTypeName(int n) throws SQLException {
        switch (n) {
            case 2: {
                return "CHAR";
            }
            case 3: {
                return "VARCHAR2";
            }
            case 1: {
                return "NUMBER";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIME";
            }
            case 21: {
                return "TIMESTAMPTZ";
            }
            case 22: {
                return "TIMESTAMPLTZ";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "INTERVALYM";
            }
            case 9: {
                return "INTERVALDS";
            }
            case 4: {
                return "RAW";
            }
            case 12: {
                return "BLOB";
            }
            case 13: {
                return "CLOB";
            }
            case 24: {
                return "BDOUBLE";
            }
            case 23: {
                return "BFLOAT";
            }
            case 18: {
                return "NCHAR";
            }
            case 19: {
                return "NVARCHAR2";
            }
            case 20: {
                return "NCLOB";
            }
            case 32: {
                return "OBJECT";
            }
            case 29: 
            case 30: {
                return "COLLECTION";
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(n));
    }

    public Struct getStruct() {
        return this.struct;
    }
}

