/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.driver.TbTimeout;

public class TbTimeoutPollingThread
extends Thread {
    private int count;
    private long sleepMillis;
    private TbTimeout[] registeredTimeouts;

    public TbTimeoutPollingThread() {
        super("TbTimeoutPollingThread");
        this.setDaemon(true);
        this.setPriority(10);
        this.registeredTimeouts = new TbTimeout[2];
        this.count = 0;
        this.sleepMillis = 1000L;
        this.start();
    }

    public synchronized void add(TbTimeout tbTimeout) {
        int n = 0;
        if (this.count >= this.registeredTimeouts.length) {
            TbTimeout[] tbTimeoutArray = new TbTimeout[this.registeredTimeouts.length * 4];
            System.arraycopy(this.registeredTimeouts, 0, tbTimeoutArray, 0, this.registeredTimeouts.length);
            n = this.registeredTimeouts.length;
            this.registeredTimeouts = tbTimeoutArray;
        }
        while (n < this.registeredTimeouts.length) {
            if (this.registeredTimeouts[n] == null) {
                this.registeredTimeouts[n] = tbTimeout;
                ++this.count;
                break;
            }
            ++n;
        }
    }

    private void poll() {
        if (this.count > 0) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.registeredTimeouts.length; ++i) {
                try {
                    if (this.registeredTimeouts[i] == null) continue;
                    this.registeredTimeouts[i].cancelStmtOfTimeover(l);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void remove(TbTimeout tbTimeout) {
        for (int i = 0; i < this.registeredTimeouts.length; ++i) {
            if (this.registeredTimeouts[i] != tbTimeout) continue;
            this.registeredTimeouts[i] = null;
            --this.count;
            break;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.poll();
        }
    }
}

