/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbSQLInput;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtHierarchyInfo;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;

public class TbStructDescriptor
extends TbTypeDescriptor {
    private TbConnection conn;
    private int memberNo;
    private int numOfFields;
    private int[] attributeTypes;
    private String[] attributeTypeNames;
    private String[] attributeOIDs;
    private boolean isFinal = true;
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";

    protected TbStructDescriptor(String string, Connection connection) throws SQLException {
        this.init(32, null, string.toUpperCase());
        this.conn = (TbConnection)connection;
    }

    protected TbStructDescriptor(int n, String string, String string2, int[] nArray, String[] stringArray, String[] stringArray2, TbConnection tbConnection) throws SQLException {
        this.init(n, string, string2);
        this.attributeTypes = nArray;
        this.numOfFields = nArray.length;
        this.attributeTypeNames = stringArray;
        this.attributeOIDs = stringArray2;
        this.conn = tbConnection;
    }

    public static TbStructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        if (!tbConnection.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String string2 = string.toUpperCase();
        Object object = tbConnection.getDescriptor(string2);
        if (object instanceof TbStructDescriptor) {
            return (TbStructDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        String[] stringArray = TbTypeDescriptor.splitSQLTypeName(string2);
        if (stringArray.length != 2) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        return TbStructDescriptor.lookupUdtMeta(stringArray[0], stringArray[1], tbConnection);
    }

    public static TbStructDescriptor createDescriptor(int n, String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        Object object = tbConnection.getDescriptor(_DESC_OID_PREFIX + string);
        if (object instanceof TbStructDescriptor) {
            return (TbStructDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbStructDescriptor.lookupUdtMeta(string, tbConnection);
    }

    public static TbStructDescriptor createDescriptor(int n, String string, int n2, int n3, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        Object object = tbConnection.getDescriptor(_DESC_OID_PREFIX + string + _DESC_TOBJ_ID_PREFIX + n2 + _DESC_VERSION_NO_PREFIX + n3);
        if (object instanceof TbStructDescriptor) {
            return (TbStructDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbStructDescriptor.lookupUdtMeta(string, tbConnection);
    }

    public static TbStructDescriptor lookupUdtMeta(String string, TbConnection tbConnection) throws SQLException {
        if ("00000000000000000000000000000009".equalsIgnoreCase(string)) {
            return null;
        }
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + string + "]");
        }
        PreparedStatement preparedStatement = tbConnection.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_OID);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        return TbStructDescriptor.lookupUdtMetaInternal((TbResultSetBase)resultSet, tbConnection);
    }

    public static TbStructDescriptor lookupUdtMeta(String string, String string2, TbConnection tbConnection) throws SQLException {
        if ("SYS.UDT_META_T".equalsIgnoreCase(string + "." + string2)) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            throw TbError.newSQLException(-90608, "typeName[" + string2 + "]");
        }
        PreparedStatement preparedStatement = tbConnection.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_TYPENAME);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        return TbStructDescriptor.lookupUdtMetaInternal((TbResultSetBase)resultSet, tbConnection);
    }

    private static TbStructDescriptor lookupUdtMetaInternal(TbResultSetBase tbResultSetBase, TbConnection tbConnection) throws SQLException {
        if (!tbResultSetBase.next()) {
            throw TbError.newSQLException(-90665);
        }
        try {
            Object object = tbResultSetBase.getObject(1, TbTypeDescriptor.getUdtMeta2ClsMap());
            if (!(object instanceof UdtMeta)) {
                throw TbError.newSQLException(-90664);
            }
            UdtMeta udtMeta = (UdtMeta)object;
            int n = udtMeta.getUdtId().getVersionNo();
            int n2 = udtMeta.getUdtId().getTobjID();
            Object[] objectArray = (Object[])udtMeta.getAttrMetaArr().getArray();
            Object[] objectArray2 = (Object[])udtMeta.getHierarchyInfoArr().getArray();
            TbStructDescriptor tbStructDescriptor = null;
            for (int i = 0; i < udtMeta.getHierarchyCnt(); ++i) {
                UdtHierarchyInfo udtHierarchyInfo = (UdtHierarchyInfo)objectArray2[i];
                byte[] byArray = udtHierarchyInfo.getProperties();
                UdtInfo udtInfo = udtHierarchyInfo.getUdtId();
                BigDecimal[] bigDecimalArray = (BigDecimal[])udtHierarchyInfo.getAttrIdxArr().getArray();
                int[] nArray = new int[bigDecimalArray.length];
                String[] stringArray = new String[bigDecimalArray.length];
                String[] stringArray2 = new String[bigDecimalArray.length];
                String string = udtInfo.getSchemaName() + "." + udtInfo.getUdtName();
                for (int j = 0; j < bigDecimalArray.length; ++j) {
                    UdtAttrMeta udtAttrMeta = (UdtAttrMeta)objectArray[bigDecimalArray[j].intValue() - 1];
                    nArray[j] = udtAttrMeta.getTypeNo();
                    stringArray2[j] = udtAttrMeta.getOid();
                }
                TbStructDescriptor tbStructDescriptor2 = new TbStructDescriptor(udtInfo.getTypeNo(), udtInfo.getOid(), string, nArray, stringArray, stringArray2, tbConnection);
                tbStructDescriptor2.setVersionNo(n);
                tbStructDescriptor2.setTobjID(n2);
                tbStructDescriptor2.setIsFinal(byArray);
                if (i == 0) {
                    tbStructDescriptor = tbStructDescriptor2;
                }
                tbConnection.putDescriptor(string, tbStructDescriptor2);
                tbConnection.putDescriptor(_DESC_OID_PREFIX + udtInfo.getOid(), tbStructDescriptor2);
            }
            return tbStructDescriptor;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n <= -90400 && n > -90500 || n == -90664) {
                throw sQLException;
            }
            throw TbError.newSQLException(-90664, sQLException);
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90664, exception);
        }
    }

    public SQLInput toSQLInput(TbStruct tbStruct, Map<String, Class<?>> map) throws SQLException {
        return new TbSQLInput(tbStruct, this, map);
    }

    public SQLOutput toSQLOutput() {
        return new TbSQLOutput(this, this.conn);
    }

    public int getNumOfFields() {
        return this.numOfFields;
    }

    public String[] getAttributeOIDs() {
        return this.attributeOIDs;
    }

    public int[] getAttributeTypes() {
        return this.attributeTypes;
    }

    public String[] getAttributeTypeNames() {
        return this.attributeTypeNames;
    }

    public int getMemberNo() {
        return this.memberNo;
    }

    public Class<?> getClass(Map<String, Class<?>> map) throws SQLException {
        Class<?> clazz;
        String string = this.getSQLTypeName();
        Class<?> clazz2 = map.get(string);
        if (clazz2 == null && this.conn != null && (clazz = this.conn.getTypeMap().get(string)) instanceof Class) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setIsFinal(byte[] byArray) throws SQLException {
        if (byArray[0] == 1) {
            this.isFinal = true;
        } else if (byArray[0] == 0) {
            this.isFinal = false;
        } else {
            throw TbError.newSQLException(-90664);
        }
    }
}

