/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbArray
implements Array {
    private TbConnection conn;
    private TbArrayDescriptor descriptor;
    private int baseType;
    private Object[] elements;
    private Params subParams;

    public TbArray(TbArrayDescriptor tbArrayDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (tbArrayDescriptor == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (connection == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = tbArrayDescriptor;
        this.baseType = tbArrayDescriptor.getBaseType();
        this.conn = (TbConnection)connection;
        this.elements = objectArray;
        this.subParams = new Params();
        this.initSubParams(tbArrayDescriptor.getElementType(), objectArray);
    }

    private void initSubParams(int n, Object[] objectArray) throws SQLException {
        int n2 = objectArray == null ? 0 : objectArray.length;
        Params.access$002(this.subParams, new Binder[n2]);
        this.subParams.bindData = new BindData(n2);
        switch (n) {
            case 1: {
                Params.access$202(this.subParams, new BigDecimal[n2]);
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] == null) {
                        ((Params)this.subParams).paramBigDecimal[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else if (objectArray[i] instanceof Short) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Short)objectArray[i]).intValue());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof Integer) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Integer)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof Long) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Long)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof BigInteger) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((BigInteger)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof BigDecimal) {
                        ((Params)this.subParams).paramBigDecimal[i] = (BigDecimal)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof Float) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Float)objectArray[i]).floatValue());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof Double) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Double)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof String) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((String)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Boolean)objectArray[i] != false ? 1.0 : 0.0);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBigDecimalBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                Params.access$302(this.subParams, new String[n2]);
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStringBinder();
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        ((Params)this.subParams).paramString[i] = objectArray[i].toString();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStringBinder();
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 18: 
            case 19: {
                Params.access$302(this.subParams, new String[n2]);
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNStringBinder();
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        ((Params)this.subParams).paramString[i] = objectArray[i].toString();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNStringBinder();
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 4: {
                Params.access$402(this.subParams, new byte[n2][]);
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof byte[]) {
                        ((Params)this.subParams).paramBytes[i] = (byte[])objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBytesBinder();
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramBytes[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n2]);
                        }
                        object = Calendar.getInstance(((TbTimestampTZ)objectArray[i]).getTimeZone());
                        ((Calendar)object).setTime((TbTimestampTZ)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[n2]);
                        }
                        object = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).paramTbDate[i] = new TbDate(((TbTimestamp)object).getYear(), ((TbTimestamp)object).getMonth(), ((TbTimestamp)object).getDayOfMonth(), ((TbTimestamp)object).getHourOfDay(), ((TbTimestamp)object).getMinutes(), ((TbTimestamp)object).getSeconds());
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[n2]);
                        }
                        ((Params)this.subParams).paramTbDate[i] = (TbDate)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (objectArray[i] instanceof Timestamp || objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n2]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n2]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(Date.valueOf((String)objectArray[i]));
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else {
                        object = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                        throw TbError.newSQLException(-90651, (String)object);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n2]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[n2]);
                        }
                        ((Params)this.subParams).paramTbTimestamp[i] = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[n2]);
                        }
                        object = (TbDate)objectArray[i];
                        ((Params)this.subParams).paramTbTimestamp[i] = new TbTimestamp(((TbDate)object).getYear(), ((TbDate)object).getMonth(), ((TbDate)object).getDayOfMonth(), ((TbDate)object).getHourOfDay(), ((TbDate)object).getMinutes(), ((TbDate)object).getSeconds(), 0);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (objectArray[i] instanceof Timestamp) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n2]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[n2]);
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getDateBinder();
                    } else if (objectArray[i] instanceof String) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[n2]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = Timestamp.valueOf((String)objectArray[i]);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getTimestampBinder();
                    } else {
                        object = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                        throw TbError.newSQLException(-90651, (String)object);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                Params.access$402(this.subParams, new byte[n2][]);
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof TbLob) {
                        ((Params)this.subParams).paramBytes[i] = ((TbLob)objectArray[i]).getLocator();
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getBytesBinder();
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramBytes[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                if (this.subParams.paramArray == null) {
                    Params.access$902(this.subParams, new Array[n2]);
                }
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Array) {
                        ((Params)this.subParams).paramArray[i] = (Array)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getArrayInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbArray)objectArray[i]).getDescriptor());
                    } else if (objectArray[i] == null) {
                        ((Params)this.subParams).paramArray[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.subParams.bindData.setINParam(i, n, 0);
                }
                break;
            }
            case 28: 
            case 32: {
                if (this.subParams.paramStruct == null) {
                    Params.access$1002(this.subParams, new Struct[n2]);
                }
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Struct) {
                        ((Params)this.subParams).paramStruct[i] = (Struct)objectArray[i];
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)objectArray[i]).getDescriptor());
                        continue;
                    }
                    if (objectArray[i] instanceof SQLData) {
                        Struct struct;
                        ((Params)this.subParams).paramStruct[i] = struct = (Struct)TbStruct.toStruct(objectArray[i], this.conn);
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)struct).getDescriptor());
                        continue;
                    }
                    if (objectArray[i] == null) {
                        ((Params)this.subParams).paramStruct[i] = null;
                        ((Params)this.subParams).elementBinders[i] = StaticBinder.getNullBinder();
                        continue;
                    }
                    String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                    throw TbError.newSQLException(-90651, string);
                }
                break;
            }
            default: {
                throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
            }
        }
    }

    public TbArrayDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void free() throws SQLException {
        this.conn = null;
        this.descriptor = null;
    }

    @Override
    public Object getArray() throws SQLException {
        int n = this.descriptor.getElementType();
        int n2 = this.elements == null ? 0 : this.elements.length;
        switch (n) {
            case 1: {
                return this.subParams.paramBigDecimal;
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.subParams.paramString;
            }
            case 5: {
                if (!this.conn.info.getMapDateToTimestamp()) {
                    Date[] dateArray = new Date[n2];
                    for (int i = 0; i < n2; ++i) {
                        dateArray[i] = (Date)this.elements[i];
                    }
                    return dateArray;
                }
            }
            case 7: 
            case 21: 
            case 22: {
                Timestamp[] timestampArray = new Timestamp[n2];
                for (int i = 0; i < n2; ++i) {
                    timestampArray[i] = (Timestamp)this.elements[i];
                }
                return timestampArray;
            }
            case 4: {
                return this.subParams.paramBytes;
            }
            case 12: {
                Blob[] blobArray = new Blob[n2];
                for (int i = 0; i < n2; ++i) {
                    blobArray[i] = (Blob)this.elements[i];
                }
                return blobArray;
            }
            case 20: {
                NClob[] nClobArray = new NClob[n2];
                for (int i = 0; i < n2; ++i) {
                    nClobArray[i] = (NClob)this.elements[i];
                }
                return nClobArray;
            }
            case 13: {
                Clob[] clobArray = new Clob[n2];
                for (int i = 0; i < n2; ++i) {
                    clobArray[i] = (Clob)this.elements[i];
                }
                return clobArray;
            }
            case 29: 
            case 30: 
            case 31: {
                TbArray[] tbArrayArray = new TbArray[n2];
                for (int i = 0; i < n2; ++i) {
                    tbArrayArray[i] = (TbArray)this.elements[i];
                }
                return tbArrayArray;
            }
        }
        return this.elements;
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return DataType.getDBTypeName(this.descriptor.getElementType());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public Params getSubParams() {
        return this.subParams;
    }

    public String getSQLTypeName() {
        return this.descriptor.getSQLTypeName();
    }

    public int length() {
        return this.elements == null ? 0 : this.elements.length;
    }

    class Params
    implements ParamContainer {
        private Binder[] elementBinders;
        private BindData bindData;
        private BigDecimal[] paramBigDecimal;
        private String[] paramString;
        private Timestamp[] paramTimestamp;
        private TbTimestampTZ[] paramTbTimestampTZ;
        private TbTimestamp[] paramTbTimestamp;
        private TbDate[] paramTbDate;
        private Calendar[] paramCalendar;
        private byte[][] paramBytes;
        private InputStream[] paramStream;
        private Reader[] paramReader;
        private Struct[] paramStruct;
        private Array[] paramArray;

        Params() {
        }

        @Override
        public BindData getBindData() {
            return this.bindData;
        }

        @Override
        public Binder[][] getBinder() {
            return null;
        }

        @Override
        public Binder getBinder(int n, int n2) {
            return this.elementBinders[n2];
        }

        @Override
        public int getParameterCnt() {
            return 1;
        }

        @Override
        public byte getParamType(int n, int n2) {
            return 0;
        }

        @Override
        public byte[][] getParamTypes() {
            return null;
        }

        @Override
        public byte[] getParamTypesOfRow(int n) {
            return null;
        }

        @Override
        public Array getParamArray(int n, int n2) {
            return this.paramArray[n2];
        }

        @Override
        public Array[] getParamArrayOfRow(int n) {
            return null;
        }

        @Override
        public BigDecimal getParamBigDecimal(int n, int n2) {
            return this.paramBigDecimal[n2];
        }

        @Override
        public BigDecimal[] getParamBigDecimalOfRow(int n) {
            return null;
        }

        @Override
        public byte[] getParamBytes(int n, int n2) {
            return this.paramBytes[n2];
        }

        @Override
        public byte[][] getParamBytesOfRow(int n) {
            return null;
        }

        @Override
        public Calendar getParamCalendar(int n, int n2) {
            return this.paramCalendar[n2];
        }

        @Override
        public Calendar[] getParamCalendarOfRow(int n) {
            return null;
        }

        @Override
        public double getParamDouble(int n, int n2) {
            return 0.0;
        }

        @Override
        public double[] getParamDoubleOfRow(int n) {
            return null;
        }

        @Override
        public float getParamFloat(int n, int n2) {
            return 0.0f;
        }

        @Override
        public float[] getParamFloatOfRow(int n) {
            return null;
        }

        @Override
        public int getParamInt(int n, int n2) {
            return 0;
        }

        @Override
        public int[] getParamIntOfRow(int n) {
            return null;
        }

        @Override
        public long getParamLong(int n, int n2) {
            return 0L;
        }

        @Override
        public long[] getParamLongOfRow(int n) {
            return null;
        }

        @Override
        public Reader getParamReader(int n, int n2) {
            return this.paramReader[n2];
        }

        @Override
        public Reader[] getParamReaderOfRow(int n) {
            return null;
        }

        @Override
        public InputStream getParamStream(int n, int n2) {
            return this.paramStream[n2];
        }

        @Override
        public InputStream[] getParamStreamOfRow(int n) {
            return null;
        }

        @Override
        public String getParamString(int n, int n2) {
            return this.paramString[n2];
        }

        @Override
        public String[] getParamStringOfRow(int n) {
            return null;
        }

        @Override
        public Struct getParamStruct(int n, int n2) {
            return this.paramStruct[n2];
        }

        @Override
        public Struct[] getParamStructOfRow(int n) {
            return null;
        }

        @Override
        public TbDate getParamTbDate(int n, int n2) {
            return this.paramTbDate[n2];
        }

        @Override
        public TbDate[] getParamTbDateOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestamp getParamTbTimestamp(int n, int n2) {
            return this.paramTbTimestamp[n2];
        }

        @Override
        public TbTimestamp[] getParamTbTimestampOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
            return this.paramTbTimestampTZ[n2];
        }

        @Override
        public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
            return null;
        }

        @Override
        public Timestamp getParamTimestamp(int n, int n2) {
            return this.paramTimestamp[n2];
        }

        @Override
        public Timestamp[] getParamTimestampOfRow(int n) {
            return null;
        }

        static /* synthetic */ Binder[] access$002(Params params, Binder[] binderArray) {
            params.elementBinders = binderArray;
            return binderArray;
        }

        static /* synthetic */ BigDecimal[] access$202(Params params, BigDecimal[] bigDecimalArray) {
            params.paramBigDecimal = bigDecimalArray;
            return bigDecimalArray;
        }

        static /* synthetic */ String[] access$302(Params params, String[] stringArray) {
            params.paramString = stringArray;
            return stringArray;
        }

        static /* synthetic */ byte[][] access$402(Params params, byte[][] byArray) {
            params.paramBytes = byArray;
            return byArray;
        }

        static /* synthetic */ Calendar[] access$502(Params params, Calendar[] calendarArray) {
            params.paramCalendar = calendarArray;
            return calendarArray;
        }

        static /* synthetic */ TbDate[] access$602(Params params, TbDate[] tbDateArray) {
            params.paramTbDate = tbDateArray;
            return tbDateArray;
        }

        static /* synthetic */ Timestamp[] access$702(Params params, Timestamp[] timestampArray) {
            params.paramTimestamp = timestampArray;
            return timestampArray;
        }

        static /* synthetic */ TbTimestamp[] access$802(Params params, TbTimestamp[] tbTimestampArray) {
            params.paramTbTimestamp = tbTimestampArray;
            return tbTimestampArray;
        }

        static /* synthetic */ Array[] access$902(Params params, Array[] arrayArray) {
            params.paramArray = arrayArray;
            return arrayArray;
        }

        static /* synthetic */ Struct[] access$1002(Params params, Struct[] structArray) {
            params.paramStruct = structArray;
            return structArray;
        }
    }
}

