/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class GB18030Encoder
implements CharsetEncoder {
    @Override
    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        try {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byte[] byArray2 = new String(cArray2).getBytes("GB18030");
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            return byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        throw TbError.newSQLException(-590714);
    }

    @Override
    public int getEndingBytePos(byte[] byArray, int n) {
        int n2 = this.getLeadingBytePos(byArray, n);
        if (byArray[n2] >= 0) {
            return n2;
        }
        if (byArray[n2 + 1] >= 48 && byArray[n2 + 1] <= 57) {
            return n2 + 3 <= n ? n2 + 3 : n2 - 1;
        }
        return n2 + 1 <= n ? n2 + 1 : n2 - 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 + n2 <= n) {
            if (byArray[n3 += n2] >= 0) {
                n2 = 1;
                continue;
            }
            if (byArray[n3 + 1] >= 48 && byArray[n3 + 1] <= 57) {
                n2 = 4;
                continue;
            }
            n2 = 2;
        }
        return n3;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 4;
    }

    @Override
    public boolean isEndingByte(byte[] byArray, int n) {
        return n == this.getEndingBytePos(byArray, n);
    }

    @Override
    public boolean isLeadingByte(byte[] byArray, int n) {
        return n == this.getLeadingBytePos(byArray, n);
    }

    @Override
    public byte[] stringToBytes(String string) throws SQLException {
        try {
            return string.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        try {
            byte[] byArray2 = string.getBytes("GB18030");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }
}

