/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class EUCTWEncoder
implements CharsetEncoder {
    @Override
    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        try {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byte[] byArray2 = new String(cArray2).getBytes("EUC-TW");
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            return byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        throw TbError.newSQLException(-590714);
    }

    @Override
    public int getEndingBytePos(byte[] byArray, int n) {
        if (byArray[n] > 0) {
            return n;
        }
        int n2 = this.getLeadingBytePos(byArray, n);
        if (byArray[n2] == -114) {
            return n2 + 3 > n ? n2 - 1 : n2 + 3;
        }
        return n2 + 1 > n ? n2 - 1 : n2 + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byArray, int n) {
        if (byArray[n] > 0 || byArray[n] == -114) {
            return n;
        }
        int n2 = 0;
        while (n - n2 > 0 && byArray[n - n2] <= 0 && byArray[n - n2] != -114) {
            ++n2;
        }
        if (byArray[n - n2] > 0) {
            return n2 % 2 == 0 ? n - 1 : n;
        }
        if (n2 < 4 && byArray[n - n2] == -114) {
            return n - n2;
        }
        return n2 % 2 == 0 ? n : n - 1;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 4;
    }

    @Override
    public boolean isEndingByte(byte[] byArray, int n) {
        return n == this.getEndingBytePos(byArray, n);
    }

    @Override
    public boolean isLeadingByte(byte[] byArray, int n) {
        return n == this.getLeadingBytePos(byArray, n);
    }

    @Override
    public byte[] stringToBytes(String string) throws SQLException {
        try {
            return string.getBytes("EUC-TW");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        try {
            byte[] byArray2 = string.getBytes("EUC-TW");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw TbError.newSQLException(-590714);
        }
    }
}

