/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.text.NumberFormat;

public class TbIntervalDts {
    private final int MID_INT = 0x40000000;
    public static final int TB_INTERVAL_DTS_SIZE = 12;
    private byte[] bytes;
    private int precision = 2;
    private int scale = 6;

    public TbIntervalDts(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        if (n >= 0) {
            this.precision = n;
        }
        if (n2 >= 0) {
            this.scale = n2;
        }
    }

    public TbIntervalDts(int n, int n2, int n3, int n4, int n5) {
        if (this.bytes == null) {
            this.bytes = new byte[12];
        }
        this.getBigEndianBytesFromInt(n, this.bytes, 0);
        int n6 = n2 * 3600 + n3 * 60 + n4;
        this.getBigEndianBytesFromInt(n6, this.bytes, 4);
        this.getBigEndianBytesFromInt(n5, this.bytes, 8);
    }

    public String toString() {
        int n = this.getIntFromBigEndianBytes(this.bytes, 0);
        int n2 = this.getIntFromBigEndianBytes(this.bytes, 4);
        int n3 = this.getIntFromBigEndianBytes(this.bytes, 8);
        boolean bl = n >= 0 && n2 >= 0 && n3 >= 0;
        n = Math.abs(n);
        n2 = Math.abs(n2);
        int n4 = n2 / 3600;
        int n5 = (n2 -= n4 * 3600) / 60;
        int n6 = n2 -= n5 * 60;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(2);
        NumberFormat numberFormat2 = NumberFormat.getInstance();
        numberFormat2.setGroupingUsed(false);
        numberFormat2.setMinimumIntegerDigits(9);
        n3 = Math.abs(n3);
        String string = numberFormat2.format(n3);
        string = string.substring(0, this.scale);
        NumberFormat numberFormat3 = NumberFormat.getInstance();
        numberFormat3.setGroupingUsed(false);
        numberFormat3.setMinimumIntegerDigits(this.precision);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("+");
        } else {
            stringBuffer.append("-");
        }
        stringBuffer.append(numberFormat3.format(n) + " " + numberFormat.format(n4) + ":" + numberFormat.format(n5) + ":" + numberFormat.format(n6) + "." + string);
        return stringBuffer.toString();
    }

    private int getIntFromBigEndianBytes(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 |= (0xFF & byArray[n + i]) << 8 * (3 - i);
        }
        return n2 -= 0x40000000;
    }

    private void getBigEndianBytesFromInt(int n, byte[] byArray, int n2) {
        TbCommon.int2Bytes(n += 0x40000000, byArray, n2, 4);
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

