/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.TbXMLInputStream;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbRAW;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public class TbArrayDataResultSet
implements TbResultSet {
    Object[] data;
    private int currentIndex;
    private int lastIndex;
    private int fetchSize;
    private boolean isRsetClosed;
    private boolean isNullData = false;
    private boolean lastColumnWasNull = false;
    DataTypeConverter typeConverter;
    private int dataType;
    private byte[] index;
    private byte[] value;
    private boolean fromBytes = true;
    private TbConnection conn;

    protected TbArrayDataResultSet(TbConnection tbConnection, TbArray tbArray, long l, int n, Map<String, Class<?>> map) throws SQLException {
        this.conn = tbConnection;
        this.dataType = tbArray.getDescriptor().getElementType();
        this.data = map == null ? (Object[])tbArray.getArray(l, n) : (Object[])tbArray.getArray(l, n, map);
        this.typeConverter = this.conn.getTypeConverter();
        this.currentIndex = -1;
        this.lastIndex = this.data == null ? -1 : this.data.length - 1;
        this.isRsetClosed = false;
        this.fetchSize = 50;
        if (this.lastIndex >= 0 && this.data[0] instanceof Array || this.data[0] instanceof Struct || this.data[0] instanceof Reader || this.data[0] instanceof InputStream || this.data[0] instanceof Clob || this.data[0] instanceof Blob || this.data[0] instanceof SQLData || this.data[0] instanceof Ref) {
            this.fromBytes = false;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isRsetClosed) {
            throw TbError.newSQLException(-90646);
        }
        ++this.currentIndex;
        if (this.currentIndex <= this.lastIndex) {
            this.index = this.typeConverter.castFromObject(new Integer(this.currentIndex + 1), 1);
            if (this.data[this.currentIndex] == null) {
                this.isNullData = true;
            } else if (this.fromBytes) {
                this.value = this.typeConverter.castFromObject(this.data[this.currentIndex], this.dataType);
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.isRsetClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (this.data[this.currentIndex] instanceof TbClobBase && n == 2) {
            long l = ((TbClobBase)this.data[this.currentIndex]).length();
            return ((TbClobBase)this.data[this.currentIndex]).getSubString(1L, (int)l);
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toString(byArray, 0, byArray.length, n2, -1, -1, false);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return false;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBoolean(byArray, 0, byArray.length, n2);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toByte(byArray, 0, byArray.length, n2);
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toShort(byArray, 0, byArray.length, n2);
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toInt(byArray, 0, byArray.length, n2);
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0L;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toLong(byArray, 0, byArray.length, n2);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0.0f;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toFloat(byArray, 0, byArray.length, n2);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return 0.0;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toDouble(byArray, 0, byArray.length, n2);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n3 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBigDecimal(byArray, 0, byArray.length, n3);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBytes((Object)byArray, 0, byArray.length, n2, false);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toDate(byArray, 0, byArray.length, n2);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toTime(byArray, 0, byArray.length, n2);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toTimestamp(byArray, 0, byArray.length, n2);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2) {
            if (this.data[this.currentIndex] instanceof InputStream) {
                return (InputStream)this.data[this.currentIndex];
            }
            if (this.data[this.currentIndex] instanceof byte[]) {
                return new ByteArrayInputStream((byte[])this.data[this.currentIndex]);
            }
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toUnicodeStream(byArray, 0, byArray.length, n2, false);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2) {
            if (this.data[this.currentIndex] instanceof InputStream) {
                return (InputStream)this.data[this.currentIndex];
            }
            if (this.data[this.currentIndex] instanceof Blob) {
                return ((TbBlob)this.data[this.currentIndex]).getBinaryStream();
            }
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBinaryStream(byArray, 0, byArray.length, n2);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (!this.fromBytes && n == 2) {
            return this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        int n3 = n2 == 16 ? -1 : DataType.getSqlType(n2);
        return this.typeConverter.toObject(byArray, 0, byArray.length, n2, n3, false);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        throw TbError.newSQLException(-90611, string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2) {
            if (this.data[this.currentIndex] instanceof Reader) {
                return (Reader)this.data[this.currentIndex];
            }
            if (this.data[this.currentIndex] instanceof Clob) {
                return ((TbClob)this.data[this.currentIndex]).getCharacterStream();
            }
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toCharacterStream(byArray, 0, byArray.length, n2);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBigDecimal(byArray, 0, byArray.length, n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.currentIndex < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentIndex > this.lastIndex;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentIndex == this.lastIndex;
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void afterLast() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean first() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean last() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.lastIndex == 0 || this.currentIndex < 0 || this.currentIndex > this.lastIndex) {
            return 0;
        }
        return this.currentIndex + 1;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean previous() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            this.fetchSize = 50;
        } else if (n > 0) {
            this.fetchSize = n;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void insertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void deleteRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        Map<String, Class<?>> map2 = map;
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        Object object = new Object();
        if (!this.fromBytes && n == 2) {
            Class<?> clazz;
            object = this.data[this.currentIndex];
            if (this.conn != null && this.data[this.currentIndex] instanceof SQLData) {
                object = (Struct)TbStruct.toStruct(this.data[this.currentIndex], this.conn);
            }
            if (map2 != null && object instanceof Struct && (clazz = ((TbStruct)object).getDescriptor().getClassWithExplicitMap(map2)) != null) {
                object = ((TbStruct)object).toClass(clazz, map2);
            }
            return object;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        int n3 = n2 == 16 ? -1 : DataType.getSqlType(n2);
        return this.typeConverter.toObject(byArray, 0, byArray.length, n2, n3, false);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2 && this.data[this.currentIndex] instanceof Ref) {
            return (Ref)this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toRef(byArray, 0, byArray.length, n2);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2 && this.data[this.currentIndex] instanceof Blob) {
            return (Blob)this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toBlob(byArray, 0, byArray.length, n2, false);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2 && this.data[this.currentIndex] instanceof Clob) {
            return (Clob)this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toClob(byArray, 0, byArray.length, n2, false);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2 && this.data[this.currentIndex] instanceof Array) {
            return (Array)this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toArray(byArray, 0, byArray.length, n2, false, null, null);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (calendar != null) {
            calendar.setTime(date);
            date = (Date)calendar.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (calendar != null) {
            calendar.setTime(time);
            time = (Time)calendar.getTime();
        }
        return time;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (calendar != null) {
            calendar.setTime(timestamp);
            timestamp = (Timestamp)calendar.getTime();
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        try {
            return new URL(this.getString(n));
        }
        catch (MalformedURLException malformedURLException) {
            throw TbError.newSQLException(-90651, malformedURLException.getMessage());
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toRowId(byArray, 0, byArray.length, n2);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isRsetClosed;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2 && this.data[this.currentIndex] instanceof NClob) {
            return (NClob)this.data[this.currentIndex];
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toNClob(byArray, 0, byArray.length, n2);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        Object object;
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2) {
            Object object2;
            if (this.data[this.currentIndex] instanceof SQLXML) {
                return (SQLXML)this.data[this.currentIndex];
            }
            if (this.data[this.currentIndex] instanceof TbStruct && ((TbTypeDescriptor)(object2 = ((TbStruct)this.data[this.currentIndex]).getDescriptor())).getOID().compareTo("00000000000000000000000000000001") == 0 && (object = (Object)((TbStruct)this.data[this.currentIndex]).getAttributes()[0]) instanceof TbClob) {
                TbXMLInputStream tbXMLInputStream = new TbXMLInputStream((TbClob)object);
                return new TbSQLXML(this.conn, tbXMLInputStream);
            }
            if (this.data[this.currentIndex] instanceof TbClob) {
                object2 = new TbXMLInputStream((TbClob)this.data[this.currentIndex]);
                return new TbSQLXML(this.conn, (TbXMLInputStream)object2);
            }
        }
        int n2 = this.getType(n);
        object = this.getData(n);
        return this.typeConverter.toSQLXML(object, 0, ((byte[])object).length, n2, false);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (this.data[this.currentIndex] instanceof TbNClob && n == 2) {
            long l = ((TbNClob)this.data[this.currentIndex]).length();
            return ((TbNClob)this.data[this.currentIndex]).getSubString(1L, (int)l);
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toString(byArray, 0, byArray.length, n2, -1, -1, false);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        if (n == 2) {
            if (this.data[this.currentIndex] instanceof Reader) {
                return (Reader)this.data[this.currentIndex];
            }
            if (this.data[this.currentIndex] instanceof NClob) {
                return ((TbNClob)this.data[this.currentIndex]).getCharacterStream();
            }
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toCharacterStream(byArray, 0, byArray.length, n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
    }

    @Override
    public void buildRowTable(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getBytes(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public TbRAW getRAW(int n) throws SQLException {
        return new TbRAW(this.getBytes(n));
    }

    @Override
    public TbRAW getRAW(String string) throws SQLException {
        return new TbRAW(this.getBytes(string));
    }

    @Override
    public Column[] getCols() throws SQLException {
        return null;
    }

    @Override
    public InputStream getLongByteStream(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public byte[] getRowChunk(int n) throws SQLException {
        return null;
    }

    @Override
    public RsetType getRsetType() {
        return null;
    }

    @Override
    public long getUpdateCount() {
        return 0L;
    }

    @Override
    public TbDate getTbDate(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toTbDate(byArray, 0, byArray.length, n2);
    }

    @Override
    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        int n2 = this.getType(n);
        byte[] byArray = this.getData(n);
        return this.typeConverter.toTbTimestamp(byArray, 0, byArray.length, n2);
    }

    @Override
    public void updateRAW(int n, TbRAW tbRAW) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateRAW(String string, TbRAW tbRAW) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public void updateTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        throw TbError.newSQLException(-90621);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public void setFetchCompleted(int n) throws SQLException {
    }

    @Override
    public void setHaveLocator(boolean bl) {
    }

    @Override
    public void setRsetType(RsetType rsetType) {
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    private byte[] getData(int n) {
        if (n == 1) {
            return this.index;
        }
        if (this.fromBytes) {
            return this.value;
        }
        return new byte[]{0};
    }

    private int getType(int n) {
        if (n == 1) {
            return 1;
        }
        return this.dataType;
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n <= 0 || n > 2) {
            throw TbError.newSQLException(-90609);
        }
    }

    private boolean setLastColumnIsNull(int n) {
        if (n == 1) {
            this.lastColumnWasNull = false;
            return false;
        }
        this.lastColumnWasNull = this.isNullData;
        return this.lastColumnWasNull;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        String string;
        switch (string = clazz.getName()) {
            case "java.sql.Array": {
                return (T)this.getObject(n);
            }
            case "java.io.InputStream": {
                return (T)this.getBinaryStream(n);
            }
            case "java.math.BigDecimal": {
                return (T)this.getBigDecimal(n);
            }
            case "java.sql.Blob": {
                return (T)this.getBlob(n);
            }
            case "java.lang.Byte": {
                return (T)new Byte(this.getByte(n));
            }
            case "byte[]": {
                return (T)this.getBytes(n);
            }
            case "java.io.Reader": {
                return (T)this.getCharacterStream(n);
            }
            case "java.sql.Clob": {
                return (T)this.getClob(n);
            }
            case "java.sql.Date": {
                return (T)this.getDate(n);
            }
            case "java.lang.Double": {
                return (T)new Double(this.getDouble(n));
            }
            case "java.lang.Float": {
                return (T)new Float(this.getFloat(n));
            }
            case "java.lang.Integer": {
                return (T)new Integer(this.getInt(n));
            }
            case "java.lang.Long": {
                return (T)new Long(this.getLong(n));
            }
            case "java.sql.NClob": {
                return (T)this.getNClob(n);
            }
            case "java.sql.Ref": {
                return (T)this.getRef(n);
            }
            case "java.sql.RowId": {
                return (T)this.getRowId(n);
            }
            case "java.lang.Short": {
                return (T)new Short(this.getShort(n));
            }
            case "java.sql.SQLXML": {
                return (T)this.getSQLXML(n);
            }
            case "java.lang.String": {
                return (T)this.getString(n);
            }
            case "java.sql.Time": {
                return (T)this.getTime(n);
            }
            case "java.sql.Timestamp": {
                return (T)this.getTimestamp(n);
            }
            case "java.time.LocalDate": {
                return (T)this.getDate(n).toLocalDate();
            }
            case "java.time.LocalTime": {
                return (T)this.getTime(n).toLocalTime();
            }
            case "java.time.LocalDateTime": {
                return (T)this.getTimestamp(n).toLocalDateTime();
            }
            case "java.time.OffsetTime": {
                return (T)this.getOffsetTime(n);
            }
            case "java.time.OffsetDateTime": {
                return (T)this.getOffsetDateTime(n);
            }
            case "java.net.URL": {
                return (T)this.getURL(n);
            }
        }
        return (T)this.getObject(n);
    }

    private OffsetTime getOffsetTime(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        byte[] byArray = this.getData(n);
        if (byArray.length == 17) {
            TimeZone timeZone = this.typeConverter.toTimeZoneFromBytes(byArray, 0, byArray.length);
            return OffsetTime.of(this.getTimestamp(n).toLocalDateTime().toLocalTime(), ZoneOffset.ofTotalSeconds(timeZone.getRawOffset() / 1000));
        }
        return OffsetTime.of(this.getTime(n).toLocalTime(), ZoneOffset.UTC);
    }

    private OffsetDateTime getOffsetDateTime(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnIsNull(n)) {
            return null;
        }
        byte[] byArray = this.getData(n);
        if (byArray.length == 17) {
            TimeZone timeZone = this.typeConverter.toTimeZoneFromBytes(byArray, 0, byArray.length);
            return OffsetDateTime.of(this.getTimestamp(n).toLocalDateTime(), ZoneOffset.ofTotalSeconds(timeZone.getRawOffset() / 1000));
        }
        return OffsetDateTime.of(this.getTimestamp(n).toLocalDateTime(), ZoneOffset.UTC);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }
}

